/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index;

import com.amazon.opendistroforelasticsearch.knn.index.KNNSettings;
import com.amazon.opendistroforelasticsearch.knn.index.KNNVectorIndexFieldData;
import com.amazon.opendistroforelasticsearch.knn.index.VectorField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParametrizedFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;

public class KNNVectorFieldMapper
extends ParametrizedFieldMapper {
    private static Logger logger = LogManager.getLogger(KNNVectorFieldMapper.class);
    public static final String CONTENT_TYPE = "knn_vector";
    public static final String KNN_FIELD = "knn_field";
    static final int MAX_DIMENSION = 10000;
    protected Explicit<Boolean> ignoreMalformed;
    private final boolean stored;
    private final boolean hasDocValues;
    protected final String spaceType;
    protected final String m;
    protected final String efConstruction;
    private final Integer dimension;

    private static KNNVectorFieldMapper toType(FieldMapper in) {
        return (KNNVectorFieldMapper)in;
    }

    public KNNVectorFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, String spaceType, String m, String efConstruction, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.stored = (Boolean)builder.stored.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.dimension = (Integer)builder.dimension.getValue();
        this.ignoreMalformed = ignoreMalformed;
        this.spaceType = spaceType;
        this.m = m;
        this.efConstruction = efConstruction;
        this.fieldType = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE);
        this.fieldType.putAttribute("spaceType", spaceType);
        this.fieldType.putAttribute("M", m);
        this.fieldType.putAttribute("efConstruction", efConstruction);
        this.fieldType.freeze();
    }

    public KNNVectorFieldMapper clone() {
        return (KNNVectorFieldMapper)super.clone();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        float value;
        if (!KNNSettings.isKNNPluginEnabled()) {
            throw new IllegalStateException("KNN plugin is disabled. To enable update knn.plugin.enabled setting to true");
        }
        if (KNNSettings.isCircuitBreakerTriggered()) {
            throw new IllegalStateException("Indexing knn vector fields is rejected as circuit breaker triggered. Check _opendistro/_knn/stats for detailed state");
        }
        context.path().add(this.simpleName());
        ArrayList<Float> vector = new ArrayList<Float>();
        XContentParser.Token token = context.parser().currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            token = context.parser().nextToken();
            while (token != XContentParser.Token.END_ARRAY) {
                value = context.parser().floatValue();
                if (Float.isNaN(value)) {
                    throw new IllegalArgumentException("KNN vector values cannot be NaN");
                }
                if (Float.isInfinite(value)) {
                    throw new IllegalArgumentException("KNN vector values cannot be infinity");
                }
                vector.add(Float.valueOf(value));
                token = context.parser().nextToken();
            }
        } else if (token == XContentParser.Token.VALUE_NUMBER) {
            value = context.parser().floatValue();
            if (Float.isNaN(value)) {
                throw new IllegalArgumentException("KNN vector values cannot be NaN");
            }
            if (Float.isInfinite(value)) {
                throw new IllegalArgumentException("KNN vector values cannot be infinity");
            }
            vector.add(Float.valueOf(value));
            context.parser().nextToken();
        }
        if (this.fieldType().dimension != vector.size()) {
            String errorMessage = String.format("Vector dimension mismatch. Expected: %d, Given: %d", this.fieldType().dimension, vector.size());
            throw new IllegalArgumentException(errorMessage);
        }
        float[] array = new float[vector.size()];
        int i = 0;
        for (Float f : vector) {
            array[i++] = f.floatValue();
        }
        VectorField point = new VectorField(this.name(), array, (IndexableFieldType)this.fieldType);
        context.doc().add((IndexableField)point);
        if (this.fieldType.stored()) {
            context.doc().add((IndexableField)new StoredField(this.name(), point.toString()));
        }
        context.path().remove();
    }

    protected boolean docValuesByDefault() {
        return true;
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.spaceType, this.m, this.efConstruction).init((FieldMapper)this);
    }

    public final boolean parsesArrayValue() {
        return true;
    }

    public KNNVectorFieldType fieldType() {
        return (KNNVectorFieldType)super.fieldType();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", (Boolean)this.ignoreMalformed.value());
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        protected Boolean ignoreMalformed;
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.boolParam((String)"store", (boolean)false, m -> KNNVectorFieldMapper.access$400(KNNVectorFieldMapper.toType(m)), (boolean)false);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.boolParam((String)"doc_values", (boolean)false, m -> KNNVectorFieldMapper.access$300(KNNVectorFieldMapper.toType(m)), (boolean)true);
        private final ParametrizedFieldMapper.Parameter<Integer> dimension = new ParametrizedFieldMapper.Parameter("dimension", false, () -> -1, (n, c, o) -> {
            if (o == null) {
                throw new IllegalArgumentException("Dimension cannot be null");
            }
            int value = XContentMapValues.nodeIntegerValue((Object)o);
            if (value > 10000) {
                throw new IllegalArgumentException("Dimension value cannot be greater than 10000 for vector: " + this.name);
            }
            if (value <= 0) {
                throw new IllegalArgumentException("Dimension value must be greater than 0 for vector: " + this.name);
            }
            return value;
        }, m -> KNNVectorFieldMapper.access$200(KNNVectorFieldMapper.toType(m)));
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private String spaceType;
        private String m;
        private String efConstruction;

        public Builder(String name) {
            super(name);
        }

        public Builder(String name, String spaceType, String m2, String efConstruction) {
            super(name);
            this.spaceType = spaceType;
            this.m = m2;
            this.efConstruction = efConstruction;
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.stored, this.hasDocValues, this.dimension, this.meta);
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit((Object)this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit((Object)((Boolean)FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings())), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public KNNVectorFieldMapper build(Mapper.BuilderContext context) {
            if (this.spaceType == null) {
                this.spaceType = this.getSpaceType(context.indexSettings());
            }
            if (this.m == null) {
                this.m = this.getM(context.indexSettings());
            }
            if (this.efConstruction == null) {
                this.efConstruction = this.getEfConstruction(context.indexSettings());
            }
            return new KNNVectorFieldMapper(this.name, new KNNVectorFieldType(this.buildFullName(context), (Map)this.meta.getValue(), (Integer)this.dimension.getValue()), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.ignoreMalformed(context), this.spaceType, this.m, this.efConstruction, this.copyTo.build(), this);
        }

        private String getSpaceType(Settings indexSettings) {
            String spaceType = indexSettings.get(KNNSettings.INDEX_KNN_SPACE_TYPE.getKey());
            if (spaceType == null) {
                logger.info("[KNN] The setting \"spaceType\" was not set for the index. Likely caused by recent version upgrade. Setting the setting to the default value=l2");
                return "l2";
            }
            return spaceType;
        }

        private String getM(Settings indexSettings) {
            String m = indexSettings.get(KNNSettings.INDEX_KNN_ALGO_PARAM_M_SETTING.getKey());
            if (m == null) {
                logger.info("[KNN] The setting \"M\" was not set for the index. Likely caused by recent version upgrade. Setting the setting to the default value=" + KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M);
                return String.valueOf(KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M);
            }
            return m;
        }

        private String getEfConstruction(Settings indexSettings) {
            String efConstruction = indexSettings.get(KNNSettings.INDEX_KNN_ALGO_PARAM_EF_CONSTRUCTION_SETTING.getKey());
            if (efConstruction == null) {
                logger.info("[KNN] The setting \"efConstruction\" was not set for the index. Likely caused by recent version upgrade. Setting the setting to the default value=" + KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION);
                return String.valueOf(KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION);
            }
            return efConstruction;
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit((Object)false, false);
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setDocValuesType(DocValuesType.BINARY);
            FIELD_TYPE.putAttribute(KNNVectorFieldMapper.KNN_FIELD, "true");
            FIELD_TYPE.freeze();
        }
    }

    public static class KNNVectorFieldType
    extends MappedFieldType {
        int dimension;

        public KNNVectorFieldType(String name, Map<String, String> meta, int dimension) {
            super(name, false, false, true, TextSearchInfo.NONE, meta);
            this.dimension = dimension;
        }

        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException("KNN Vector do not support fields search");
        }

        public String typeName() {
            return KNNVectorFieldMapper.CONTENT_TYPE;
        }

        public Query existsQuery(QueryShardContext context) {
            return new DocValuesFieldExistsQuery(this.name());
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "KNN vector do not support exact searching, use KNN queries instead: [" + this.name() + "]", new Object[0]);
        }

        public int getDimension() {
            return this.dimension;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new KNNVectorIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.BYTES);
        }
    }

    public static class Names {
        public static final String IGNORE_MALFORMED = "ignore_malformed";
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            builder.parse(name, parserContext, node);
            if ((Integer)builder.dimension.getValue() == -1) {
                throw new IllegalArgumentException("Dimension value missing for vector: " + name);
            }
            return builder;
        }
    }
}

