/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index;

import com.amazon.opendistroforelasticsearch.knn.index.KNNVectorScriptDocValues;
import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

public class KNNVectorDVLeafFieldData
implements LeafFieldData {
    private final LeafReader reader;
    private final String fieldName;

    public KNNVectorDVLeafFieldData(LeafReader reader, String fieldName) {
        this.reader = reader;
        this.fieldName = fieldName;
    }

    public void close() {
    }

    public long ramBytesUsed() {
        return 0L;
    }

    public ScriptDocValues<float[]> getScriptValues() {
        try {
            BinaryDocValues values = DocValues.getBinary((LeafReader)this.reader, (String)this.fieldName);
            return new KNNVectorScriptDocValues(values, this.fieldName);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values for knn vector field: " + this.fieldName, e);
        }
    }

    public SortedBinaryDocValues getBytesValues() {
        throw new UnsupportedOperationException("knn vector field '" + this.fieldName + "' doesn't support sorting");
    }
}

