/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index;

import com.amazon.opendistroforelasticsearch.knn.index.KNNWeight;
import com.amazon.opendistroforelasticsearch.knn.index.SpaceTypes;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsProbe;

public class KNNSettings {
    private static Logger logger = LogManager.getLogger(KNNSettings.class);
    private static KNNSettings INSTANCE;
    private static OsProbe osProbe;
    private static final int INDEX_THREAD_QTY_MAX = 32;
    public static final String KNN_SPACE_TYPE = "index.knn.space_type";
    public static final String KNN_ALGO_PARAM_M = "index.knn.algo_param.m";
    public static final String KNN_ALGO_PARAM_EF_CONSTRUCTION = "index.knn.algo_param.ef_construction";
    public static final String KNN_ALGO_PARAM_EF_SEARCH = "index.knn.algo_param.ef_search";
    public static final String KNN_ALGO_PARAM_INDEX_THREAD_QTY = "knn.algo_param.index_thread_qty";
    public static final String KNN_MEMORY_CIRCUIT_BREAKER_ENABLED = "knn.memory.circuit_breaker.enabled";
    public static final String KNN_MEMORY_CIRCUIT_BREAKER_LIMIT = "knn.memory.circuit_breaker.limit";
    public static final String KNN_CIRCUIT_BREAKER_TRIGGERED = "knn.circuit_breaker.triggered";
    public static final String KNN_CACHE_ITEM_EXPIRY_ENABLED = "knn.cache.item.expiry.enabled";
    public static final String KNN_CACHE_ITEM_EXPIRY_TIME_MINUTES = "knn.cache.item.expiry.minutes";
    public static final String KNN_PLUGIN_ENABLED = "knn.plugin.enabled";
    public static final String KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE = "knn.circuit_breaker.unset.percentage";
    public static final String KNN_INDEX = "index.knn";
    public static final String INDEX_KNN_DEFAULT_SPACE_TYPE = "l2";
    public static final Integer INDEX_KNN_DEFAULT_ALGO_PARAM_M;
    public static final Integer INDEX_KNN_DEFAULT_ALGO_PARAM_EF_SEARCH;
    public static final Integer INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION;
    public static final Integer KNN_DEFAULT_ALGO_PARAM_INDEX_THREAD_QTY;
    public static final Integer KNN_DEFAULT_CIRCUIT_BREAKER_UNSET_PERCENTAGE;
    public static final Setting<String> INDEX_KNN_SPACE_TYPE;
    public static final Setting<Integer> INDEX_KNN_ALGO_PARAM_M_SETTING;
    public static final Setting<Integer> INDEX_KNN_ALGO_PARAM_EF_SEARCH_SETTING;
    public static final Setting<Integer> INDEX_KNN_ALGO_PARAM_EF_CONSTRUCTION_SETTING;
    public static final Setting<Boolean> IS_KNN_INDEX_SETTING;
    public static final Setting<Integer> KNN_ALGO_PARAM_INDEX_THREAD_QTY_SETTING;
    public static final Setting<Boolean> KNN_CIRCUIT_BREAKER_TRIGGERED_SETTING;
    public static final Setting<Double> KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE_SETTING;
    public static Map<String, Setting<?>> dynamicCacheSettings;
    private final Map<String, Object> latestSettings = new ConcurrentHashMap<String, Object>();
    private ClusterService clusterService;
    private Client client;

    private KNNSettings() {
    }

    public static synchronized KNNSettings state() {
        if (INSTANCE == null) {
            INSTANCE = new KNNSettings();
        }
        return INSTANCE;
    }

    public void setSettingsUpdateConsumers() {
        for (Setting<?> setting : dynamicCacheSettings.values()) {
            this.clusterService.getClusterSettings().addSettingsUpdateConsumer(setting, newVal -> {
                logger.debug("The value of setting [{}] changed to [{}]", (Object)setting.getKey(), newVal);
                this.latestSettings.put(setting.getKey(), newVal);
                KNNWeight.knnIndexCache.rebuild();
            });
        }
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(KNN_CIRCUIT_BREAKER_TRIGGERED_SETTING, newVal -> this.latestSettings.put(KNN_CIRCUIT_BREAKER_TRIGGERED, newVal));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE_SETTING, newVal -> this.latestSettings.put(KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE, newVal));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(KNN_ALGO_PARAM_INDEX_THREAD_QTY_SETTING, newVal -> this.latestSettings.put(KNN_ALGO_PARAM_INDEX_THREAD_QTY, newVal));
    }

    public <T> T getSettingValue(String key) {
        return (T)this.latestSettings.getOrDefault(key, this.getSetting(key).getDefault(Settings.EMPTY));
    }

    public Setting<?> getSetting(String key) {
        if (dynamicCacheSettings.containsKey(key)) {
            return dynamicCacheSettings.get(key);
        }
        if (KNN_CIRCUIT_BREAKER_TRIGGERED.equals(key)) {
            return KNN_CIRCUIT_BREAKER_TRIGGERED_SETTING;
        }
        if (KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE.equals(key)) {
            return KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE_SETTING;
        }
        if (KNN_ALGO_PARAM_INDEX_THREAD_QTY.equals(key)) {
            return KNN_ALGO_PARAM_INDEX_THREAD_QTY_SETTING;
        }
        throw new IllegalArgumentException("Cannot find setting by key [" + key + "]");
    }

    public List<Setting<?>> getSettings() {
        List<Setting> settings = Arrays.asList(INDEX_KNN_SPACE_TYPE, INDEX_KNN_ALGO_PARAM_M_SETTING, INDEX_KNN_ALGO_PARAM_EF_CONSTRUCTION_SETTING, INDEX_KNN_ALGO_PARAM_EF_SEARCH_SETTING, KNN_ALGO_PARAM_INDEX_THREAD_QTY_SETTING, KNN_CIRCUIT_BREAKER_TRIGGERED_SETTING, KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE_SETTING, IS_KNN_INDEX_SETTING);
        return Stream.concat(settings.stream(), dynamicCacheSettings.values().stream()).collect(Collectors.toList());
    }

    public static boolean isKNNPluginEnabled() {
        return (Boolean)KNNSettings.state().getSettingValue(KNN_PLUGIN_ENABLED);
    }

    public static boolean isCircuitBreakerTriggered() {
        return (Boolean)KNNSettings.state().getSettingValue(KNN_CIRCUIT_BREAKER_TRIGGERED);
    }

    public static ByteSizeValue getCircuitBreakerLimit() {
        return (ByteSizeValue)KNNSettings.state().getSettingValue(KNN_MEMORY_CIRCUIT_BREAKER_LIMIT);
    }

    public static double getCircuitBreakerUnsetPercentage() {
        return (Double)KNNSettings.state().getSettingValue(KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE);
    }

    public void initialize(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
        this.setSettingsUpdateConsumers();
    }

    public static Setting<ByteSizeValue> knnMemoryCircuitBreakerSetting(String key, String defaultValue, Setting.Property ... properties) {
        return new Setting(key, defaultValue, s -> KNNSettings.parseknnMemoryCircuitBreakerValue(s, key), properties);
    }

    public static ByteSizeValue parseknnMemoryCircuitBreakerValue(String sValue, String settingName) {
        settingName = Objects.requireNonNull(settingName);
        if (sValue != null && sValue.endsWith("%")) {
            String percentAsString = sValue.substring(0, sValue.length() - 1);
            try {
                double percent = Double.parseDouble(percentAsString);
                if (percent < 0.0 || percent > 100.0) {
                    throw new ElasticsearchParseException("percentage should be in [0-100], got [{}]", new Object[]{percentAsString});
                }
                long physicalMemoryInBytes = osProbe.getTotalPhysicalMemorySize();
                if (physicalMemoryInBytes <= 0L) {
                    throw new IllegalStateException("Physical memory size could not be determined");
                }
                long esJvmSizeInBytes = JvmInfo.jvmInfo().getMem().getHeapMax().getBytes();
                long eligibleMemoryInBytes = physicalMemoryInBytes - esJvmSizeInBytes;
                return new ByteSizeValue((long)(percent / 100.0 * (double)eligibleMemoryInBytes), ByteSizeUnit.BYTES);
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchParseException("failed to parse [{}] as a double", (Throwable)e, new Object[]{percentAsString});
            }
        }
        return ByteSizeValue.parseBytesSizeValue((String)sValue, (String)settingName);
    }

    public synchronized void updateCircuitBreakerSettings(boolean flag) {
        final ClusterUpdateSettingsRequest clusterUpdateSettingsRequest = new ClusterUpdateSettingsRequest();
        Settings circuitBreakerSettings = Settings.builder().put(KNN_CIRCUIT_BREAKER_TRIGGERED, flag).build();
        clusterUpdateSettingsRequest.persistentSettings(circuitBreakerSettings);
        this.client.admin().cluster().updateSettings(clusterUpdateSettingsRequest, (ActionListener)new ActionListener<ClusterUpdateSettingsResponse>(){

            public void onResponse(ClusterUpdateSettingsResponse clusterUpdateSettingsResponse) {
                logger.debug("Cluster setting {}, acknowledged: {} ", (Object)clusterUpdateSettingsRequest.persistentSettings(), (Object)clusterUpdateSettingsResponse.isAcknowledged());
            }

            public void onFailure(Exception e) {
                logger.info("Exception while updating circuit breaker setting {} to {}", (Object)clusterUpdateSettingsRequest.persistentSettings(), (Object)e.getMessage());
            }
        });
    }

    public static int getEfSearchParam(String index) {
        return KNNSettings.getIndexSettingValue(index, KNN_ALGO_PARAM_EF_SEARCH, 512);
    }

    public static String getSpaceType(String index) {
        return KNNSettings.state().clusterService.state().getMetadata().index(index).getSettings().get(KNN_SPACE_TYPE, SpaceTypes.l2.getValue());
    }

    public static int getIndexSettingValue(String index, String settingName, int defaultValue) {
        return KNNSettings.state().clusterService.state().getMetadata().index(index).getSettings().getAsInt(settingName, Integer.valueOf(defaultValue));
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void onIndexModule(IndexModule module) {
        module.addSettingsUpdateConsumer(INDEX_KNN_ALGO_PARAM_EF_SEARCH_SETTING, newVal -> {
            logger.debug("The value of [KNN] setting [{}] changed to [{}]", (Object)KNN_ALGO_PARAM_EF_SEARCH, newVal);
            this.latestSettings.put(KNN_ALGO_PARAM_EF_SEARCH, newVal);
            KNNWeight.knnIndexCache.rebuild();
        });
    }

    static {
        osProbe = OsProbe.getInstance();
        INDEX_KNN_DEFAULT_ALGO_PARAM_M = 16;
        INDEX_KNN_DEFAULT_ALGO_PARAM_EF_SEARCH = 512;
        INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION = 512;
        KNN_DEFAULT_ALGO_PARAM_INDEX_THREAD_QTY = 1;
        KNN_DEFAULT_CIRCUIT_BREAKER_UNSET_PERCENTAGE = 75;
        INDEX_KNN_SPACE_TYPE = Setting.simpleString((String)KNN_SPACE_TYPE, (String)INDEX_KNN_DEFAULT_SPACE_TYPE, (Setting.Validator)new SpaceTypeValidator(), (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
        INDEX_KNN_ALGO_PARAM_M_SETTING = Setting.intSetting((String)KNN_ALGO_PARAM_M, (int)INDEX_KNN_DEFAULT_ALGO_PARAM_M, (int)2, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
        INDEX_KNN_ALGO_PARAM_EF_SEARCH_SETTING = Setting.intSetting((String)KNN_ALGO_PARAM_EF_SEARCH, (int)INDEX_KNN_DEFAULT_ALGO_PARAM_EF_SEARCH, (int)2, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.Dynamic});
        INDEX_KNN_ALGO_PARAM_EF_CONSTRUCTION_SETTING = Setting.intSetting((String)KNN_ALGO_PARAM_EF_CONSTRUCTION, (int)INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION, (int)2, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
        IS_KNN_INDEX_SETTING = Setting.boolSetting((String)KNN_INDEX, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
        KNN_ALGO_PARAM_INDEX_THREAD_QTY_SETTING = Setting.intSetting((String)KNN_ALGO_PARAM_INDEX_THREAD_QTY, (int)KNN_DEFAULT_ALGO_PARAM_INDEX_THREAD_QTY, (int)1, (int)32, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        KNN_CIRCUIT_BREAKER_TRIGGERED_SETTING = Setting.boolSetting((String)KNN_CIRCUIT_BREAKER_TRIGGERED, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE_SETTING = Setting.doubleSetting((String)KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE, (double)KNN_DEFAULT_CIRCUIT_BREAKER_UNSET_PERCENTAGE.intValue(), (double)0.0, (double)100.0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        dynamicCacheSettings = new HashMap<String, Setting<?>>(){
            {
                this.put(KNNSettings.KNN_PLUGIN_ENABLED, Setting.boolSetting((String)KNNSettings.KNN_PLUGIN_ENABLED, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
                this.put(KNNSettings.KNN_MEMORY_CIRCUIT_BREAKER_ENABLED, Setting.boolSetting((String)KNNSettings.KNN_MEMORY_CIRCUIT_BREAKER_ENABLED, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
                this.put(KNNSettings.KNN_MEMORY_CIRCUIT_BREAKER_LIMIT, KNNSettings.knnMemoryCircuitBreakerSetting(KNNSettings.KNN_MEMORY_CIRCUIT_BREAKER_LIMIT, "50%", Setting.Property.NodeScope, Setting.Property.Dynamic));
                this.put(KNNSettings.KNN_CACHE_ITEM_EXPIRY_ENABLED, Setting.boolSetting((String)KNNSettings.KNN_CACHE_ITEM_EXPIRY_ENABLED, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
                this.put(KNNSettings.KNN_CACHE_ITEM_EXPIRY_TIME_MINUTES, Setting.positiveTimeSetting((String)KNNSettings.KNN_CACHE_ITEM_EXPIRY_TIME_MINUTES, (TimeValue)TimeValue.timeValueHours((long)3L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
            }
        };
    }

    static class SpaceTypeValidator
    implements Setting.Validator<String> {
        private Set<String> types = SpaceTypes.getValues();

        SpaceTypeValidator() {
        }

        public void validate(String value) {
            if (value == null || !this.types.contains(value.toLowerCase())) {
                throw new InvalidParameterException(String.format("Unsupported space type: %s", value));
            }
        }
    }
}

