/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index;

import com.amazon.opendistroforelasticsearch.knn.index.KNNQuery;
import com.amazon.opendistroforelasticsearch.knn.plugin.stats.KNNCounter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;

public class KNNQueryBuilder
extends AbstractQueryBuilder<KNNQueryBuilder> {
    private static Logger logger = LogManager.getLogger(KNNQueryBuilder.class);
    public static final ParseField VECTOR_FIELD = new ParseField("vector", new String[0]);
    public static final ParseField K_FIELD = new ParseField("k", new String[0]);
    public static int K_MAX = 10000;
    public static final String NAME = "knn";
    private final String fieldName;
    private final float[] vector;
    private int k = 0;

    public KNNQueryBuilder(String fieldName, float[] vector, int k) {
        if (Strings.isNullOrEmpty((String)fieldName)) {
            throw new IllegalArgumentException("[knn] requires fieldName");
        }
        if (vector == null) {
            throw new IllegalArgumentException("[knn] requires query vector");
        }
        if (vector.length == 0) {
            throw new IllegalArgumentException("[knn] query vector is empty");
        }
        if (k <= 0) {
            throw new IllegalArgumentException("[knn] requires k > 0");
        }
        if (k > K_MAX) {
            throw new IllegalArgumentException("[knn] requires k <= " + K_MAX);
        }
        this.fieldName = fieldName;
        this.vector = vector;
        this.k = k;
    }

    private static float[] ObjectsToFloats(List<Object> objs) {
        float[] vec = new float[objs.size()];
        for (int i = 0; i < objs.size(); ++i) {
            vec[i] = ((Number)objs.get(i)).floatValue();
        }
        return vec;
    }

    public KNNQueryBuilder(StreamInput in) throws IOException {
        super(in);
        try {
            this.fieldName = in.readString();
            this.vector = in.readFloatArray();
            this.k = in.readInt();
        }
        catch (IOException ex) {
            throw new RuntimeException("[KNN] Unable to create KNNQueryBuilder: " + ex);
        }
    }

    public static KNNQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        List vector = null;
        float boost = 1.0f;
        int k = 0;
        String queryName = null;
        String currentFieldName = null;
        KNNCounter.KNN_QUERY_REQUESTS.increment();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                KNNQueryBuilder.throwParsingExceptionOnMultipleFields((String)NAME, (XContentLocation)parser.getTokenLocation(), fieldName, (String)currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue() || token == XContentParser.Token.START_ARRAY) {
                        if (VECTOR_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            vector = parser.list();
                            continue;
                        }
                        if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            boost = parser.floatValue();
                            continue;
                        }
                        if (K_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            k = parser.intValue();
                            continue;
                        }
                        if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            queryName = parser.text();
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "[knn] query does not support [" + currentFieldName + "]", new Object[0]);
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[knn] unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            KNNQueryBuilder.throwParsingExceptionOnMultipleFields((String)NAME, (XContentLocation)parser.getTokenLocation(), fieldName, (String)parser.currentName());
            fieldName = parser.currentName();
            vector = parser.list();
        }
        KNNQueryBuilder knnQuery = new KNNQueryBuilder(fieldName, KNNQueryBuilder.ObjectsToFloats(vector), k);
        knnQuery.queryName(queryName);
        knnQuery.boost(boost);
        return knnQuery;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeFloatArray(this.vector);
        out.writeInt(this.k);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Object vector() {
        return this.vector;
    }

    public int getK() {
        return this.k;
    }

    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(VECTOR_FIELD.getPreferredName(), (Object)this.vector);
        builder.field(K_FIELD.getPreferredName(), this.k);
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        return new KNNQuery(this.fieldName, this.vector, this.k, context.index().getName());
    }

    protected boolean doEquals(KNNQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.vector, other.vector) && Objects.equals(this.k, other.k);
    }

    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.vector, this.k);
    }

    public String getWriteableName() {
        return NAME;
    }
}

