/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index;

import com.amazon.opendistroforelasticsearch.knn.index.KNNSettings;
import com.amazon.opendistroforelasticsearch.knn.index.KNNWeight;
import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class KNNQuery
extends Query {
    private final String field;
    private final float[] queryVector;
    private final int k;
    private final String indexName;

    public KNNQuery(String field, float[] queryVector, int k, String indexName) {
        this.field = field;
        this.queryVector = queryVector;
        this.k = k;
        this.indexName = indexName;
    }

    public String getField() {
        return this.field;
    }

    public float[] getQueryVector() {
        return this.queryVector;
    }

    public int getK() {
        return this.k;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        if (!KNNSettings.isKNNPluginEnabled()) {
            throw new IllegalStateException("KNN plugin is disabled. To enable update knn.plugin.enabled to true");
        }
        return new KNNWeight(this, boost);
    }

    public String toString(String field) {
        return field;
    }

    public int hashCode() {
        return this.field.hashCode() ^ this.queryVector.hashCode() ^ this.k;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((KNNQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(KNNQuery other) {
        return this.field.equals(other.getField()) && this.queryVector.equals(other.getQueryVector()) && this.k == other.getK();
    }
}

