/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index;

import com.amazon.opendistroforelasticsearch.knn.index.KNNIndexCache;
import com.amazon.opendistroforelasticsearch.knn.index.v2011.KNNIndex;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardPath;

public class KNNIndexShard {
    private IndexShard indexShard;
    private KNNIndexCache knnIndexCache;
    private static Logger logger = LogManager.getLogger(KNNIndexShard.class);

    public KNNIndexShard(IndexShard indexShard) {
        this.indexShard = indexShard;
        this.knnIndexCache = KNNIndexCache.getInstance();
    }

    public IndexShard getIndexShard() {
        return this.indexShard;
    }

    public String getIndexName() {
        return this.indexShard.shardId().getIndexName();
    }

    public List<KNNIndex> warmup() throws IOException {
        List<KNNIndex> indices;
        logger.info("[KNN] Warming up index: " + this.getIndexName());
        try (Engine.Searcher searcher = this.indexShard.acquireSearcher("knn-warmup");){
            indices = this.knnIndexCache.getIndices(this.getHNSWPaths(searcher.getIndexReader()), this.getIndexName());
        }
        return indices;
    }

    public List<String> getHNSWPaths(IndexReader indexReader) throws IOException {
        ArrayList<String> hnswFiles = new ArrayList<String>();
        for (LeafReaderContext leafReaderContext : indexReader.leaves()) {
            SegmentReader reader = (SegmentReader)FilterLeafReader.unwrap((LeafReader)leafReaderContext.reader());
            Path shardPath = ((FSDirectory)FilterDirectory.unwrap((Directory)reader.directory())).getDirectory();
            hnswFiles.addAll(reader.getSegmentInfo().files().stream().filter(fileName -> fileName.endsWith(this.getHNSWFileExtension(reader.getSegmentInfo().info))).map(fileName -> shardPath.resolve((String)fileName).toString()).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return hnswFiles;
    }

    private ShardPath shardPath() {
        return this.indexShard.shardPath();
    }

    private String getHNSWFileExtension(SegmentInfo info) {
        return info.getUseCompoundFile() ? ".hnswc" : ".hnsw";
    }
}

