/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index;

import com.amazon.opendistroforelasticsearch.knn.index.KNNSettings;
import com.amazon.opendistroforelasticsearch.knn.index.KNNWeight;
import com.amazon.opendistroforelasticsearch.knn.plugin.stats.KNNStatsConfig;
import com.amazon.opendistroforelasticsearch.knn.plugin.stats.StatNames;
import com.amazon.opendistroforelasticsearch.knn.plugin.transport.KNNStatsAction;
import com.amazon.opendistroforelasticsearch.knn.plugin.transport.KNNStatsNodeResponse;
import com.amazon.opendistroforelasticsearch.knn.plugin.transport.KNNStatsRequest;
import com.amazon.opendistroforelasticsearch.knn.plugin.transport.KNNStatsResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;

public class KNNCircuitBreaker {
    private static Logger logger = LogManager.getLogger(KNNCircuitBreaker.class);
    public static int CB_TIME_INTERVAL = 120;
    private static KNNCircuitBreaker INSTANCE;
    private ThreadPool threadPool;
    private ClusterService clusterService;
    private Client client;

    private KNNCircuitBreaker() {
    }

    public static synchronized KNNCircuitBreaker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KNNCircuitBreaker();
        }
        return INSTANCE;
    }

    public static synchronized void setInstance(KNNCircuitBreaker instance) {
        INSTANCE = instance;
    }

    public void initialize(ThreadPool threadPool, ClusterService clusterService, Client client) {
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.client = client;
        Runnable runnable = () -> {
            if (KNNWeight.knnIndexCache.isCacheCapacityReached().booleanValue() && clusterService.localNode().isDataNode()) {
                long currentSizeKiloBytes = KNNWeight.knnIndexCache.getWeightInKilobytes();
                long circuitBreakerLimitSizeKiloBytes = KNNSettings.getCircuitBreakerLimit().getKb();
                long circuitBreakerUnsetSizeKiloBytes = (long)(KNNSettings.getCircuitBreakerUnsetPercentage() / 100.0 * (double)circuitBreakerLimitSizeKiloBytes);
                if (currentSizeKiloBytes <= circuitBreakerUnsetSizeKiloBytes) {
                    KNNWeight.knnIndexCache.setCacheCapacityReached(false);
                }
            }
            if (KNNSettings.isCircuitBreakerTriggered() && clusterService.state().nodes().isLocalNodeElectedMaster()) {
                KNNStatsRequest knnStatsRequest = new KNNStatsRequest(KNNStatsConfig.KNN_STATS.keySet(), new String[0]);
                knnStatsRequest.addStat(StatNames.CACHE_CAPACITY_REACHED.getName());
                knnStatsRequest.timeout(new TimeValue(10000L));
                try {
                    KNNStatsResponse knnStatsResponse = (KNNStatsResponse)((Object)((Object)client.execute((ActionType)KNNStatsAction.INSTANCE, (ActionRequest)knnStatsRequest).get()));
                    List nodeResponses = knnStatsResponse.getNodes();
                    ArrayList<String> nodesAtMaxCapacity = new ArrayList<String>();
                    for (KNNStatsNodeResponse nodeResponse : nodeResponses) {
                        if (!((Boolean)nodeResponse.getStatsMap().get(StatNames.CACHE_CAPACITY_REACHED.getName())).booleanValue()) continue;
                        nodesAtMaxCapacity.add(nodeResponse.getNode().getId());
                    }
                    if (!nodesAtMaxCapacity.isEmpty()) {
                        logger.info("[KNN] knn.circuit_breaker.triggered stays set. Nodes at max cache capacity: " + String.join((CharSequence)",", nodesAtMaxCapacity) + ".");
                    } else {
                        logger.info("[KNN] Cache capacity below 75% of the circuit breaker limit for all nodes. Unsetting knn.circuit_breaker.triggered flag.");
                        KNNSettings.state().updateCircuitBreakerSettings(false);
                    }
                }
                catch (Exception e) {
                    logger.error("[KNN] Exception getting stats: " + e);
                }
            }
        };
        this.threadPool.scheduleWithFixedDelay(runnable, TimeValue.timeValueSeconds((long)CB_TIME_INTERVAL), "generic");
    }
}

