/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule;

import com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule.CronSchedule;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule.IntervalSchedule;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule.Schedule;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public class ScheduleParser {
    public static Schedule parse(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        if (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "cron": {
                    String expression = null;
                    ZoneId timezone = null;
                    block26: while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
                        String cronField = parser.currentName();
                        parser.nextToken();
                        switch (cronField) {
                            case "expression": {
                                expression = parser.text();
                                continue block26;
                            }
                            case "timezone": {
                                timezone = ZoneId.of(parser.text());
                                continue block26;
                            }
                        }
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown cron field %s", cronField));
                    }
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    parser.nextToken();
                    return new CronSchedule(expression, timezone);
                }
                case "interval": {
                    Instant startTime = null;
                    int period = 0;
                    ChronoUnit unit = null;
                    block27: while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
                        String intervalField = parser.currentName();
                        parser.nextToken();
                        switch (intervalField) {
                            case "start_time": {
                                startTime = Instant.ofEpochMilli(parser.longValue());
                                continue block27;
                            }
                            case "period": {
                                period = parser.intValue();
                                continue block27;
                            }
                            case "unit": {
                                unit = ChronoUnit.valueOf(parser.text().toUpperCase(Locale.ROOT));
                                continue block27;
                            }
                        }
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown interval field %s", intervalField));
                    }
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    parser.nextToken();
                    return new IntervalSchedule(startTime, period, unit);
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown schedule type %s", fieldName));
        }
        throw new IllegalArgumentException("Invalid schedule document object.");
    }
}

