/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule;

import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.utils.VisibleForTesting;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule.Schedule;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class IntervalSchedule
implements Schedule {
    static final String START_TIME_FIELD = "start_time";
    static final String INTERVAL_FIELD = "interval";
    static final String PERIOD_FIELD = "period";
    static final String UNIT_FIELD = "unit";
    private static final Set<ChronoUnit> SUPPORTED_UNITS;
    private Instant startTime;
    private int interval;
    private ChronoUnit unit;
    private transient long intervalInMillis;
    private Clock clock;

    public IntervalSchedule(Instant startTime, int interval, ChronoUnit unit) {
        if (!SUPPORTED_UNITS.contains(unit)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Interval unit %s is not supported, expects %s", unit, SUPPORTED_UNITS));
        }
        this.startTime = startTime;
        this.interval = interval;
        this.unit = unit;
        this.intervalInMillis = Duration.of(interval, this.unit).toMillis();
        this.clock = Clock.system(ZoneId.systemDefault());
    }

    public IntervalSchedule(StreamInput input) throws IOException {
        this.startTime = input.readInstant();
        this.interval = input.readInt();
        this.unit = (ChronoUnit)input.readEnum(ChronoUnit.class);
        this.intervalInMillis = Duration.of(this.interval, this.unit).toMillis();
        this.clock = Clock.system(ZoneId.systemDefault());
    }

    @VisibleForTesting
    Instant getStartTime() {
        return this.startTime;
    }

    @VisibleForTesting
    public int getInterval() {
        return this.interval;
    }

    public ChronoUnit getUnit() {
        return this.unit;
    }

    @Override
    public Instant getNextExecutionTime(Instant time) {
        Instant baseTime = time == null ? this.clock.instant() : time;
        long delta = (baseTime.toEpochMilli() - this.startTime.toEpochMilli()) % this.intervalInMillis;
        long remaining = this.intervalInMillis - delta;
        return baseTime.plus(remaining, ChronoUnit.MILLIS);
    }

    @Override
    public Duration nextTimeToExecute() {
        long enabledTimeEpochMillis = this.startTime.toEpochMilli();
        Instant currentTime = this.clock.instant();
        long delta = currentTime.toEpochMilli() - enabledTimeEpochMillis;
        long remainingScheduleTime = this.intervalInMillis - delta % this.intervalInMillis;
        return Duration.of(remainingScheduleTime, ChronoUnit.MILLIS);
    }

    @Override
    public Tuple<Instant, Instant> getPeriodStartingAt(Instant startTime) {
        Instant realStartTime = startTime == null ? this.clock.instant() : startTime;
        Instant newEndTime = realStartTime.plusMillis(this.intervalInMillis);
        return new Tuple((Object)realStartTime, (Object)newEndTime);
    }

    @Override
    @SuppressForbidden(reason="Ignore forbidden api Math.abs()")
    public Boolean runningOnTime(Instant lastExecutionTime) {
        if (lastExecutionTime == null) {
            return true;
        }
        long enabledTimeEpochMillis = this.startTime.toEpochMilli();
        Instant now = this.clock.instant();
        long expectedMillisSinceLastExecution = (now.toEpochMilli() - enabledTimeEpochMillis) % this.intervalInMillis;
        if (expectedMillisSinceLastExecution < 1000L) {
            expectedMillisSinceLastExecution = this.intervalInMillis + expectedMillisSinceLastExecution;
        }
        long expectedLastExecutionTime = now.toEpochMilli() - expectedMillisSinceLastExecution;
        long expectedCurrentExecutionTime = expectedLastExecutionTime + this.intervalInMillis;
        return Math.abs(lastExecutionTime.toEpochMilli() - expectedLastExecutionTime) < 1000L || Math.abs(lastExecutionTime.toEpochMilli() - expectedCurrentExecutionTime) < 1000L;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().startObject(INTERVAL_FIELD).field(START_TIME_FIELD, this.startTime.toEpochMilli()).field(PERIOD_FIELD, this.interval).field(UNIT_FIELD, (Object)this.unit).endObject().endObject();
        return builder;
    }

    @VisibleForTesting
    void setClock(Clock clock) {
        this.clock = clock;
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)false, (boolean)true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalSchedule intervalSchedule = (IntervalSchedule)o;
        return this.startTime.equals(intervalSchedule.startTime) && this.interval == intervalSchedule.interval && this.unit == intervalSchedule.unit && this.intervalInMillis == intervalSchedule.intervalInMillis;
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.interval, this.unit, this.intervalInMillis);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInstant(this.startTime);
        out.writeInt(this.interval);
        out.writeEnum((Enum)this.unit);
    }

    static {
        HashSet<ChronoUnit> set = new HashSet<ChronoUnit>();
        set.add(ChronoUnit.MINUTES);
        set.add(ChronoUnit.HOURS);
        set.add(ChronoUnit.DAYS);
        SUPPORTED_UNITS = Collections.unmodifiableSet(set);
    }
}

