/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule;

import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.CronType;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.definition.CronDefinitionBuilder;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.time.ExecutionTime;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.parser.CronParser;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.utils.VisibleForTesting;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule.Schedule;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class CronSchedule
implements Schedule {
    static final String CRON_FIELD = "cron";
    static final String EXPRESSION_FIELD = "expression";
    static final String TIMEZONE_FIELD = "timezone";
    private static CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor(CronType.UNIX));
    private ZoneId timezone;
    private String expression;
    private ExecutionTime executionTime;
    private Clock clock;

    public CronSchedule(String expression, ZoneId timezone) {
        this.expression = expression;
        this.timezone = timezone;
        this.executionTime = ExecutionTime.forCron(cronParser.parse(this.expression));
        this.clock = Clock.system(timezone);
    }

    public CronSchedule(StreamInput input) throws IOException {
        this.timezone = input.readZoneId();
        this.expression = input.readString();
        this.executionTime = ExecutionTime.forCron(cronParser.parse(this.expression));
        this.clock = Clock.system(this.timezone);
    }

    @VisibleForTesting
    void setClock(Clock clock) {
        this.clock = clock;
    }

    @VisibleForTesting
    void setExecutionTime(ExecutionTime executionTime) {
        this.executionTime = executionTime;
    }

    @VisibleForTesting
    ZoneId getTimeZone() {
        return this.timezone;
    }

    @VisibleForTesting
    String getCronExpression() {
        return this.expression;
    }

    @Override
    public Instant getNextExecutionTime(Instant time) {
        Instant baseTime = time == null ? this.clock.instant() : time;
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(baseTime, this.timezone);
        ZonedDateTime nextExecutionTime = this.executionTime.nextExecution(zonedDateTime).orElse(null);
        return nextExecutionTime == null ? null : nextExecutionTime.toInstant();
    }

    @Override
    public Duration nextTimeToExecute() {
        Instant now = this.clock.instant();
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(now, this.timezone);
        Optional<Duration> timeToNextExecution = this.executionTime.timeToNextExecution(zonedDateTime);
        return timeToNextExecution.orElse(null);
    }

    @Override
    public Tuple<Instant, Instant> getPeriodStartingAt(Instant startTime) {
        Instant realStartTime;
        if (startTime != null) {
            realStartTime = startTime;
        } else {
            Instant now = this.clock.instant();
            Optional<ZonedDateTime> lastExecutionTime = this.executionTime.lastExecution(ZonedDateTime.ofInstant(now, this.timezone));
            if (!lastExecutionTime.isPresent()) {
                return new Tuple((Object)now, (Object)now);
            }
            realStartTime = lastExecutionTime.get().toInstant();
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(realStartTime, this.timezone);
        ZonedDateTime newEndTime = this.executionTime.nextExecution(zonedDateTime).orElse(null);
        return new Tuple((Object)realStartTime, (Object)(newEndTime == null ? null : newEndTime.toInstant()));
    }

    @Override
    public Boolean runningOnTime(Instant lastExecutionTime) {
        if (lastExecutionTime == null) {
            return true;
        }
        Instant now = this.clock.instant();
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(now, this.timezone);
        Optional<ZonedDateTime> expectedExecutionTime = this.executionTime.lastExecution(zonedDateTime);
        if (!expectedExecutionTime.isPresent()) {
            return false;
        }
        ZonedDateTime actualExecutionTime = ZonedDateTime.ofInstant(lastExecutionTime, this.timezone);
        return ChronoUnit.SECONDS.between(expectedExecutionTime.get(), actualExecutionTime) == 0L;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().startObject(CRON_FIELD).field(EXPRESSION_FIELD, this.expression).field(TIMEZONE_FIELD, this.timezone.getId()).endObject().endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)false, (boolean)true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CronSchedule cronSchedule = (CronSchedule)o;
        return this.timezone.equals(cronSchedule.timezone) && this.expression.equals(cronSchedule.expression);
    }

    public int hashCode() {
        return Objects.hash(this.timezone, this.expression);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeZoneId(this.timezone);
        out.writeString(this.expression);
    }
}

