/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.time.generator;

import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.mapper.ConstantsMapper;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.mapper.WeekDay;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.CronField;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.CronFieldName;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.expression.Every;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.time.generator.EveryFieldValueGenerator;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.time.generator.NoSuchValueException;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.utils.Preconditions;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

class EveryDayOfWeekValueGenerator
extends EveryFieldValueGenerator {
    private final int lastDayOfMonth;
    private int year;
    private int month;
    private final Set<DayOfWeek> dowValidValues;

    EveryDayOfWeekValueGenerator(CronField cronField, int year, int month, WeekDay mondayDoWValue) {
        super(cronField);
        Preconditions.checkArgument(CronFieldName.DAY_OF_WEEK.equals((Object)cronField.getField()), "CronField does not belong to day of week");
        this.year = year;
        this.month = month;
        LocalDate date = LocalDate.of(year, month, 1);
        this.lastDayOfMonth = date.lengthOfMonth();
        Every every = (Every)cronField.getExpression();
        int period = every.getPeriod().getValue();
        Preconditions.checkArgument(period > 0 && period < 8, "Cron Expression for day of week has an invalid period.");
        this.dowValidValues = EveryDayOfWeekValueGenerator.getValidDays(mondayDoWValue, period, this.from, this.to);
    }

    private static Set<DayOfWeek> getValidDays(WeekDay mondayDoWValue, int period, int from, int to) {
        ArrayList<DayOfWeek> validDays = new ArrayList<DayOfWeek>(7);
        for (int day = from; day <= to; day += period) {
            int javaDay = ConstantsMapper.weekDayMapping(mondayDoWValue, ConstantsMapper.JAVA8, day);
            validDays.add(DayOfWeek.of(javaDay));
        }
        return EnumSet.copyOf(validDays);
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        int day = reference;
        while (!this.isMatch(++day) && day <= this.lastDayOfMonth) {
        }
        if (day > this.lastDayOfMonth) {
            throw new NoSuchValueException();
        }
        return day;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        int day = reference;
        while (!this.isMatch(--day) && day > 0) {
        }
        if (day <= 0) {
            throw new NoSuchValueException();
        }
        return day;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList<Integer> candidates = new ArrayList<Integer>();
        int reference = start;
        try {
            while (reference < end) {
                if ((reference = this.generateNextValue(reference)) >= end) continue;
                candidates.add(reference);
            }
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        return candidates;
    }

    @Override
    public boolean isMatch(int value) {
        if (value > this.lastDayOfMonth || value < 1) {
            return false;
        }
        DayOfWeek dayOfWeek = LocalDate.of(this.year, this.month, value).getDayOfWeek();
        return this.dowValidValues.contains(dayOfWeek);
    }
}

