/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.descriptor;

import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.Function;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.descriptor.DescriptionStrategy;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.expression.Always;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.expression.And;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.expression.Between;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.expression.Every;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.expression.FieldExpression;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.expression.On;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.value.IntegerFieldValue;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.utils.Preconditions;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;

class TimeDescriptionStrategy
extends DescriptionStrategy {
    private final FieldExpression hours;
    private final FieldExpression minutes;
    private final FieldExpression seconds;
    private final Set<Function<TimeFields, String>> descriptions;
    private static final int DEFAULTSECONDS = 0;
    private static final String EVERY = "every";
    private static final String SECOND = "second";
    private static final String MINUTE = "minute";
    private static final String EVERY_MINUTE_FORMAT = "%s %s ";

    TimeDescriptionStrategy(ResourceBundle bundle, FieldExpression hours, FieldExpression minutes, FieldExpression seconds) {
        super(bundle);
        this.hours = this.ensureInstance(hours, FieldExpression.always());
        this.minutes = this.ensureInstance(minutes, FieldExpression.always());
        this.seconds = this.ensureInstance(seconds, new On(new IntegerFieldValue(0)));
        this.descriptions = new HashSet<Function<TimeFields, String>>();
        this.registerFunctions();
    }

    private FieldExpression ensureInstance(FieldExpression expression, FieldExpression defaultExpression) {
        Preconditions.checkNotNull(defaultExpression, "Default expression must not be null");
        if (expression != null) {
            return expression;
        }
        return defaultExpression;
    }

    @Override
    public String describe() {
        TimeFields fields = new TimeFields(this.hours, this.minutes, this.seconds);
        for (Function<TimeFields, String> function : this.descriptions) {
            if ("".equals(function.apply(fields))) continue;
            return function.apply(fields);
        }
        String secondsDesc = "";
        String minutesDesc = "";
        String hoursDesc = this.addTimeExpressions(this.describe(this.hours), this.bundle.getString("hour"), this.bundle.getString("hours"));
        if (!(this.seconds instanceof On) || !this.isDefault((On)this.seconds)) {
            secondsDesc = this.addTimeExpressions(this.describe(this.seconds), this.bundle.getString(SECOND), this.bundle.getString("seconds"));
        }
        if (!(this.minutes instanceof On) || !this.isDefault((On)this.minutes)) {
            minutesDesc = this.addTimeExpressions(this.describe(this.minutes), this.bundle.getString(MINUTE), this.bundle.getString("minutes"));
        }
        return String.format("%s %s %s", secondsDesc, minutesDesc, hoursDesc);
    }

    private String addTimeExpressions(String description, String singular, String plural) {
        return description.replaceAll("%s", singular).replaceAll("replace_plural", plural);
    }

    private void registerFunctions() {
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof Always && ((TimeFields)timeFields).minutes instanceof Always) {
                if (((TimeFields)timeFields).seconds instanceof Always) {
                    return String.format(EVERY_MINUTE_FORMAT, this.bundle.getString(EVERY), this.bundle.getString(SECOND));
                }
                if (((TimeFields)timeFields).seconds instanceof On) {
                    if (this.isDefault((On)((TimeFields)timeFields).seconds)) {
                        return String.format(EVERY_MINUTE_FORMAT, this.bundle.getString(EVERY), this.bundle.getString(MINUTE));
                    }
                    return String.format("%s %s %s %s %02d", this.bundle.getString(EVERY), this.bundle.getString(MINUTE), this.bundle.getString("at"), this.bundle.getString(SECOND), ((On)((TimeFields)timeFields).seconds).getTime().getValue());
                }
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof Always && ((TimeFields)timeFields).minutes instanceof On && ((TimeFields)timeFields).seconds instanceof On) {
                if (this.isDefault((On)((TimeFields)timeFields).seconds)) {
                    if (this.isDefault((On)((TimeFields)timeFields).minutes)) {
                        return String.format(EVERY_MINUTE_FORMAT, this.bundle.getString(EVERY), this.bundle.getString("hour"));
                    }
                    return String.format("%s %s %s %s %s", this.bundle.getString(EVERY), this.bundle.getString("hour"), this.bundle.getString("at"), this.bundle.getString(MINUTE), ((On)((TimeFields)timeFields).minutes).getTime().getValue());
                }
                return String.format("%s %s %s %s %s %s %s %s", this.bundle.getString(EVERY), this.bundle.getString("hour"), this.bundle.getString("at"), this.bundle.getString(MINUTE), ((On)((TimeFields)timeFields).minutes).getTime().getValue(), this.bundle.getString("and"), this.bundle.getString(SECOND), ((On)((TimeFields)timeFields).seconds).getTime().getValue());
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof On && ((TimeFields)timeFields).minutes instanceof On && ((TimeFields)timeFields).seconds instanceof Always) {
                return String.format("%s %s %s %02d:%02d", this.bundle.getString(EVERY), this.bundle.getString(SECOND), this.bundle.getString("at"), ((On)this.hours).getTime().getValue(), ((On)this.minutes).getTime().getValue());
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof On && ((TimeFields)timeFields).minutes instanceof On && ((TimeFields)timeFields).seconds instanceof On) {
                if (this.isDefault((On)((TimeFields)timeFields).seconds)) {
                    return String.format("%s %02d:%02d", this.bundle.getString("at"), ((On)this.hours).getTime().getValue(), ((On)this.minutes).getTime().getValue());
                }
                return String.format("%s %02d:%02d:%02d", this.bundle.getString("at"), ((On)this.hours).getTime().getValue(), ((On)this.minutes).getTime().getValue(), ((On)this.seconds).getTime().getValue());
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof On && ((TimeFields)timeFields).minutes instanceof Always && ((TimeFields)timeFields).seconds instanceof Always) {
                return String.format("%s %02d:00", this.bundle.getString("at"), ((On)this.hours).getTime().getValue());
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof On && ((TimeFields)timeFields).minutes instanceof Between) {
                if (((TimeFields)timeFields).seconds instanceof On) {
                    return String.format("%s %s %s %02d:%02d %s %02d:%02d", this.bundle.getString(EVERY), this.bundle.getString(MINUTE), this.bundle.getString("between"), ((On)((TimeFields)timeFields).hours).getTime().getValue(), ((Between)((TimeFields)timeFields).minutes).getFrom().getValue(), this.bundle.getString("and"), ((On)((TimeFields)timeFields).hours).getTime().getValue(), ((Between)((TimeFields)timeFields).minutes).getTo().getValue());
                }
                if (((TimeFields)timeFields).seconds instanceof Always) {
                    return String.format("%s %s %s %02d:%02d %s %02d:%02d", this.bundle.getString(EVERY), this.bundle.getString(SECOND), this.bundle.getString("between"), ((On)((TimeFields)timeFields).hours).getTime().getValue(), ((Between)((TimeFields)timeFields).minutes).getFrom().getValue(), this.bundle.getString("and"), ((On)((TimeFields)timeFields).hours).getTime().getValue(), ((Between)((TimeFields)timeFields).minutes).getTo().getValue());
                }
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof Always && ((TimeFields)timeFields).minutes instanceof Every && ((TimeFields)timeFields).seconds instanceof On) {
                Every minute = (Every)((TimeFields)timeFields).minutes;
                String desc = minute.getPeriod().getValue() == 1 && this.isDefault((On)((TimeFields)timeFields).seconds) ? String.format(EVERY_MINUTE_FORMAT, this.bundle.getString(EVERY), this.bundle.getString(MINUTE)) : String.format("%s %s %s ", this.bundle.getString(EVERY), minute.getPeriod().getValue(), this.bundle.getString("minutes"));
                if (minute.getExpression() instanceof Between) {
                    return "";
                }
                return desc;
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof Every && ((TimeFields)timeFields).minutes instanceof On && ((TimeFields)timeFields).seconds instanceof On) {
                Integer period;
                if (((On)((TimeFields)timeFields).minutes).getTime().getValue() == 0 && ((On)((TimeFields)timeFields).seconds).getTime().getValue() == 0 && ((period = ((Every)((TimeFields)timeFields).hours).getPeriod().getValue()) == null || period == 1)) {
                    return String.format(EVERY_MINUTE_FORMAT, this.bundle.getString(EVERY), this.bundle.getString("hour"));
                }
                String result = String.format("%s %s %s %s %s %s ", this.bundle.getString(EVERY), ((Every)this.hours).getPeriod().getValue(), this.bundle.getString("hours"), this.bundle.getString("at"), this.bundle.getString(MINUTE), ((On)this.minutes).getTime().getValue());
                if (this.isDefault((On)((TimeFields)timeFields).seconds)) {
                    return result;
                }
                return String.format("%s %s %s", this.bundle.getString("and"), this.bundle.getString(SECOND), ((On)this.seconds).getTime().getValue());
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof Always && ((TimeFields)timeFields).seconds instanceof Always && ((TimeFields)timeFields).minutes instanceof On) {
                return String.format("%s %s %s %s %02d %s", this.bundle.getString(EVERY), this.bundle.getString(SECOND), this.bundle.getString("at"), this.bundle.getString(MINUTE), ((On)((TimeFields)timeFields).minutes).getTime().getValue(), this.bundle.getString("of_every_hour"));
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof Always && ((TimeFields)timeFields).seconds instanceof Always && ((TimeFields)timeFields).minutes instanceof And) {
                String minutesDesc = this.addTimeExpressions(this.describe(((TimeFields)timeFields).minutes), this.bundle.getString(MINUTE), this.bundle.getString("minutes"));
                return String.format("%s %s %s", this.bundle.getString(EVERY), this.bundle.getString(SECOND), minutesDesc);
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof And && ((TimeFields)timeFields).minutes instanceof Always && ((TimeFields)timeFields).seconds instanceof Always) {
                String hoursDesc = this.addTimeExpressions(this.describe(((TimeFields)timeFields).hours), this.bundle.getString("hour"), this.bundle.getString("hours"));
                return String.format("%s %s %s", this.bundle.getString(EVERY), this.bundle.getString(SECOND), hoursDesc);
            }
            return "";
        });
    }

    private boolean isDefault(On on) {
        return on.getTime().getValue() == 0;
    }

    class TimeFields {
        private final FieldExpression seconds;
        private final FieldExpression minutes;
        private final FieldExpression hours;

        public TimeFields(FieldExpression hours, FieldExpression minutes, FieldExpression seconds) {
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
        }
    }
}

