/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.descriptor;

import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.Function;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.expression.Always;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.expression.And;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.expression.Between;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.expression.Every;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.expression.FieldExpression;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.expression.On;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.value.FieldValue;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.model.field.value.IntegerFieldValue;
import com.amazon.opendistroforelasticsearch.jobscheduler.repackage.com.cronutils.utils.Preconditions;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

abstract class DescriptionStrategy {
    private static final String EVERY = "every";
    private static final String WHITE_SPACE = " ";
    protected Function<Integer, String> nominalValueFunction;
    protected ResourceBundle bundle;

    public DescriptionStrategy(ResourceBundle bundle) {
        this.bundle = bundle;
        this.nominalValueFunction = integer -> WHITE_SPACE + integer;
    }

    public abstract String describe();

    protected String describe(FieldExpression fieldExpression) {
        return this.describe(fieldExpression, false);
    }

    protected String describe(FieldExpression fieldExpression, boolean and) {
        Preconditions.checkNotNull(fieldExpression, "CronFieldExpression should not be null!");
        if (fieldExpression instanceof Always) {
            return this.describe((Always)fieldExpression, and);
        }
        if (fieldExpression instanceof And) {
            return this.describe((And)fieldExpression);
        }
        if (fieldExpression instanceof Between) {
            return this.describe((Between)fieldExpression, and);
        }
        if (fieldExpression instanceof Every) {
            return this.describe((Every)fieldExpression, and);
        }
        if (fieldExpression instanceof On) {
            return this.describe((On)fieldExpression, and);
        }
        return "";
    }

    protected String describe(Always always, boolean and) {
        return "";
    }

    protected String describe(And and) {
        ArrayList<FieldExpression> expressions = new ArrayList<FieldExpression>();
        ArrayList<FieldExpression> onExpressions = new ArrayList<FieldExpression>();
        for (FieldExpression fieldExpression : and.getExpressions()) {
            if (fieldExpression instanceof On) {
                onExpressions.add(fieldExpression);
                continue;
            }
            expressions.add(fieldExpression);
        }
        StringBuilder builder = new StringBuilder();
        if (!onExpressions.isEmpty()) {
            if (onExpressions.size() == 1) {
                builder.append(this.bundle.getString("at"));
                builder.append(" %s ");
                this.createAndDescription(builder, onExpressions);
            } else {
                builder.append(this.bundle.getString("at"));
                this.createAndDescription(builder, onExpressions).append(" replace_plural ");
            }
        }
        if (!expressions.isEmpty()) {
            if (!onExpressions.isEmpty()) {
                builder.append(String.format(" %s ", this.bundle.getString("and")));
            }
            this.createAndDescription(builder, expressions);
        }
        return builder.toString();
    }

    protected String describe(Between between, boolean and) {
        return this.bundle.getString(EVERY) + " %s " + MessageFormat.format(this.bundle.getString("between_x_and_y"), this.nominalValue(between.getFrom()), this.nominalValue(between.getTo())) + WHITE_SPACE;
    }

    protected String describe(Every every, boolean and) {
        String description = every.getPeriod().getValue() > 1 ? String.format("%s %s ", this.bundle.getString(EVERY), this.nominalValue(every.getPeriod())) + " replace_plural " : this.bundle.getString(EVERY) + " %s ";
        if (every.getExpression() instanceof Between) {
            Between between = (Between)every.getExpression();
            description = description + MessageFormat.format(this.bundle.getString("between_x_and_y"), this.nominalValue(between.getFrom()), this.nominalValue(between.getTo())) + WHITE_SPACE;
        }
        return description;
    }

    protected String describe(On on, boolean and) {
        if (and) {
            return this.nominalValue(on.getTime());
        }
        return String.format("%s %s ", this.bundle.getString("at"), this.nominalValue(on.getTime())) + "%s";
    }

    protected String nominalValue(FieldValue<?> fieldValue) {
        Preconditions.checkNotNull(fieldValue, "FieldValue must not be null");
        if (fieldValue instanceof IntegerFieldValue) {
            return this.nominalValueFunction.apply(((IntegerFieldValue)fieldValue).getValue());
        }
        return fieldValue.toString();
    }

    private StringBuilder createAndDescription(StringBuilder builder, List<FieldExpression> expressions) {
        if (expressions.size() > 1) {
            for (int j = 0; j < expressions.size() - 2; ++j) {
                builder.append(String.format(" %s, ", this.describe(expressions.get(j), true)));
            }
            builder.append(String.format(" %s ", this.describe(expressions.get(expressions.size() - 2), true)));
            builder.append(String.format(" %s ", this.bundle.getString("and")));
        }
        builder.append(String.format(" %s ", this.describe(expressions.get(expressions.size() - 1), true)));
        return builder;
    }
}

