/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.util;

import com.amazon.opendistroforelasticsearch.indexmanagement.IndexManagementIndices;
import com.amazon.opendistroforelasticsearch.indexmanagement.util.OpenForTesting;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/util/IndexUtils;", "", "()V", "Companion", "opendistro-index-management"})
public final class IndexUtils {
    @NotNull
    public static final String _META = "_meta";
    @NotNull
    public static final String PROPERTIES = "properties";
    @NotNull
    public static final String FIELDS = "fields";
    @NotNull
    public static final String SCHEMA_VERSION = "schema_version";
    public static final long DEFAULT_SCHEMA_VERSION = 1L;
    private static final Logger logger;
    private static long indexManagementConfigSchemaVersion;
    private static long indexStateManagementHistorySchemaVersion;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        logger = LogManager.getLogger(IndexUtils.class);
        indexManagementConfigSchemaVersion = Companion.getSchemaVersion(IndexManagementIndices.Companion.getIndexManagementMappings());
        indexStateManagementHistorySchemaVersion = Companion.getSchemaVersion(IndexManagementIndices.Companion.getIndexStateManagementHistoryMappings());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0007J$\u0010%\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#J$\u0010&\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#J>\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0007J(\u0010)\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00062\u000e\u0010,\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030*J\u000e\u0010-\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0006J\u0016\u0010.\u001a\u00020/2\u0006\u0010(\u001a\u0002002\u0006\u00101\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002R$\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0019\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00062"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/util/IndexUtils$Companion;", "", "()V", "DEFAULT_SCHEMA_VERSION", "", "FIELDS", "", "PROPERTIES", "SCHEMA_VERSION", "_META", "_META$annotations", "<set-?>", "indexManagementConfigSchemaVersion", "getIndexManagementConfigSchemaVersion", "()J", "setIndexManagementConfigSchemaVersion", "(J)V", "indexStateManagementHistorySchemaVersion", "getIndexStateManagementHistorySchemaVersion", "setIndexStateManagementHistorySchemaVersion", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "checkAndUpdateAliasMapping", "", "alias", "schemaVersion", "mapping", "clusterState", "Lorg/elasticsearch/cluster/ClusterState;", "client", "Lorg/elasticsearch/client/IndicesAdminClient;", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "Lorg/elasticsearch/action/support/master/AcknowledgedResponse;", "checkAndUpdateConfigIndexMapping", "checkAndUpdateHistoryIndexMapping", "checkAndUpdateIndexMapping", "index", "getFieldFromMappings", "", "fieldName", "mappings", "getSchemaVersion", "shouldUpdateIndex", "", "Lorg/elasticsearch/cluster/metadata/IndexMetadata;", "newVersion", "opendistro-index-management"})
    public static final class Companion {
        public static /* synthetic */ void _META$annotations() {
        }

        public final Logger getLogger() {
            return logger;
        }

        public final long getIndexManagementConfigSchemaVersion() {
            return indexManagementConfigSchemaVersion;
        }

        private final void setIndexManagementConfigSchemaVersion(long l) {
            indexManagementConfigSchemaVersion = l;
        }

        public final long getIndexStateManagementHistorySchemaVersion() {
            return indexStateManagementHistorySchemaVersion;
        }

        private final void setIndexStateManagementHistorySchemaVersion(long l) {
            indexStateManagementHistorySchemaVersion = l;
        }

        public final long getSchemaVersion(@NotNull String mapping) {
            Intrinsics.checkParameterIsNotNull((Object)mapping, (String)"mapping");
            XContentParser xcp = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mapping);
            while (true) {
                XContentParser xContentParser = xcp;
                Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"xcp");
                if (xContentParser.isClosed()) break;
                XContentParser.Token token = xcp.currentToken();
                if (token != null && token != XContentParser.Token.END_OBJECT && token != XContentParser.Token.START_OBJECT) {
                    if (Intrinsics.areEqual((Object)xcp.currentName(), (Object)IndexUtils._META) ^ true) {
                        xcp.nextToken();
                        xcp.skipChildren();
                    } else {
                        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                            if (xcp.currentName() != null) {
                                String string;
                                switch (string.hashCode()) {
                                    case 1684719674: {
                                        if (!string.equals(IndexUtils.SCHEMA_VERSION)) break;
                                        long version = xcp.longValue();
                                        boolean bl = version > (long)-1;
                                        boolean bl2 = false;
                                        boolean bl3 = false;
                                        bl3 = false;
                                        boolean bl4 = false;
                                        if (!bl) {
                                            boolean bl5 = false;
                                            String string2 = "Failed requirement.";
                                            throw (Throwable)new IllegalArgumentException(string2.toString());
                                        }
                                        return version;
                                    }
                                }
                            }
                            xcp.nextToken();
                        }
                    }
                }
                xcp.nextToken();
            }
            return 1L;
        }

        public final boolean shouldUpdateIndex(@NotNull IndexMetadata index, long newVersion) {
            Map indexMapping;
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            long oldVersion = 1L;
            MappingMetadata mappingMetadata = index.mapping();
            Map map = indexMapping = mappingMetadata != null ? mappingMetadata.sourceAsMap() : null;
            if (indexMapping != null && indexMapping.containsKey(IndexUtils._META) && indexMapping.get(IndexUtils._META) instanceof HashMap) {
                Object v = indexMapping.get(IndexUtils._META);
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.HashMap<*, *> /* = java.util.HashMap<*, *> */");
                }
                HashMap metaData = (HashMap)v;
                Map map2 = metaData;
                String string = IndexUtils.SCHEMA_VERSION;
                boolean bl = false;
                Map map3 = map2;
                if (map3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (map3.containsKey(string)) {
                    map2 = metaData;
                    string = IndexUtils.SCHEMA_VERSION;
                    bl = false;
                    Object v2 = map2.get(string);
                    if (v2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    oldVersion = ((Integer)v2).intValue();
                }
            }
            return newVersion > oldVersion;
        }

        public final void checkAndUpdateConfigIndexMapping(@NotNull ClusterState clusterState, @NotNull IndicesAdminClient client, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
            Intrinsics.checkParameterIsNotNull((Object)clusterState, (String)"clusterState");
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
            this.checkAndUpdateIndexMapping(".opendistro-ism-config", this.getIndexManagementConfigSchemaVersion(), IndexManagementIndices.Companion.getIndexManagementMappings(), clusterState, client, actionListener);
        }

        public final void checkAndUpdateHistoryIndexMapping(@NotNull ClusterState clusterState, @NotNull IndicesAdminClient client, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
            Intrinsics.checkParameterIsNotNull((Object)clusterState, (String)"clusterState");
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
            this.checkAndUpdateAliasMapping(".opendistro-ism-managed-index-history-write", this.getIndexStateManagementHistorySchemaVersion(), IndexManagementIndices.Companion.getIndexStateManagementHistoryMappings(), clusterState, client, actionListener);
        }

        @OpenForTesting
        public final void checkAndUpdateIndexMapping(@NotNull String index, long schemaVersion, @NotNull String mapping, @NotNull ClusterState clusterState, @NotNull IndicesAdminClient client, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            Intrinsics.checkParameterIsNotNull((Object)mapping, (String)"mapping");
            Intrinsics.checkParameterIsNotNull((Object)clusterState, (String)"clusterState");
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
            org.elasticsearch.cluster.metadata.Metadata metadata2 = clusterState.getMetadata();
            Intrinsics.checkExpressionValueIsNotNull((Object)metadata2, (String)"clusterState.metadata");
            if (metadata2.getIndices().containsKey((Object)index)) {
                org.elasticsearch.cluster.metadata.Metadata metadata3 = clusterState.getMetadata();
                Intrinsics.checkExpressionValueIsNotNull((Object)metadata3, (String)"clusterState.metadata");
                Object object = metadata3.getIndices().get((Object)index);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"clusterState.metadata.indices[index]");
                if (this.shouldUpdateIndex((IndexMetadata)object, schemaVersion)) {
                    PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{index}).type("_doc").source(mapping, XContentType.JSON);
                    Intrinsics.checkExpressionValueIsNotNull((Object)putMappingRequest, (String)"PutMappingRequest(index)\u2026pping, XContentType.JSON)");
                    PutMappingRequest putMappingRequest2 = putMappingRequest;
                    client.putMapping(putMappingRequest2, actionListener);
                } else {
                    actionListener.onResponse((Object)new AcknowledgedResponse(true));
                }
            } else {
                this.getLogger().error("IndexMetaData does not exist for " + index);
                actionListener.onResponse((Object)new AcknowledgedResponse(false));
            }
        }

        @OpenForTesting
        public final void checkAndUpdateAliasMapping(@NotNull String alias, long schemaVersion, @NotNull String mapping, @NotNull ClusterState clusterState, @NotNull IndicesAdminClient client, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
            Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
            Intrinsics.checkParameterIsNotNull((Object)mapping, (String)"mapping");
            Intrinsics.checkParameterIsNotNull((Object)clusterState, (String)"clusterState");
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
            org.elasticsearch.cluster.metadata.Metadata metadata2 = clusterState.getMetadata();
            Intrinsics.checkExpressionValueIsNotNull((Object)metadata2, (String)"clusterState.metadata");
            IndexAbstraction result = (IndexAbstraction)metadata2.getIndicesLookup().get(alias);
            if (result == null || result.getType() != IndexAbstraction.Type.ALIAS) {
                this.getLogger().error("There are no indices for alias " + alias);
                actionListener.onResponse((Object)new AcknowledgedResponse(false));
            } else {
                IndexMetadata writeIndex = result.getWriteIndex();
                if (writeIndex == null) {
                    this.getLogger().error("Concrete write index does not exist for alias " + alias);
                    actionListener.onResponse((Object)new AcknowledgedResponse(false));
                } else if (this.shouldUpdateIndex(writeIndex, schemaVersion)) {
                    String[] stringArray = new String[1];
                    Index index = writeIndex.getIndex();
                    Intrinsics.checkExpressionValueIsNotNull((Object)index, (String)"writeIndex.index");
                    stringArray[0] = index.getName();
                    PutMappingRequest putMappingRequest = new PutMappingRequest(stringArray).type("_doc").source(mapping, XContentType.JSON);
                    Intrinsics.checkExpressionValueIsNotNull((Object)putMappingRequest, (String)"PutMappingRequest(writeI\u2026pping, XContentType.JSON)");
                    PutMappingRequest putMappingRequest2 = putMappingRequest;
                    client.putMapping(putMappingRequest2, actionListener);
                } else {
                    actionListener.onResponse((Object)new AcknowledgedResponse(true));
                }
            }
        }

        @Nullable
        public final Map<?, ?> getFieldFromMappings(@NotNull String fieldName, @NotNull Map<?, ?> mappings) {
            Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
            Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
            Map currMap = mappings;
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)fieldName, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map map;
                block6: {
                    block5: {
                        String field = (String)element$iv;
                        boolean bl = false;
                        Map map2 = currMap;
                        String string = IndexUtils.PROPERTIES;
                        boolean bl2 = false;
                        Map map3 = (Map)map2.get(string);
                        if (map3 == null) {
                            map2 = currMap;
                            string = IndexUtils.FIELDS;
                            bl2 = false;
                            map3 = map = (Map)map2.get(string);
                        }
                        if (map3 == null) break block5;
                        map2 = map;
                        boolean bl3 = false;
                        map = map2.get(field);
                        if (map != null) break block6;
                    }
                    return null;
                }
                Map nextMap = map;
                if (nextMap != null) continue;
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            }
            return currMap;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

