/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.util;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.rest.RestStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/util/IndexManagementException;", "Lorg/elasticsearch/ElasticsearchException;", "message", "", "status", "Lorg/elasticsearch/rest/RestStatus;", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Lorg/elasticsearch/rest/RestStatus;Ljava/lang/Exception;)V", "getStatus", "()Lorg/elasticsearch/rest/RestStatus;", "Companion", "opendistro-index-management"})
public final class IndexManagementException
extends ElasticsearchException {
    @NotNull
    private final RestStatus status;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public RestStatus status() {
        return this.status;
    }

    @NotNull
    public final RestStatus getStatus() {
        return this.status;
    }

    public IndexManagementException(@NotNull String message, @NotNull RestStatus status, @NotNull Exception ex) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        super(message, (Throwable)ex, new Object[0]);
        this.status = status;
    }

    @JvmStatic
    @NotNull
    public static final ElasticsearchException wrap(@NotNull Exception ex) {
        return Companion.wrap(ex);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/util/IndexManagementException$Companion;", "", "()V", "wrap", "Lorg/elasticsearch/ElasticsearchException;", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "opendistro-index-management"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ElasticsearchException wrap(@NotNull Exception ex) {
            Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
            String string = ex.getMessage();
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String friendlyMsg = string;
            RestStatus status = RestStatus.INTERNAL_SERVER_ERROR;
            Exception exception = ex;
            if (exception instanceof IndexNotFoundException) {
                RestStatus restStatus = ((IndexNotFoundException)ex).status();
                Intrinsics.checkExpressionValueIsNotNull((Object)restStatus, (String)"ex.status()");
                status = restStatus;
                friendlyMsg = "Configuration index not found";
            } else if (exception instanceof IllegalArgumentException) {
                status = RestStatus.BAD_REQUEST;
                String string2 = ex.getMessage();
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                friendlyMsg = string2;
            } else if (exception instanceof ValidationException) {
                status = RestStatus.BAD_REQUEST;
                String string3 = ex.getMessage();
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                friendlyMsg = string3;
            } else if (!Strings.isNullOrEmpty((String)ex.getMessage())) {
                String string4 = ex.getMessage();
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                friendlyMsg = string4;
            }
            return new IndexManagementException(friendlyMsg, status, new Exception(ex.getClass().getName() + ": " + ex.getMessage()));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

