/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.rollup.resthandler;

import com.amazon.opendistroforelasticsearch.indexmanagement.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.index.IndexRollupAction;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.index.IndexRollupRequest;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.index.IndexRollupResponse;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestResponseListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/resthandler/RestIndexRollupAction;", "Lorg/elasticsearch/rest/BaseRestHandler;", "()V", "getName", "", "indexRollupResponse", "Lorg/elasticsearch/rest/action/RestResponseListener;", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/action/index/IndexRollupResponse;", "channel", "Lorg/elasticsearch/rest/RestChannel;", "prepareRequest", "Lorg/elasticsearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/elasticsearch/rest/RestRequest;", "client", "Lorg/elasticsearch/client/node/NodeClient;", "routes", "", "Lorg/elasticsearch/rest/RestHandler$Route;", "opendistro-index-management"})
public final class RestIndexRollupAction
extends BaseRestHandler {
    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object[])new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.PUT, "/_opendistro/_rollup/jobs"), new RestHandler.Route(RestRequest.Method.PUT, "/_opendistro/_rollup/jobs/{rollupID}")});
    }

    @NotNull
    public String getName() {
        return "opendistro_index_rollup_action";
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        WriteRequest.RefreshPolicy refreshPolicy;
        XContentParser xcp;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        String id = request.param("rollupID", "");
        if (Intrinsics.areEqual((Object)"", (Object)id)) {
            throw (Throwable)new IllegalArgumentException("Missing rollup ID");
        }
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        XContentParser xContentParser = xcp = request.contentParser();
        Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"xcp");
        String string = id;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
        Rollup rollup2 = (Rollup)ElasticExtensionsKt.parseWithType(xContentParser, string, seqNo, primaryTerm, (Function4)new Function4<XContentParser, String, Long, Long, Rollup>(Rollup.Companion){

            @NotNull
            public final Rollup invoke(@NotNull XContentParser p1, @NotNull String p2, long p3, long p4) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return ((Rollup.Companion)this.receiver).parse(p1, p2, p3, p4);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Rollup.Companion.class);
            }

            public final String getName() {
                return "parse";
            }

            public final String getSignature() {
                return "parse(Lorg/elasticsearch/common/xcontent/XContentParser;Ljava/lang/String;JJ)Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;";
            }
        });
        Instant instant = Instant.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
        Rollup rollup3 = Rollup.copy$default(rollup2, null, 0L, 0L, false, 0L, null, instant, null, null, null, null, null, null, 0, null, false, null, null, 262079, null);
        WriteRequest.RefreshPolicy refreshPolicy2 = refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        Intrinsics.checkExpressionValueIsNotNull((Object)refreshPolicy2, (String)"refreshPolicy");
        IndexRollupRequest indexRollupRequest = new IndexRollupRequest(rollup3, refreshPolicy2);
        return new BaseRestHandler.RestChannelConsumer(this, client, indexRollupRequest){
            final /* synthetic */ RestIndexRollupAction this$0;
            final /* synthetic */ NodeClient $client;
            final /* synthetic */ IndexRollupRequest $indexRollupRequest;

            public final void accept(RestChannel channel) {
                ActionType actionType = IndexRollupAction.Companion.getINSTANCE();
                ActionRequest actionRequest = (ActionRequest)this.$indexRollupRequest;
                RestChannel restChannel = channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)restChannel, (String)"channel");
                this.$client.execute(actionType, actionRequest, (ActionListener)RestIndexRollupAction.access$indexRollupResponse(this.this$0, restChannel));
            }
            {
                this.this$0 = restIndexRollupAction;
                this.$client = nodeClient;
                this.$indexRollupRequest = indexRollupRequest;
            }
        };
    }

    private final RestResponseListener<IndexRollupResponse> indexRollupResponse(RestChannel channel) {
        return (RestResponseListener)new RestResponseListener<IndexRollupResponse>(channel, channel){
            final /* synthetic */ RestChannel $channel;

            @NotNull
            public RestResponse buildResponse(@NotNull IndexRollupResponse response2) throws Exception {
                Intrinsics.checkParameterIsNotNull((Object)((Object)response2), (String)"response");
                RestStatus restStatus = response2.getStatus();
                XContentBuilder xContentBuilder = this.$channel.newBuilder();
                Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"channel.newBuilder()");
                ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkExpressionValueIsNotNull((Object)params, (String)"ToXContent.EMPTY_PARAMS");
                BytesRestResponse restResponse = new BytesRestResponse(restStatus, response2.toXContent(xContentBuilder, params));
                if (response2.getStatus() == RestStatus.CREATED) {
                    String location = "/_opendistro/_rollup/jobs/" + response2.getId();
                    restResponse.addHeader("Location", location);
                }
                return (RestResponse)restResponse;
            }
            {
                this.$channel = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }

    public static final /* synthetic */ RestResponseListener access$indexRollupResponse(RestIndexRollupAction $this, RestChannel channel) {
        return $this.indexRollupResponse(channel);
    }
}

