/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model;

import com.amazon.opendistroforelasticsearch.indexmanagement.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup$WhenMappings;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.RollupMetrics;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.dimension.DateHistogram;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.dimension.Dimension;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.dimension.Histogram;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.dimension.Terms;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.ScheduledJobParameter;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule.CronSchedule;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule.IntervalSchedule;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule.Schedule;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule.ScheduleParser;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b2\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 e2\u00020\u00012\u00020\u0002:\u0001eB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u00b3\u0001\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0007\u0012\u0006\u0010\u0014\u001a\u00020\u0007\u0012\u0006\u0010\u0015\u001a\u00020\u0007\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u001c\u001a\u00020\f\u0012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018\u0012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0018\u00a2\u0006\u0002\u0010!J\t\u0010=\u001a\u00020\u0007H\u00c6\u0003J\t\u0010>\u001a\u00020\u0007H\u00c6\u0003J\t\u0010?\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010@\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u00c6\u0003J\t\u0010B\u001a\u00020\u001aH\u00c6\u0003J\u0010\u0010C\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010%J\t\u0010D\u001a\u00020\fH\u00c6\u0003J\u000f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018H\u00c6\u0003J\u000f\u0010F\u001a\b\u0012\u0004\u0012\u00020 0\u0018H\u00c6\u0003J\t\u0010G\u001a\u00020\tH\u00c6\u0003J\t\u0010H\u001a\u00020\tH\u00c6\u0003J\t\u0010I\u001a\u00020\fH\u00c6\u0003J\t\u0010J\u001a\u00020\tH\u00c6\u0003J\t\u0010K\u001a\u00020\u000fH\u00c6\u0003J\t\u0010L\u001a\u00020\u0011H\u00c6\u0003J\u000b\u0010M\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\t\u0010N\u001a\u00020\u0007H\u00c6\u0003J\u00da\u0001\u0010O\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u00072\b\b\u0002\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u001c\u001a\u00020\f2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00182\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0018H\u00c6\u0001\u00a2\u0006\u0002\u0010PJ\u0013\u0010Q\u001a\u00020\f2\b\u0010R\u001a\u0004\u0018\u00010SH\u00d6\u0003J\n\u0010T\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010U\u001a\u00020\u0011H\u0016J\b\u0010V\u001a\u00020\tH\u0016J\b\u0010W\u001a\u00020\u0007H\u0016J\b\u0010X\u001a\u00020\u000fH\u0016J\t\u0010Y\u001a\u00020\u001aH\u00d6\u0001J\b\u0010Z\u001a\u00020\fH\u0016J\t\u0010[\u001a\u00020\u0007H\u00d6\u0001J\u0018\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020]2\u0006\u0010_\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020dH\u0016R\u0011\u0010\u001c\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0015\u0010\u001b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b$\u0010%R\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010#R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010(R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010.R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010(R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010*R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010*R\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00107R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00107R\u0011\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010(R\u0011\u0010\u0015\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010(\u00a8\u0006f"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;", "Lcom/amazon/opendistroforelasticsearch/jobscheduler/spi/ScheduledJobParameter;", "Lorg/elasticsearch/common/io/stream/Writeable;", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "(Lorg/elasticsearch/common/io/stream/StreamInput;)V", "id", "", "seqNo", "", "primaryTerm", "enabled", "", "schemaVersion", "jobSchedule", "Lcom/amazon/opendistroforelasticsearch/jobscheduler/spi/schedule/Schedule;", "jobLastUpdatedTime", "Ljava/time/Instant;", "jobEnabledTime", "description", "sourceIndex", "targetIndex", "metadataID", "roles", "", "pageSize", "", "delay", "continuous", "dimensions", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/dimension/Dimension;", "metrics", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/RollupMetrics;", "(Ljava/lang/String;JJZJLcom/amazon/opendistroforelasticsearch/jobscheduler/spi/schedule/Schedule;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;ILjava/lang/Long;ZLjava/util/List;Ljava/util/List;)V", "getContinuous", "()Z", "getDelay", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getDescription", "()Ljava/lang/String;", "getDimensions", "()Ljava/util/List;", "getEnabled", "getId", "getJobEnabledTime", "()Ljava/time/Instant;", "getJobLastUpdatedTime", "getJobSchedule", "()Lcom/amazon/opendistroforelasticsearch/jobscheduler/spi/schedule/Schedule;", "getMetadataID", "getMetrics", "getPageSize", "()I", "getPrimaryTerm", "()J", "getRoles", "getSchemaVersion", "getSeqNo", "getSourceIndex", "getTargetIndex", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;JJZJLcom/amazon/opendistroforelasticsearch/jobscheduler/spi/schedule/Schedule;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;ILjava/lang/Long;ZLjava/util/List;Ljava/util/List;)Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;", "equals", "other", "", "getEnabledTime", "getLastUpdateTime", "getLockDurationSeconds", "getName", "getSchedule", "hashCode", "isEnabled", "toString", "toXContent", "Lorg/elasticsearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/elasticsearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/elasticsearch/common/io/stream/StreamOutput;", "Companion", "opendistro-index-management"})
public final class Rollup
implements ScheduledJobParameter,
Writeable {
    @NotNull
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    private final boolean enabled;
    private final long schemaVersion;
    @NotNull
    private final Schedule jobSchedule;
    @NotNull
    private final Instant jobLastUpdatedTime;
    @Nullable
    private final Instant jobEnabledTime;
    @NotNull
    private final String description;
    @NotNull
    private final String sourceIndex;
    @NotNull
    private final String targetIndex;
    @Nullable
    private final String metadataID;
    @NotNull
    private final List<String> roles;
    private final int pageSize;
    @Nullable
    private final Long delay;
    private final boolean continuous;
    @NotNull
    private final List<Dimension> dimensions;
    @NotNull
    private final List<RollupMetrics> metrics;
    public static final long ROLLUP_LOCK_DURATION_SECONDS = 1800L;
    @NotNull
    public static final String ROLLUP_TYPE = "rollup";
    @NotNull
    public static final String ROLLUP_ID_FIELD = "rollup_id";
    @NotNull
    public static final String NO_ID = "";
    @NotNull
    public static final String ENABLED_FIELD = "enabled";
    @NotNull
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    @NotNull
    public static final String SCHEDULE_FIELD = "schedule";
    @NotNull
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    @NotNull
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    @NotNull
    public static final String DESCRIPTION_FIELD = "description";
    @NotNull
    public static final String SOURCE_INDEX_FIELD = "source_index";
    @NotNull
    public static final String TARGET_INDEX_FIELD = "target_index";
    @NotNull
    public static final String METADATA_ID_FIELD = "metadata_id";
    @NotNull
    public static final String ROLES_FIELD = "roles";
    @NotNull
    public static final String PAGE_SIZE_FIELD = "page_size";
    @NotNull
    public static final String DELAY_FIELD = "delay";
    @NotNull
    public static final String CONTINUOUS_FIELD = "continuous";
    @NotNull
    public static final String DIMENSIONS_FIELD = "dimensions";
    @NotNull
    public static final String METRICS_FIELD = "metrics";
    public static final int MINIMUM_JOB_INTERVAL = 1;
    public static final int MINIMUM_DELAY = 0;
    public static final int MINIMUM_PAGE_SIZE = 1;
    public static final int MAXIMUM_PAGE_SIZE = 10000;
    @NotNull
    public static final String ROLLUP_DOC_ID_FIELD = "rollup._id";
    @NotNull
    public static final String ROLLUP_DOC_COUNT_FIELD = "rollup._doc_count";
    @NotNull
    public static final String ROLLUP_DOC_SCHEMA_VERSION_FIELD = "rollup._schema_version";
    public static final Companion Companion = new Companion(null);

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotNull
    public String getName() {
        return this.id;
    }

    @Nullable
    public Instant getEnabledTime() {
        return this.jobEnabledTime;
    }

    @NotNull
    public Schedule getSchedule() {
        return this.jobSchedule;
    }

    @NotNull
    public Instant getLastUpdateTime() {
        return this.jobLastUpdatedTime;
    }

    public long getLockDurationSeconds() {
        return 1800L;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Collection $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(ROLLUP_TYPE);
        }
        XContentBuilder xContentBuilder = builder.field(ROLLUP_ID_FIELD, this.id).field(ENABLED_FIELD, this.enabled).field(SCHEDULE_FIELD, (ToXContent)this.jobSchedule);
        Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"builder.field(ROLLUP_ID_\u2026EDULE_FIELD, jobSchedule)");
        Collection collection = this.roles;
        String string = ROLES_FIELD;
        XContentBuilder xContentBuilder2 = ElasticExtensionsKt.optionalTimeField(ElasticExtensionsKt.optionalTimeField(xContentBuilder, LAST_UPDATED_TIME_FIELD, this.jobLastUpdatedTime), ENABLED_TIME_FIELD, this.jobEnabledTime).field(DESCRIPTION_FIELD, this.description).field(SCHEMA_VERSION_FIELD, this.schemaVersion).field(SOURCE_INDEX_FIELD, this.sourceIndex).field(TARGET_INDEX_FIELD, this.targetIndex).field(METADATA_ID_FIELD, this.metadataID);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = stringArray;
        XContentBuilder xContentBuilder3 = xContentBuilder2.field(string, (Object)objectArray).field(PAGE_SIZE_FIELD, this.pageSize).field(DELAY_FIELD, this.delay).field(CONTINUOUS_FIELD, this.continuous);
        $this$toTypedArray$iv = this.dimensions;
        string = DIMENSIONS_FIELD;
        xContentBuilder2 = xContentBuilder3;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        Dimension[] dimensionArray = thisCollection$iv.toArray(new Dimension[0]);
        if (dimensionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray = dimensionArray;
        XContentBuilder xContentBuilder4 = xContentBuilder2.field(string, (Object)objectArray);
        $this$toTypedArray$iv = this.metrics;
        string = METRICS_FIELD;
        xContentBuilder2 = xContentBuilder4;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        RollupMetrics[] rollupMetricsArray = thisCollection$iv.toArray(new RollupMetrics[0]);
        if (rollupMetricsArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray = rollupMetricsArray;
        xContentBuilder2.field(string, (Object)objectArray);
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    public void writeTo(@NotNull StreamOutput out) {
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        out.writeString(this.id);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeBoolean(this.enabled);
        out.writeLong(this.schemaVersion);
        if (this.getSchedule() instanceof CronSchedule) {
            out.writeEnum((Enum)Companion.ScheduleType.CRON);
        } else {
            out.writeEnum((Enum)Companion.ScheduleType.INTERVAL);
        }
        this.getSchedule().writeTo(out);
        out.writeInstant(this.jobLastUpdatedTime);
        out.writeOptionalInstant(this.jobEnabledTime);
        out.writeString(this.description);
        out.writeString(this.sourceIndex);
        out.writeString(this.targetIndex);
        out.writeOptionalString(this.metadataID);
        Collection collection = this.roles;
        StreamOutput streamOutput = out;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        streamOutput.writeStringArray(stringArray2);
        out.writeInt(this.pageSize);
        out.writeOptionalLong(this.delay);
        out.writeBoolean(this.continuous);
        out.writeVInt(this.dimensions.size());
        for (Dimension dimension : this.dimensions) {
            out.writeEnum((Enum)dimension.getType());
            Dimension dimension2 = dimension;
            if (dimension2 instanceof DateHistogram) {
                dimension.writeTo(out);
                continue;
            }
            if (dimension2 instanceof Terms) {
                dimension.writeTo(out);
                continue;
            }
            if (!(dimension2 instanceof Histogram)) continue;
            dimension.writeTo(out);
        }
        out.writeCollection((Collection)this.metrics);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final long getSchemaVersion() {
        return this.schemaVersion;
    }

    @NotNull
    public final Schedule getJobSchedule() {
        return this.jobSchedule;
    }

    @NotNull
    public final Instant getJobLastUpdatedTime() {
        return this.jobLastUpdatedTime;
    }

    @Nullable
    public final Instant getJobEnabledTime() {
        return this.jobEnabledTime;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getSourceIndex() {
        return this.sourceIndex;
    }

    @NotNull
    public final String getTargetIndex() {
        return this.targetIndex;
    }

    @Nullable
    public final String getMetadataID() {
        return this.metadataID;
    }

    @NotNull
    public final List<String> getRoles() {
        return this.roles;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    @Nullable
    public final Long getDelay() {
        return this.delay;
    }

    public final boolean getContinuous() {
        return this.continuous;
    }

    @NotNull
    public final List<Dimension> getDimensions() {
        return this.dimensions;
    }

    @NotNull
    public final List<RollupMetrics> getMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - void declaration
     */
    public Rollup(@NotNull String id, long seqNo, long primaryTerm, boolean enabled, long schemaVersion, @NotNull Schedule jobSchedule, @NotNull Instant jobLastUpdatedTime, @Nullable Instant jobEnabledTime, @NotNull String description, @NotNull String sourceIndex, @NotNull String targetIndex, @Nullable String metadataID, @NotNull List<String> roles, int pageSize, @Nullable Long delay, boolean continuous, @NotNull List<? extends Dimension> dimensions, @NotNull List<RollupMetrics> metrics) {
        void $this$filterTo$iv$iv;
        boolean bl;
        boolean bl2;
        Instant instant;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)jobSchedule, (String)"jobSchedule");
        Intrinsics.checkParameterIsNotNull((Object)jobLastUpdatedTime, (String)"jobLastUpdatedTime");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)DESCRIPTION_FIELD);
        Intrinsics.checkParameterIsNotNull((Object)sourceIndex, (String)"sourceIndex");
        Intrinsics.checkParameterIsNotNull((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkParameterIsNotNull(roles, (String)ROLES_FIELD);
        Intrinsics.checkParameterIsNotNull(dimensions, (String)DIMENSIONS_FIELD);
        Intrinsics.checkParameterIsNotNull(metrics, (String)METRICS_FIELD);
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.enabled = enabled;
        this.schemaVersion = schemaVersion;
        this.jobSchedule = jobSchedule;
        this.jobLastUpdatedTime = jobLastUpdatedTime;
        this.jobEnabledTime = jobEnabledTime;
        this.description = description;
        this.sourceIndex = sourceIndex;
        this.targetIndex = targetIndex;
        this.metadataID = metadataID;
        this.roles = roles;
        this.pageSize = pageSize;
        this.delay = delay;
        this.continuous = continuous;
        this.dimensions = dimensions;
        this.metrics = metrics;
        if (this.enabled) {
            instant = this.jobEnabledTime;
            bl2 = false;
            bl = false;
            if (instant == null) {
                boolean bl3 = false;
                String string = "Job enabled time must be present if the job is enabled";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        } else {
            boolean bl4 = this.jobEnabledTime == null;
            bl2 = false;
            bl = false;
            if (!bl4) {
                boolean bl52 = false;
                String string = "Job enabled time must not be present if the job is disabled";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        if (!((instant = this.jobSchedule) instanceof CronSchedule) && instant instanceof IntervalSchedule) {
            bl2 = ((IntervalSchedule)this.jobSchedule).getInterval() >= 1;
            bl = false;
            boolean bl52 = false;
            if (!bl2) {
                boolean bl6 = false;
                String bl52 = "Rollup job schedule interval must be greater than 0";
                throw (Throwable)new IllegalArgumentException(bl52.toString());
            }
        }
        boolean bl7 = Intrinsics.areEqual((Object)this.sourceIndex, (Object)this.targetIndex) ^ true;
        bl2 = false;
        bl = false;
        if (!bl7) {
            boolean bl8 = false;
            String string = "Your source and target index cannot be the same";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Iterable $this$filter$iv = this.dimensions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Dimension it = (Dimension)element$iv$iv;
            boolean bl9 = false;
            if (!(it.getType() == Dimension.Type.DATE_HISTOGRAM)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int n = ((List)destination$iv$iv).size() == 1 ? 1 : 0;
        bl2 = false;
        boolean bl10 = false;
        if (n == 0) {
            boolean bl11 = false;
            String string = "Must specify precisely one date histogram dimension";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = ((Dimension)CollectionsKt.first(this.dimensions)).getType() == Dimension.Type.DATE_HISTOGRAM ? 1 : 0;
        bl2 = false;
        bl10 = false;
        if (n == 0) {
            boolean bl12 = false;
            String string = "The first dimension must be a date histogram";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.pageSize;
        n = 1 <= n && 10000 >= n ? 1 : 0;
        bl2 = false;
        bl10 = false;
        if (n == 0) {
            boolean bl13 = false;
            String string = "Page size must be between 1 and 10,000";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.delay != null) {
            n = this.delay >= 0L ? 1 : 0;
            bl2 = false;
            bl10 = false;
            if (n == 0) {
                boolean bl14 = false;
                String string = "Delay must be non-negative if set";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ Rollup(String string, long l, long l2, boolean bl, long l3, Schedule schedule, Instant instant, Instant instant2, String string2, String string3, String string4, String string5, List list, int n, Long l4, boolean bl2, List list2, List list3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = NO_ID;
        }
        if ((n2 & 2) != 0) {
            l = -2L;
        }
        if ((n2 & 4) != 0) {
            l2 = 0L;
        }
        this(string, l, l2, bl, l3, schedule, instant, instant2, string2, string3, string4, string5, list, n, l4, bl2, list2, list3);
    }

    /*
     * WARNING - void declaration
     */
    public Rollup(@NotNull StreamInput sin) throws IOException {
        Schedule schedule;
        Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sin.readString()");
        StreamInput streamInput = sin;
        long l = sin.readLong();
        boolean bl = sin.readBoolean();
        long l2 = sin.readLong();
        long l3 = sin.readLong();
        String string2 = string;
        Rollup rollup2 = this;
        boolean bl2 = false;
        boolean bl3 = false;
        StreamInput it = streamInput;
        boolean bl4 = false;
        Enum enum_ = sin.readEnum(Companion.ScheduleType.class);
        boolean bl5 = false;
        int n = 0;
        if (enum_ == null) {
            boolean bl6 = false;
            String string3 = "ScheduleType cannot be null";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        switch (Rollup$WhenMappings.$EnumSwitchMapping$0[((Companion.ScheduleType)enum_).ordinal()]) {
            case 1: {
                schedule = (Schedule)new CronSchedule(sin);
                break;
            }
            case 2: {
                schedule = (Schedule)new IntervalSchedule(sin);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Schedule schedule2 = schedule;
        Instant instant = sin.readInstant();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"sin.readInstant()");
        Instant instant2 = sin.readOptionalInstant();
        String string4 = sin.readString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sin.readString()");
        String string5 = sin.readString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sin.readString()");
        String string6 = sin.readString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"sin.readString()");
        String string7 = sin.readOptionalString();
        Object[] objectArray = sin.readStringArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"sin.readStringArray()");
        streamInput = sin;
        boolean bl7 = sin.readBoolean();
        Long l4 = sin.readOptionalLong();
        int n2 = sin.readInt();
        List list = ArraysKt.toList((Object[])objectArray);
        String string8 = string7;
        String string9 = string6;
        String string10 = string5;
        String string11 = string4;
        Instant instant3 = instant2;
        Instant instant4 = instant;
        bl2 = false;
        bl3 = false;
        it = streamInput;
        boolean bl8 = false;
        boolean bl9 = false;
        List dimensionsList = new ArrayList();
        int size = it.readVInt();
        n = 0;
        int n3 = size;
        while (n < n3) {
            void i2;
            Dimension dimension;
            Dimension.Type type = (Dimension.Type)it.readEnum(Dimension.Type.class);
            List list2 = dimensionsList;
            boolean bl10 = false;
            boolean bl11 = false;
            if (type == null) {
                boolean bl12 = false;
                String string12 = "Dimension type cannot be null";
                throw (Throwable)new IllegalArgumentException(string12.toString());
            }
            Dimension.Type type2 = type;
            switch (Rollup$WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
                case 1: {
                    dimension = new DateHistogram(sin);
                    break;
                }
                case 2: {
                    dimension = new Terms(sin);
                    break;
                }
                case 3: {
                    dimension = new Histogram(sin);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            list2.add(dimension);
            ++i2;
        }
        List list3 = CollectionsKt.toList((Iterable)dimensionsList);
        Object object = 12.INSTANCE;
        if (object != null) {
            streamInput = object;
            object = new Rollup$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0((Function1)streamInput);
        }
        List list4 = sin.readList((Writeable.Reader)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"sin.readList(::RollupMetrics)");
        rollup2(string2, l3, l2, bl, l, schedule2, instant4, instant3, string11, string10, string9, string8, list, n2, l4, bl7, list3, list4);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.seqNo;
    }

    public final long component3() {
        return this.primaryTerm;
    }

    public final boolean component4() {
        return this.enabled;
    }

    public final long component5() {
        return this.schemaVersion;
    }

    @NotNull
    public final Schedule component6() {
        return this.jobSchedule;
    }

    @NotNull
    public final Instant component7() {
        return this.jobLastUpdatedTime;
    }

    @Nullable
    public final Instant component8() {
        return this.jobEnabledTime;
    }

    @NotNull
    public final String component9() {
        return this.description;
    }

    @NotNull
    public final String component10() {
        return this.sourceIndex;
    }

    @NotNull
    public final String component11() {
        return this.targetIndex;
    }

    @Nullable
    public final String component12() {
        return this.metadataID;
    }

    @NotNull
    public final List<String> component13() {
        return this.roles;
    }

    public final int component14() {
        return this.pageSize;
    }

    @Nullable
    public final Long component15() {
        return this.delay;
    }

    public final boolean component16() {
        return this.continuous;
    }

    @NotNull
    public final List<Dimension> component17() {
        return this.dimensions;
    }

    @NotNull
    public final List<RollupMetrics> component18() {
        return this.metrics;
    }

    @NotNull
    public final Rollup copy(@NotNull String id, long seqNo, long primaryTerm, boolean enabled, long schemaVersion, @NotNull Schedule jobSchedule, @NotNull Instant jobLastUpdatedTime, @Nullable Instant jobEnabledTime, @NotNull String description, @NotNull String sourceIndex, @NotNull String targetIndex, @Nullable String metadataID, @NotNull List<String> roles, int pageSize, @Nullable Long delay, boolean continuous, @NotNull List<? extends Dimension> dimensions, @NotNull List<RollupMetrics> metrics) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)jobSchedule, (String)"jobSchedule");
        Intrinsics.checkParameterIsNotNull((Object)jobLastUpdatedTime, (String)"jobLastUpdatedTime");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)DESCRIPTION_FIELD);
        Intrinsics.checkParameterIsNotNull((Object)sourceIndex, (String)"sourceIndex");
        Intrinsics.checkParameterIsNotNull((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkParameterIsNotNull(roles, (String)ROLES_FIELD);
        Intrinsics.checkParameterIsNotNull(dimensions, (String)DIMENSIONS_FIELD);
        Intrinsics.checkParameterIsNotNull(metrics, (String)METRICS_FIELD);
        return new Rollup(id, seqNo, primaryTerm, enabled, schemaVersion, jobSchedule, jobLastUpdatedTime, jobEnabledTime, description, sourceIndex, targetIndex, metadataID, roles, pageSize, delay, continuous, dimensions, metrics);
    }

    public static /* synthetic */ Rollup copy$default(Rollup rollup2, String string, long l, long l2, boolean bl, long l3, Schedule schedule, Instant instant, Instant instant2, String string2, String string3, String string4, String string5, List list, int n, Long l4, boolean bl2, List list2, List list3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = rollup2.id;
        }
        if ((n2 & 2) != 0) {
            l = rollup2.seqNo;
        }
        if ((n2 & 4) != 0) {
            l2 = rollup2.primaryTerm;
        }
        if ((n2 & 8) != 0) {
            bl = rollup2.enabled;
        }
        if ((n2 & 0x10) != 0) {
            l3 = rollup2.schemaVersion;
        }
        if ((n2 & 0x20) != 0) {
            schedule = rollup2.jobSchedule;
        }
        if ((n2 & 0x40) != 0) {
            instant = rollup2.jobLastUpdatedTime;
        }
        if ((n2 & 0x80) != 0) {
            instant2 = rollup2.jobEnabledTime;
        }
        if ((n2 & 0x100) != 0) {
            string2 = rollup2.description;
        }
        if ((n2 & 0x200) != 0) {
            string3 = rollup2.sourceIndex;
        }
        if ((n2 & 0x400) != 0) {
            string4 = rollup2.targetIndex;
        }
        if ((n2 & 0x800) != 0) {
            string5 = rollup2.metadataID;
        }
        if ((n2 & 0x1000) != 0) {
            list = rollup2.roles;
        }
        if ((n2 & 0x2000) != 0) {
            n = rollup2.pageSize;
        }
        if ((n2 & 0x4000) != 0) {
            l4 = rollup2.delay;
        }
        if ((n2 & 0x8000) != 0) {
            bl2 = rollup2.continuous;
        }
        if ((n2 & 0x10000) != 0) {
            list2 = rollup2.dimensions;
        }
        if ((n2 & 0x20000) != 0) {
            list3 = rollup2.metrics;
        }
        return rollup2.copy(string, l, l2, bl, l3, schedule, instant, instant2, string2, string3, string4, string5, list, n, l4, bl2, list2, list3);
    }

    @NotNull
    public String toString() {
        return "Rollup(id=" + this.id + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", enabled=" + this.enabled + ", schemaVersion=" + this.schemaVersion + ", jobSchedule=" + this.jobSchedule + ", jobLastUpdatedTime=" + this.jobLastUpdatedTime + ", jobEnabledTime=" + this.jobEnabledTime + ", description=" + this.description + ", sourceIndex=" + this.sourceIndex + ", targetIndex=" + this.targetIndex + ", metadataID=" + this.metadataID + ", roles=" + this.roles + ", pageSize=" + this.pageSize + ", delay=" + this.delay + ", continuous=" + this.continuous + ", dimensions=" + this.dimensions + ", metrics=" + this.metrics + ")";
    }

    public int hashCode() {
        String string = this.id;
        int n = (((string != null ? string.hashCode() : 0) * 31 + Long.hashCode(this.seqNo)) * 31 + Long.hashCode(this.primaryTerm)) * 31;
        int n2 = this.enabled ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        Schedule schedule = this.jobSchedule;
        Instant instant = this.jobLastUpdatedTime;
        Instant instant2 = this.jobEnabledTime;
        String string2 = this.description;
        String string3 = this.sourceIndex;
        String string4 = this.targetIndex;
        String string5 = this.metadataID;
        List<String> list = this.roles;
        Long l = this.delay;
        int n3 = ((((((((((((n + n2) * 31 + Long.hashCode(this.schemaVersion)) * 31 + (schedule != null ? schedule.hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + (instant2 != null ? ((Object)instant2).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + Integer.hashCode(this.pageSize)) * 31 + (l != null ? ((Object)l).hashCode() : 0)) * 31;
        int n4 = this.continuous ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        List<Dimension> list2 = this.dimensions;
        List<RollupMetrics> list3 = this.metrics;
        return ((n3 + n4) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Rollup)) break block3;
                Rollup rollup2 = (Rollup)object;
                if (!Intrinsics.areEqual((Object)this.id, (Object)rollup2.id) || this.seqNo != rollup2.seqNo || this.primaryTerm != rollup2.primaryTerm || this.enabled != rollup2.enabled || this.schemaVersion != rollup2.schemaVersion || !Intrinsics.areEqual((Object)this.jobSchedule, (Object)rollup2.jobSchedule) || !Intrinsics.areEqual((Object)this.jobLastUpdatedTime, (Object)rollup2.jobLastUpdatedTime) || !Intrinsics.areEqual((Object)this.jobEnabledTime, (Object)rollup2.jobEnabledTime) || !Intrinsics.areEqual((Object)this.description, (Object)rollup2.description) || !Intrinsics.areEqual((Object)this.sourceIndex, (Object)rollup2.sourceIndex) || !Intrinsics.areEqual((Object)this.targetIndex, (Object)rollup2.targetIndex) || !Intrinsics.areEqual((Object)this.metadataID, (Object)rollup2.metadataID) || !Intrinsics.areEqual(this.roles, rollup2.roles) || this.pageSize != rollup2.pageSize || !Intrinsics.areEqual((Object)this.delay, (Object)rollup2.delay) || this.continuous != rollup2.continuous || !Intrinsics.areEqual(this.dimensions, rollup2.dimensions) || !Intrinsics.areEqual(this.metrics, rollup2.metrics)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rollup parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo, long primaryTerm) throws IOException {
        return Companion.parse(xcp, id, seqNo, primaryTerm);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rollup parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo) throws IOException {
        return com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup$Companion.parse$default(Companion, xcp, id, seqNo, 0L, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rollup parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
        return com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup$Companion.parse$default(Companion, xcp, id, 0L, 0L, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rollup parse(@NotNull XContentParser xcp) throws IOException {
        return com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup$Companion.parse$default(Companion, xcp, null, 0L, 0L, 14, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u001a2\b\b\u0002\u0010&\u001a\u00020\u001aH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup$Companion;", "", "()V", "CONTINUOUS_FIELD", "", "DELAY_FIELD", "DESCRIPTION_FIELD", "DIMENSIONS_FIELD", "ENABLED_FIELD", "ENABLED_TIME_FIELD", "LAST_UPDATED_TIME_FIELD", "MAXIMUM_PAGE_SIZE", "", "METADATA_ID_FIELD", "METRICS_FIELD", "MINIMUM_DELAY", "MINIMUM_JOB_INTERVAL", "MINIMUM_PAGE_SIZE", "NO_ID", "PAGE_SIZE_FIELD", "ROLES_FIELD", "ROLLUP_DOC_COUNT_FIELD", "ROLLUP_DOC_ID_FIELD", "ROLLUP_DOC_SCHEMA_VERSION_FIELD", "ROLLUP_ID_FIELD", "ROLLUP_LOCK_DURATION_SECONDS", "", "ROLLUP_TYPE", "SCHEDULE_FIELD", "SCHEMA_VERSION_FIELD", "SOURCE_INDEX_FIELD", "TARGET_INDEX_FIELD", "parse", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;", "xcp", "Lorg/elasticsearch/common/xcontent/XContentParser;", "id", "seqNo", "primaryTerm", "ScheduleType", "opendistro-index-management"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rollup parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo, long primaryTerm) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)xcp, (String)"xcp");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Schedule schedule = null;
            long schemaVersion = 1L;
            Instant lastUpdatedTime = null;
            Instant enabledTime = null;
            boolean enabled = true;
            String description = null;
            String sourceIndex = null;
            String targetIndex = null;
            String metadataID = null;
            boolean bl = false;
            List roles = new ArrayList();
            Integer pageSize = null;
            Long delay = null;
            boolean continuous = false;
            boolean bl2 = false;
            List dimensions = new ArrayList();
            boolean bl3 = false;
            List metrics = new ArrayList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block36: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                if (fieldName != null) {
                    String string;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1219796725: {
                            if (!string.equals(Rollup.ENABLED_TIME_FIELD)) break;
                            n = 1;
                            break;
                        }
                        case -207303516: {
                            if (!string.equals(Rollup.TARGET_INDEX_FIELD)) break;
                            n = 2;
                            break;
                        }
                        case 108695229: {
                            if (!string.equals(Rollup.ROLES_FIELD)) break;
                            n = 3;
                            break;
                        }
                        case -1724546052: {
                            if (!string.equals(Rollup.DESCRIPTION_FIELD)) break;
                            n = 4;
                            break;
                        }
                        case 1661088686: {
                            if (!string.equals(Rollup.SOURCE_INDEX_FIELD)) break;
                            n = 5;
                            break;
                        }
                        case -1609594047: {
                            if (!string.equals(Rollup.ENABLED_FIELD)) break;
                            n = 6;
                            break;
                        }
                        case 556621538: {
                            if (!string.equals(Rollup.ROLLUP_ID_FIELD)) break;
                            n = 7;
                            break;
                        }
                        case 1684719674: {
                            if (!string.equals(Rollup.SCHEMA_VERSION_FIELD)) break;
                            n = 8;
                            break;
                        }
                        case -697920873: {
                            if (!string.equals(Rollup.SCHEDULE_FIELD)) break;
                            n = 9;
                            break;
                        }
                        case 95467907: {
                            if (!string.equals(Rollup.DELAY_FIELD)) break;
                            n = 10;
                            break;
                        }
                        case -1670470950: {
                            if (!string.equals(Rollup.LAST_UPDATED_TIME_FIELD)) break;
                            n = 11;
                            break;
                        }
                        case 379114255: {
                            if (!string.equals(Rollup.CONTINUOUS_FIELD)) break;
                            n = 12;
                            break;
                        }
                        case -1481411541: {
                            if (!string.equals(Rollup.METADATA_ID_FIELD)) break;
                            n = 13;
                            break;
                        }
                        case 955826371: {
                            if (!string.equals(Rollup.METRICS_FIELD)) break;
                            n = 14;
                            break;
                        }
                        case 883849137: {
                            if (!string.equals(Rollup.PAGE_SIZE_FIELD)) break;
                            n = 15;
                            break;
                        }
                        case 414334925: {
                            if (!string.equals(Rollup.DIMENSIONS_FIELD)) break;
                            n = 16;
                            break;
                        }
                    }
                    switch (n) {
                        case 7: {
                            String string2 = xcp.text();
                            boolean bl4 = false;
                            boolean bl5 = false;
                            if (string2 != null) continue block36;
                            boolean bl6 = false;
                            String string3 = "The rollup_id field is null";
                            throw (Throwable)new IllegalArgumentException(string3.toString());
                        }
                        case 6: {
                            enabled = xcp.booleanValue();
                            continue block36;
                        }
                        case 9: {
                            schedule = ScheduleParser.parse((XContentParser)xcp);
                            continue block36;
                        }
                        case 8: {
                            schemaVersion = xcp.longValue();
                            continue block36;
                        }
                        case 1: {
                            enabledTime = ElasticExtensionsKt.instant(xcp);
                            continue block36;
                        }
                        case 11: {
                            lastUpdatedTime = ElasticExtensionsKt.instant(xcp);
                            continue block36;
                        }
                        case 4: {
                            description = xcp.text();
                            continue block36;
                        }
                        case 5: {
                            sourceIndex = xcp.text();
                            continue block36;
                        }
                        case 2: {
                            targetIndex = xcp.text();
                            continue block36;
                        }
                        case 13: {
                            metadataID = xcp.textOrNull();
                            continue block36;
                        }
                        case 3: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                String string4 = xcp.text();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"xcp.text()");
                                roles.add(string4);
                            }
                            continue block36;
                        }
                        case 15: {
                            pageSize = xcp.intValue();
                            continue block36;
                        }
                        case 10: {
                            delay = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Long.valueOf(xcp.longValue());
                            continue block36;
                        }
                        case 12: {
                            continuous = xcp.booleanValue();
                            continue block36;
                        }
                        case 16: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                dimensions.add(Dimension.Companion.parse(xcp));
                            }
                            continue block36;
                        }
                        case 14: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                metrics.add(RollupMetrics.Companion.parse(xcp));
                            }
                            continue block36;
                        }
                    }
                }
                throw (Throwable)new IllegalArgumentException("Invalid field [" + fieldName + "] found in Rollup.");
            }
            if (enabled && enabledTime == null) {
                enabledTime = Instant.now();
            } else if (!enabled) {
                enabledTime = null;
            }
            if ((seqNo == -2L || primaryTerm == 0L) && schedule instanceof IntervalSchedule) {
                schedule = (Schedule)new IntervalSchedule(Instant.now(), ((IntervalSchedule)schedule).getInterval(), ((IntervalSchedule)schedule).getUnit());
            }
            long l = schemaVersion;
            boolean bl7 = enabled;
            long l2 = primaryTerm;
            long l3 = seqNo;
            String string = id;
            bl3 = false;
            boolean bl8 = false;
            if (schedule == null) {
                boolean bl9 = false;
                String string5 = "Rollup schedule is null";
                throw (Throwable)new IllegalArgumentException(string5.toString());
            }
            Schedule schedule2 = schedule;
            Instant instant = lastUpdatedTime;
            if (instant == null) {
                Instant instant2 = Instant.now();
                instant = instant2;
                Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"Instant.now()");
            }
            Instant instant3 = enabledTime;
            Instant instant4 = instant;
            bl3 = false;
            bl8 = false;
            if (description == null) {
                boolean bl10 = false;
                String string6 = "Rollup description is null";
                throw (Throwable)new IllegalArgumentException(string6.toString());
            }
            String string7 = description;
            bl3 = false;
            bl8 = false;
            if (sourceIndex == null) {
                boolean bl11 = false;
                String string8 = "Rollup source index is null";
                throw (Throwable)new IllegalArgumentException(string8.toString());
            }
            String string9 = sourceIndex;
            bl3 = false;
            bl8 = false;
            if (targetIndex == null) {
                boolean bl12 = false;
                String string10 = "Rollup target index is null";
                throw (Throwable)new IllegalArgumentException(string10.toString());
            }
            String string11 = targetIndex;
            List list = CollectionsKt.toList((Iterable)roles);
            String string12 = metadataID;
            bl3 = false;
            bl8 = false;
            if (pageSize == null) {
                boolean bl13 = false;
                String string13 = "Rollup page size is null";
                throw (Throwable)new IllegalArgumentException(string13.toString());
            }
            Integer n = pageSize;
            List list2 = metrics;
            List list3 = dimensions;
            boolean bl14 = continuous;
            Long l4 = delay;
            int n2 = ((Number)n).intValue();
            List list4 = list;
            String string14 = string12;
            String string15 = string11;
            String string16 = string9;
            String string17 = string7;
            Instant instant5 = instant3;
            Instant instant6 = instant4;
            Schedule schedule3 = schedule2;
            long l5 = l;
            boolean bl15 = bl7;
            long l6 = l2;
            long l7 = l3;
            String string18 = string;
            return new Rollup(string18, l7, l6, bl15, l5, schedule3, instant6, instant5, string17, string16, string15, string14, list4, n2, l4, bl14, list3, list2);
        }

        public static /* synthetic */ Rollup parse$default(Companion companion, XContentParser xContentParser, String string, long l, long l2, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = Rollup.NO_ID;
            }
            if ((n & 4) != 0) {
                l = -2L;
            }
            if ((n & 8) != 0) {
                l2 = 0L;
            }
            return companion.parse(xContentParser, string, l, l2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rollup parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo) throws IOException {
            return com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup$Companion.parse$default(this, xcp, id, seqNo, 0L, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rollup parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
            return com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup$Companion.parse$default(this, xcp, id, 0L, 0L, 12, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rollup parse(@NotNull XContentParser xcp) throws IOException {
            return com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup$Companion.parse$default(this, xcp, null, 0L, 0L, 14, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup$Companion$ScheduleType;", "", "(Ljava/lang/String;I)V", "CRON", "INTERVAL", "opendistro-index-management"})
        public static final class ScheduleType
        extends Enum<ScheduleType> {
            public static final /* enum */ ScheduleType CRON;
            public static final /* enum */ ScheduleType INTERVAL;
            private static final /* synthetic */ ScheduleType[] $VALUES;

            static {
                ScheduleType[] scheduleTypeArray = new ScheduleType[2];
                ScheduleType[] scheduleTypeArray2 = scheduleTypeArray;
                scheduleTypeArray[0] = CRON = new ScheduleType();
                scheduleTypeArray[1] = INTERVAL = new ScheduleType();
                $VALUES = scheduleTypeArray;
            }

            public static ScheduleType[] values() {
                return (ScheduleType[])$VALUES.clone();
            }

            public static ScheduleType valueOf(String string) {
                return Enum.valueOf(ScheduleType.class, string);
            }
        }
    }
}

