/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model;

import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.ISMRollup$WhenMappings;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.ISMRollup$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.RollupMetrics;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.dimension.DateHistogram;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.dimension.Dimension;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.dimension.Histogram;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.dimension.Terms;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.metric.Metric;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule.IntervalSchedule;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.schedule.Schedule;
import com.amazon.opendistroforelasticsearch.notification.repackage.org.apache.commons.codec.digest.DigestUtils;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B9\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u00c6\u0003JG\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\nH\u00d6\u0001J\u001e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00072\u000e\b\u0002\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\b\u0010(\u001a\u00020\u0007H\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u00063"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/ISMRollup;", "Lorg/elasticsearch/common/xcontent/ToXContentObject;", "Lorg/elasticsearch/common/io/stream/Writeable;", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "(Lorg/elasticsearch/common/io/stream/StreamInput;)V", "description", "", "targetIndex", "pageSize", "", "dimensions", "", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/dimension/Dimension;", "metrics", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/RollupMetrics;", "(Ljava/lang/String;Ljava/lang/String;ILjava/util/List;Ljava/util/List;)V", "getDescription", "()Ljava/lang/String;", "getDimensions", "()Ljava/util/List;", "getMetrics", "getPageSize", "()I", "getTargetIndex", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toRollup", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;", "sourceIndex", "roles", "toString", "toXContent", "Lorg/elasticsearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/elasticsearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/elasticsearch/common/io/stream/StreamOutput;", "Companion", "opendistro-index-management"})
public final class ISMRollup
implements ToXContentObject,
Writeable {
    @NotNull
    private final String description;
    @NotNull
    private final String targetIndex;
    private final int pageSize;
    @NotNull
    private final List<Dimension> dimensions;
    @NotNull
    private final List<RollupMetrics> metrics;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        builder.startObject().field("description", this.description).field("target_index", this.targetIndex).field("page_size", this.pageSize).field("dimensions", (Iterable)this.dimensions).field("metrics", (Iterable)this.metrics);
        builder.endObject();
        return builder;
    }

    @NotNull
    public final Rollup toRollup(@NotNull String sourceIndex, @NotNull List<String> roles) {
        Intrinsics.checkParameterIsNotNull((Object)sourceIndex, (String)"sourceIndex");
        Intrinsics.checkParameterIsNotNull(roles, (String)"roles");
        String id = sourceIndex + this.toString();
        Instant currentTime = Instant.now();
        String string = DigestUtils.sha1Hex((String)id);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DigestUtils.sha1Hex(id)");
        Schedule schedule = (Schedule)new IntervalSchedule(Instant.now(), 1, ChronoUnit.MINUTES);
        Instant instant = currentTime;
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"currentTime");
        return new Rollup(string, -2L, 0L, true, 1L, schedule, instant, currentTime, this.description, sourceIndex, this.targetIndex, null, roles, this.pageSize, null, false, this.dimensions, this.metrics);
    }

    public static /* synthetic */ Rollup toRollup$default(ISMRollup iSMRollup, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return iSMRollup.toRollup(string, list);
    }

    @NotNull
    public String toString() {
        Object it;
        StringBuffer sb = new StringBuffer();
        sb.append(this.targetIndex);
        sb.append(this.pageSize);
        Iterable $this$forEach$iv = this.dimensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Dimension)element$iv;
            boolean bl = false;
            sb.append((Object)((Dimension)it).getType());
            sb.append(((Dimension)it).getSourceField());
        }
        $this$forEach$iv = this.metrics;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (RollupMetrics)element$iv;
            boolean bl = false;
            sb.append(((RollupMetrics)it).getSourceField());
            Iterable $this$forEach$iv2 = ((RollupMetrics)it).getMetrics();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Metric metric = (Metric)element$iv2;
                boolean bl2 = false;
                sb.append((Object)metric.getType());
            }
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        out.writeString(this.description);
        out.writeString(this.targetIndex);
        out.writeInt(this.pageSize);
        out.writeVInt(this.dimensions.size());
        for (Dimension dimension : this.dimensions) {
            out.writeEnum((Enum)dimension.getType());
            Dimension dimension2 = dimension;
            if (dimension2 instanceof DateHistogram) {
                dimension.writeTo(out);
                continue;
            }
            if (dimension2 instanceof Terms) {
                dimension.writeTo(out);
                continue;
            }
            if (!(dimension2 instanceof Histogram)) continue;
            dimension.writeTo(out);
        }
        out.writeCollection((Collection)this.metrics);
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getTargetIndex() {
        return this.targetIndex;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    @NotNull
    public final List<Dimension> getDimensions() {
        return this.dimensions;
    }

    @NotNull
    public final List<RollupMetrics> getMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - void declaration
     */
    public ISMRollup(@NotNull String description, @NotNull String targetIndex, int pageSize, @NotNull List<? extends Dimension> dimensions, @NotNull List<RollupMetrics> metrics) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkParameterIsNotNull(dimensions, (String)"dimensions");
        Intrinsics.checkParameterIsNotNull(metrics, (String)"metrics");
        this.description = description;
        this.targetIndex = targetIndex;
        this.pageSize = pageSize;
        this.dimensions = dimensions;
        this.metrics = metrics;
        int n = this.pageSize;
        n = 1 <= n && 10000 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Page size must be between 1 and 10000";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        CharSequence charSequence = this.description;
        bl = false;
        boolean bl4 = charSequence.length() > 0;
        bl = false;
        bl2 = false;
        if (!bl4) {
            boolean bl5 = false;
            String string = "Description cannot be empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        CharSequence charSequence2 = this.targetIndex;
        bl = false;
        boolean bl6 = charSequence2.length() > 0;
        bl = false;
        bl2 = false;
        if (!bl6) {
            boolean bl7 = false;
            String string = "Target Index cannot be empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Iterable $this$filter$iv = this.dimensions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Dimension it = (Dimension)element$iv$iv;
            boolean bl8 = false;
            if (!(it.getType() == Dimension.Type.DATE_HISTOGRAM)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        boolean bl9 = ((List)destination$iv$iv).size() == 1;
        bl = false;
        boolean bl10 = false;
        if (!bl9) {
            boolean bl11 = false;
            String string = "Must specify precisely one date histogram dimension";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl9 = ((Dimension)CollectionsKt.first(this.dimensions)).getType() == Dimension.Type.DATE_HISTOGRAM;
        bl = false;
        bl10 = false;
        if (!bl9) {
            boolean bl12 = false;
            String string = "The first dimension must be a date histogram";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public ISMRollup(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sin.readString()");
        String string2 = sin.readString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sin.readString()");
        StreamInput streamInput = sin;
        int n = sin.readInt();
        String string3 = string2;
        String string4 = string;
        ISMRollup iSMRollup = this;
        boolean bl = false;
        boolean bl2 = false;
        StreamInput it = streamInput;
        boolean bl3 = false;
        boolean bl4 = false;
        List dimensionsList = new ArrayList();
        int size = it.readVInt();
        int n2 = 0;
        int n3 = size;
        while (n2 < n3) {
            void i2;
            Dimension dimension;
            Dimension.Type type = (Dimension.Type)it.readEnum(Dimension.Type.class);
            List list = dimensionsList;
            boolean bl5 = false;
            boolean bl6 = false;
            if (type == null) {
                boolean bl7 = false;
                String string5 = "Dimension type cannot be null";
                throw (Throwable)new IllegalArgumentException(string5.toString());
            }
            Dimension.Type type2 = type;
            switch (ISMRollup$WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1: {
                    dimension = new DateHistogram(sin);
                    break;
                }
                case 2: {
                    dimension = new Terms(sin);
                    break;
                }
                case 3: {
                    dimension = new Histogram(sin);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            list.add(dimension);
            ++i2;
        }
        List list = CollectionsKt.toList((Iterable)dimensionsList);
        Object object = 8.INSTANCE;
        if (object != null) {
            streamInput = object;
            object = new ISMRollup$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0((Function1)streamInput);
        }
        List list2 = sin.readList((Writeable.Reader)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"sin.readList(::RollupMetrics)");
        iSMRollup(string4, string3, n, list, list2);
    }

    @NotNull
    public final String component1() {
        return this.description;
    }

    @NotNull
    public final String component2() {
        return this.targetIndex;
    }

    public final int component3() {
        return this.pageSize;
    }

    @NotNull
    public final List<Dimension> component4() {
        return this.dimensions;
    }

    @NotNull
    public final List<RollupMetrics> component5() {
        return this.metrics;
    }

    @NotNull
    public final ISMRollup copy(@NotNull String description, @NotNull String targetIndex, int pageSize, @NotNull List<? extends Dimension> dimensions, @NotNull List<RollupMetrics> metrics) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkParameterIsNotNull(dimensions, (String)"dimensions");
        Intrinsics.checkParameterIsNotNull(metrics, (String)"metrics");
        return new ISMRollup(description, targetIndex, pageSize, dimensions, metrics);
    }

    public static /* synthetic */ ISMRollup copy$default(ISMRollup iSMRollup, String string, String string2, int n, List list, List list2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = iSMRollup.description;
        }
        if ((n2 & 2) != 0) {
            string2 = iSMRollup.targetIndex;
        }
        if ((n2 & 4) != 0) {
            n = iSMRollup.pageSize;
        }
        if ((n2 & 8) != 0) {
            list = iSMRollup.dimensions;
        }
        if ((n2 & 0x10) != 0) {
            list2 = iSMRollup.metrics;
        }
        return iSMRollup.copy(string, string2, n, list, list2);
    }

    public int hashCode() {
        String string = this.description;
        String string2 = this.targetIndex;
        List<Dimension> list = this.dimensions;
        List<RollupMetrics> list2 = this.metrics;
        return ((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Integer.hashCode(this.pageSize)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ISMRollup)) break block3;
                ISMRollup iSMRollup = (ISMRollup)object;
                if (!Intrinsics.areEqual((Object)this.description, (Object)iSMRollup.description) || !Intrinsics.areEqual((Object)this.targetIndex, (Object)iSMRollup.targetIndex) || this.pageSize != iSMRollup.pageSize || !Intrinsics.areEqual(this.dimensions, iSMRollup.dimensions) || !Intrinsics.areEqual(this.metrics, iSMRollup.metrics)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final ISMRollup parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/ISMRollup$Companion;", "", "()V", "parse", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/ISMRollup;", "xcp", "Lorg/elasticsearch/common/xcontent/XContentParser;", "opendistro-index-management"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ISMRollup parse(@NotNull XContentParser xcp) throws IOException {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)xcp, (String)"xcp");
            String description = "";
            String targetIndex = "";
            int pageSize = 0;
            boolean bl = false;
            List dimensions = new ArrayList();
            boolean bl2 = false;
            List metrics = new ArrayList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block14: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                if (fieldName != null) {
                    int n = -1;
                    switch (((String)((Object)list)).hashCode()) {
                        case -207303516: {
                            if (!((String)((Object)list)).equals("target_index")) break;
                            n = 1;
                            break;
                        }
                        case -1724546052: {
                            if (!((String)((Object)list)).equals("description")) break;
                            n = 2;
                            break;
                        }
                        case 955826371: {
                            if (!((String)((Object)list)).equals("metrics")) break;
                            n = 3;
                            break;
                        }
                        case 883849137: {
                            if (!((String)((Object)list)).equals("page_size")) break;
                            n = 4;
                            break;
                        }
                        case 414334925: {
                            if (!((String)((Object)list)).equals("dimensions")) break;
                            n = 5;
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            Intrinsics.checkExpressionValueIsNotNull((Object)xcp.text(), (String)"xcp.text()");
                            continue block14;
                        }
                        case 1: {
                            Intrinsics.checkExpressionValueIsNotNull((Object)xcp.text(), (String)"xcp.text()");
                            continue block14;
                        }
                        case 4: {
                            pageSize = xcp.intValue();
                            continue block14;
                        }
                        case 5: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                dimensions.add(Dimension.Companion.parse(xcp));
                            }
                            continue block14;
                        }
                        case 3: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                metrics.add(RollupMetrics.Companion.parse(xcp));
                            }
                            continue block14;
                        }
                    }
                }
                throw (Throwable)new IllegalArgumentException("Invalid field, [" + fieldName + "] not supported in ISM Rollup.");
            }
            String string = targetIndex;
            list = metrics;
            List list2 = dimensions;
            int n = pageSize;
            return new ISMRollup(description, string, n, list2, list);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

