/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.rollup.interceptor;

import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.RollupFieldMapping;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.dimension.Dimension;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.settings.RollupSettings;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.util.RollupUtilsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.BoostingQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.search.MatchQuery;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.MinAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJH\u0010\u0015\u001a&\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00190\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001eH\u0002J.\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0018H\u0002J(\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010(\u001a\u0004\u0018\u00010)2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0002J>\u0010*\u001a\b\u0012\u0004\u0012\u0002H,0+\"\b\b\u0000\u0010,*\u00020-2\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u00112\f\u00101\u001a\b\u0012\u0004\u0012\u0002H,0+H\u0016J\u0016\u00102\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00180\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00064"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/interceptor/RollupInterceptor;", "Lorg/elasticsearch/transport/TransportInterceptor;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "settings", "Lorg/elasticsearch/common/settings/Settings;", "indexNameExpressionResolver", "Lorg/elasticsearch/cluster/metadata/IndexNameExpressionResolver;", "(Lorg/elasticsearch/cluster/service/ClusterService;Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/cluster/metadata/IndexNameExpressionResolver;)V", "getClusterService", "()Lorg/elasticsearch/cluster/service/ClusterService;", "getIndexNameExpressionResolver", "()Lorg/elasticsearch/cluster/metadata/IndexNameExpressionResolver;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "searchEnabled", "", "Ljava/lang/Boolean;", "getSettings", "()Lorg/elasticsearch/common/settings/Settings;", "findMatchingRollupJobs", "Lkotlin/Pair;", "", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;", "", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/RollupFieldMapping;", "", "fieldMappings", "rollupJobs", "", "getAggregationMetadata", "aggregationBuilders", "", "Lorg/elasticsearch/search/aggregations/AggregationBuilder;", "", "getEstimateRollupInterval", "", "rollup", "getQueryMetadata", "query", "Lorg/elasticsearch/index/query/QueryBuilder;", "interceptHandler", "Lorg/elasticsearch/transport/TransportRequestHandler;", "T", "Lorg/elasticsearch/transport/TransportRequest;", "action", "executor", "forceExecution", "actualHandler", "pickRollupJob", "rollups", "opendistro-index-management"})
public final class RollupInterceptor
implements TransportInterceptor {
    private final Logger logger;
    private volatile Boolean searchEnabled;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @NotNull
    public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(@NotNull String action2, @NotNull String executor, boolean forceExecution, @NotNull TransportRequestHandler<T> actualHandler) {
        Intrinsics.checkParameterIsNotNull((Object)action2, (String)"action");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull(actualHandler, (String)"actualHandler");
        return new TransportRequestHandler<T>(this, actualHandler){
            final /* synthetic */ RollupInterceptor this$0;
            final /* synthetic */ TransportRequestHandler $actualHandler;

            /*
             * WARNING - void declaration
             */
            public void messageReceived(@NotNull T request, @NotNull TransportChannel channel, @NotNull Task task) {
                Intrinsics.checkParameterIsNotNull(request, (String)"request");
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
                Boolean bl = RollupInterceptor.access$getSearchEnabled$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"searchEnabled");
                if (bl.booleanValue() && request instanceof ShardSearchRequest) {
                    Boolean isRollupIndex;
                    ShardId shardId = ((ShardSearchRequest)request).shardId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)shardId, (String)"request.shardId()");
                    String index = shardId.getIndexName();
                    Setting<Boolean> setting = RollupSettings.Companion.getROLLUP_INDEX();
                    ClusterState clusterState = this.this$0.getClusterService().state();
                    Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterService.state()");
                    IndexMetadata indexMetadata = clusterState.getMetadata().index(index);
                    Intrinsics.checkExpressionValueIsNotNull((Object)indexMetadata, (String)"clusterService.state().metadata.index(index)");
                    Boolean bl2 = isRollupIndex = (Boolean)setting.get(indexMetadata.getSettings());
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"isRollupIndex");
                    if (bl2.booleanValue()) {
                        void $this$associateByTo$iv$iv;
                        void matchingRollupJobs;
                        String string;
                        Object object;
                        Collection collection;
                        void $this$mapTo$iv$iv;
                        if (((ShardSearchRequest)request).source().size() != 0) {
                            throw (Throwable)new IllegalArgumentException("Rollup search must have size explicitly set to 0, but found " + ((ShardSearchRequest)request).source().size());
                        }
                        String[] stringArray = ((ShardSearchRequest)request).indices();
                        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"request.indices()");
                        String[] $this$map$iv = stringArray;
                        boolean $i$f$map = false;
                        String[] stringArray2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        for (void item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            collection = item$iv$iv;
                            object = destination$iv$iv;
                            boolean bl3 = false;
                            string = it.toString();
                            object.add(string);
                        }
                        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
                        if (stringArray3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        String[] indices = stringArray3;
                        String[] concreteIndices = this.this$0.getIndexNameExpressionResolver().concreteIndexNames(this.this$0.getClusterService().state(), ((ShardSearchRequest)request).indicesOptions(), Arrays.copyOf(indices, indices.length));
                        if (concreteIndices.length > 1) {
                            RollupInterceptor.access$getLogger$p(this.this$0).warn("There can be only one index in search request if its a rollup search - requested to search [" + concreteIndices.length + "] indices including rollup index [" + index + ']');
                            throw (Throwable)new IllegalArgumentException("Searching rollup index with other indices is not supported currently");
                        }
                        ClusterState clusterState2 = this.this$0.getClusterService().state();
                        Intrinsics.checkExpressionValueIsNotNull((Object)clusterState2, (String)"clusterService.state()");
                        IndexMetadata indexMetadata2 = clusterState2.getMetadata().index(index);
                        Intrinsics.checkExpressionValueIsNotNull((Object)indexMetadata2, (String)"clusterService.state().metadata.index(index)");
                        List<Rollup> list = RollupUtilsKt.getRollupJobs(indexMetadata2);
                        if (list == null) {
                            throw (Throwable)new IllegalArgumentException("Could not find any valid rollup job on the index");
                        }
                        List<Rollup> rollupJobs = list;
                        Set queryFieldMappings = RollupInterceptor.getQueryMetadata$default(this.this$0, ((ShardSearchRequest)request).source().query(), null, 2, null);
                        AggregatorFactories.Builder builder = ((ShardSearchRequest)request).source().aggregations();
                        Set aggregationFieldMappings = RollupInterceptor.getAggregationMetadata$default(this.this$0, builder != null ? builder.getAggregatorFactories() : null, null, 2, null);
                        Set fieldMappings = SetsKt.plus((Set)queryFieldMappings, (Iterable)aggregationFieldMappings);
                        Pair pair = RollupInterceptor.access$findMatchingRollupJobs(this.this$0, fieldMappings, rollupJobs);
                        Map map = (Map)pair.component1();
                        Set issues = (Set)pair.component2();
                        if (matchingRollupJobs.isEmpty()) {
                            throw (Throwable)new IllegalArgumentException("Could not find a rollup job that can answer this query because " + issues);
                        }
                        Rollup matchedRollup = RollupInterceptor.access$pickRollupJob(this.this$0, matchingRollupJobs.keySet());
                        Iterable $this$associateBy$iv = (Iterable)MapsKt.getValue((Map)matchingRollupJobs, (Object)matchedRollup);
                        boolean $i$f$associateBy = false;
                        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                        Iterable iterable = $this$associateBy$iv;
                        Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv);
                        boolean $i$f$associateByTo = false;
                        for (T element$iv$iv : $this$associateByTo$iv$iv) {
                            RollupFieldMapping it;
                            RollupFieldMapping rollupFieldMapping = (RollupFieldMapping)element$iv$iv;
                            object = destination$iv$iv2;
                            boolean bl4 = false;
                            string = it.getFieldName();
                            it = (RollupFieldMapping)element$iv$iv;
                            boolean bl5 = false;
                            String string2 = it.getMappingType();
                            object.put(string, string2);
                        }
                        Map fieldNameMappingTypeMap = destination$iv$iv2;
                        collection = fieldMappings;
                        boolean bl6 = false;
                        if (!collection.isEmpty()) {
                            ShardSearchRequest shardSearchRequest = (ShardSearchRequest)request;
                            SearchSourceBuilder searchSourceBuilder = ((ShardSearchRequest)request).source();
                            Intrinsics.checkExpressionValueIsNotNull((Object)searchSourceBuilder, (String)"request.source()");
                            shardSearchRequest.source(RollupUtilsKt.rewriteSearchSourceBuilder(searchSourceBuilder, matchedRollup, fieldNameMappingTypeMap));
                        }
                    }
                }
                this.$actualHandler.messageReceived(request, channel, task);
            }
            {
                this.this$0 = $outer;
                this.$actualHandler = $captured_local_variable$1;
            }
        };
    }

    private final Set<RollupFieldMapping> getAggregationMetadata(Collection<? extends AggregationBuilder> aggregationBuilders, Set<RollupFieldMapping> fieldMappings) {
        Collection<? extends AggregationBuilder> collection = aggregationBuilders;
        if (collection != null) {
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AggregationBuilder it = (AggregationBuilder)element$iv;
                boolean bl = false;
                Object object = it;
                if (object instanceof TermsAggregationBuilder) {
                    String string = ((TermsAggregationBuilder)it).field();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.field()");
                    String string2 = ((TermsAggregationBuilder)it).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, string2, null, 8, null));
                } else if (object instanceof DateHistogramAggregationBuilder) {
                    String string = ((DateHistogramAggregationBuilder)it).field();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.field()");
                    String string3 = ((DateHistogramAggregationBuilder)it).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, string3, null, 8, null));
                } else if (object instanceof HistogramAggregationBuilder) {
                    String string = ((HistogramAggregationBuilder)it).field();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.field()");
                    String string4 = ((HistogramAggregationBuilder)it).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, string4, null, 8, null));
                } else if (object instanceof SumAggregationBuilder) {
                    String string = ((SumAggregationBuilder)it).field();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.field()");
                    String string5 = ((SumAggregationBuilder)it).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string, string5, null, 8, null));
                } else if (object instanceof AvgAggregationBuilder) {
                    String string = ((AvgAggregationBuilder)it).field();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.field()");
                    String string6 = ((AvgAggregationBuilder)it).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string, string6, null, 8, null));
                } else if (object instanceof MaxAggregationBuilder) {
                    String string = ((MaxAggregationBuilder)it).field();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.field()");
                    String string7 = ((MaxAggregationBuilder)it).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string, string7, null, 8, null));
                } else if (object instanceof MinAggregationBuilder) {
                    String string = ((MinAggregationBuilder)it).field();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.field()");
                    String string8 = ((MinAggregationBuilder)it).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string, string8, null, 8, null));
                } else if (object instanceof ValueCountAggregationBuilder) {
                    String string = ((ValueCountAggregationBuilder)it).field();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.field()");
                    String string9 = ((ValueCountAggregationBuilder)it).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string, string9, null, 8, null));
                } else {
                    throw (Throwable)new IllegalArgumentException("The " + it.getType() + " aggregation is not currently supported in rollups");
                }
                Collection collection2 = it.getSubAggregations();
                if (collection2 == null) continue;
                object = collection2;
                boolean bl2 = false;
                if (!(!object.isEmpty())) continue;
                this.getAggregationMetadata(it.getSubAggregations(), fieldMappings);
            }
        }
        return fieldMappings;
    }

    static /* synthetic */ Set getAggregationMetadata$default(RollupInterceptor rollupInterceptor, Collection collection, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        return rollupInterceptor.getAggregationMetadata(collection, set);
    }

    private final Set<RollupFieldMapping> getQueryMetadata(QueryBuilder query, Set<RollupFieldMapping> fieldMappings) {
        if (query == null) {
            return fieldMappings;
        }
        QueryBuilder queryBuilder = query;
        if (queryBuilder instanceof TermQueryBuilder) {
            String string = ((TermQueryBuilder)query).fieldName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"query.fieldName()");
            fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, Dimension.Type.TERMS.getType(), null, 8, null));
        } else if (queryBuilder instanceof TermsQueryBuilder) {
            String string = ((TermsQueryBuilder)query).fieldName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"query.fieldName()");
            fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, Dimension.Type.TERMS.getType(), null, 8, null));
        } else if (queryBuilder instanceof RangeQueryBuilder) {
            String string = ((RangeQueryBuilder)query).fieldName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"query.fieldName()");
            fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, "unknown", null, 8, null));
        } else if (!(queryBuilder instanceof MatchAllQueryBuilder)) {
            if (queryBuilder instanceof BoolQueryBuilder) {
                QueryBuilder it;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                List list = ((BoolQueryBuilder)query).must();
                if (list != null) {
                    $this$forEach$iv = list;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (QueryBuilder)element$iv;
                        boolean bl = false;
                        this.getQueryMetadata(it, fieldMappings);
                    }
                }
                List list2 = ((BoolQueryBuilder)query).mustNot();
                if (list2 != null) {
                    $this$forEach$iv = list2;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (QueryBuilder)element$iv;
                        boolean bl = false;
                        this.getQueryMetadata(it, fieldMappings);
                    }
                }
                List list3 = ((BoolQueryBuilder)query).should();
                if (list3 != null) {
                    $this$forEach$iv = list3;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (QueryBuilder)element$iv;
                        boolean bl = false;
                        this.getQueryMetadata(it, fieldMappings);
                    }
                }
                List list4 = ((BoolQueryBuilder)query).filter();
                if (list4 != null) {
                    $this$forEach$iv = list4;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (QueryBuilder)element$iv;
                        boolean bl = false;
                        this.getQueryMetadata(it, fieldMappings);
                    }
                }
            } else if (queryBuilder instanceof BoostingQueryBuilder) {
                this.getQueryMetadata(((BoostingQueryBuilder)query).positiveQuery(), fieldMappings);
                this.getQueryMetadata(((BoostingQueryBuilder)query).negativeQuery(), fieldMappings);
            } else if (queryBuilder instanceof ConstantScoreQueryBuilder) {
                this.getQueryMetadata(((ConstantScoreQueryBuilder)query).innerQuery(), fieldMappings);
            } else if (queryBuilder instanceof DisMaxQueryBuilder) {
                List list = ((DisMaxQueryBuilder)query).innerQueries();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"query.innerQueries()");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    QueryBuilder it = (QueryBuilder)element$iv;
                    boolean bl = false;
                    this.getQueryMetadata(it, fieldMappings);
                }
            } else if (queryBuilder instanceof MatchPhraseQueryBuilder) {
                CharSequence charSequence = ((MatchPhraseQueryBuilder)query).analyzer();
                boolean bl = false;
                boolean bl2 = false;
                if (!(charSequence == null || charSequence.length() == 0) || ((MatchPhraseQueryBuilder)query).slop() != 0 || ((MatchPhraseQueryBuilder)query).zeroTermsQuery() != MatchQuery.DEFAULT_ZERO_TERMS_QUERY) {
                    throw (Throwable)new IllegalArgumentException("The " + ((MatchPhraseQueryBuilder)query).getName() + " query is currently not supported with analyzer/slop/zero_terms_query in " + "rollups");
                }
                String string = ((MatchPhraseQueryBuilder)query).fieldName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"query.fieldName()");
                fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, Dimension.Type.TERMS.getType(), null, 8, null));
            } else {
                throw (Throwable)new IllegalArgumentException("The " + query.getName() + " query is currently not supported in rollups");
            }
        }
        return fieldMappings;
    }

    static /* synthetic */ Set getQueryMetadata$default(RollupInterceptor rollupInterceptor, QueryBuilder queryBuilder, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        return rollupInterceptor.getQueryMetadata(queryBuilder, set);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Pair<Map<Rollup, Set<RollupFieldMapping>>, Set<String>> findMatchingRollupJobs(Set<RollupFieldMapping> fieldMappings, List<Rollup> rollupJobs) {
        $this$map$iv = rollupJobs;
        $i$f$map = false;
        var6_6 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var11_22 = (Rollup)item$iv$iv;
            var27_29 = destination$iv$iv;
            $i$a$-map-RollupInterceptor$findMatchingRollupJobs$rollupFieldMappings$1 = false;
            var28_30 /* !! */  = TuplesKt.to((Object)rollup, RollupUtilsKt.populateFieldMappings((Rollup)rollup));
            var27_29.add(var28_30 /* !! */ );
        }
        rollupFieldMappings = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        knownFieldMappings = new LinkedHashSet<E>();
        $this$mapTo$iv$iv = false;
        unknownFields = new LinkedHashSet<E>();
        $this$forEach$iv = fieldMappings;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (RollupFieldMapping)element$iv;
            $i$a$-forEach-RollupInterceptor$findMatchingRollupJobs$1 = false;
            if (Intrinsics.areEqual((Object)it.getMappingType(), (Object)"unknown")) {
                unknownFields.add(it.getFieldName());
                continue;
            }
            knownFieldMappings.add(it);
        }
        $this$filterValues$iv = rollupFieldMappings;
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap<K, V>();
        it = $this$filterValues$iv;
        $i$a$-forEach-RollupInterceptor$findMatchingRollupJobs$1 = false;
        for (Map.Entry<K, V> entry$iv : it.entrySet()) {
            it = (Set)entry$iv.getValue();
            $i$a$-filterValues-RollupInterceptor$findMatchingRollupJobs$potentialRollupFieldMappings$1 = false;
            if (!it.containsAll(knownFieldMappings)) ** GOTO lbl-1000
            $this$map$iv = it;
            $i$f$map = false;
            var18_43 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var23_49 = (RollupFieldMapping)item$iv$iv;
                var24_50 = destination$iv$iv;
                $i$a$-map-RollupInterceptor$findMatchingRollupJobs$potentialRollupFieldMappings$1$1 = false;
                var26_52 = rollupFieldMapping.getFieldName();
                var24_50.add(var26_52);
            }
            if (((List)destination$iv$iv).containsAll(unknownFields)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        potentialRollupFieldMappings = result$iv;
        $i$f$filterValues = false;
        issues = new LinkedHashSet<E>();
        if (potentialRollupFieldMappings.isEmpty()) {
            result$iv = false;
            allFieldMappings = new LinkedHashSet<E>();
            $this$forEach$iv = rollupFieldMappings.values();
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (Set)element$iv /* !! */ ;
                $i$a$-forEach-RollupInterceptor$findMatchingRollupJobs$2 = false;
                allFieldMappings.addAll(it);
            }
            $this$map$iv = allFieldMappings;
            $i$f$map = false;
            element$iv /* !! */  = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                $i$f$map = (RollupFieldMapping)item$iv$iv;
                var27_29 = destination$iv$iv;
                $i$a$-map-RollupInterceptor$findMatchingRollupJobs$allFields$1 = false;
                var28_30 /* !! */  = it.getFieldName();
                var27_29.add(var28_30 /* !! */ );
            }
            allFields = (List)destination$iv$iv;
            $this$forEach$iv = fieldMappings;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (RollupFieldMapping)element$iv;
                $i$a$-forEach-RollupInterceptor$findMatchingRollupJobs$3 = false;
                if (!allFields.contains(it.getFieldName())) {
                    issues.add(it.toIssue(true));
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)it.getMappingType(), (Object)"unknown") ^ true) || allFieldMappings.contains(it)) continue;
                issues.add(RollupFieldMapping.toIssue$default(it, false, 1, null));
            }
        }
        return TuplesKt.to((Object)potentialRollupFieldMappings, (Object)issues);
    }

    /*
     * WARNING - void declaration
     */
    private final Rollup pickRollupJob(Set<Rollup> rollups2) {
        if (rollups2.size() == 1) {
            return (Rollup)CollectionsKt.first((Iterable)rollups2);
        }
        Iterable $this$reduce$iv = rollups2;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void new_;
            Rollup rollup2 = (Rollup)iterator$iv.next();
            Rollup matched = (Rollup)accumulator$iv;
            boolean bl = false;
            accumulator$iv = this.getEstimateRollupInterval(matched) > this.getEstimateRollupInterval((Rollup)new_) ? matched : new_;
        }
        return (Rollup)accumulator$iv;
    }

    private final long getEstimateRollupInterval(Rollup rollup2) {
        return RollupUtilsKt.getDateHistogram(rollup2).getCalendarInterval() != null ? new DateHistogramInterval(RollupUtilsKt.getDateHistogram(rollup2).getCalendarInterval()).estimateMillis() : new DateHistogramInterval(RollupUtilsKt.getDateHistogram(rollup2).getFixedInterval()).estimateMillis();
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final IndexNameExpressionResolver getIndexNameExpressionResolver() {
        return this.indexNameExpressionResolver;
    }

    public RollupInterceptor(@NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull IndexNameExpressionResolver indexNameExpressionResolver) {
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        this.clusterService = clusterService;
        this.settings = settings;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.logger = LogManager.getLogger(this.getClass());
        this.searchEnabled = (Boolean)RollupSettings.Companion.getROLLUP_SEARCH_ENABLED().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.Companion.getROLLUP_SEARCH_ENABLED(), (Consumer)new Consumer<Boolean>(){

            @Override
            public final void accept(Boolean it) {
                searchEnabled = it;
            }
        });
    }

    public static final /* synthetic */ Boolean access$getSearchEnabled$p(RollupInterceptor $this) {
        return $this.searchEnabled;
    }

    public static final /* synthetic */ Logger access$getLogger$p(RollupInterceptor $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Pair access$findMatchingRollupJobs(RollupInterceptor $this, Set fieldMappings, List rollupJobs) {
        return $this.findMatchingRollupJobs(fieldMappings, rollupJobs);
    }

    public static final /* synthetic */ Rollup access$pickRollupJob(RollupInterceptor $this, Set rollups2) {
        return $this.pickRollupJob(rollups2);
    }
}

