/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.stop;

import com.amazon.opendistroforelasticsearch.indexmanagement.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.get.GetRollupAction;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.get.GetRollupRequest;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.get.GetRollupResponse;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.stop.StopRollupAction;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.stop.StopRollupRequest;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.stop.TransportStopRollupAction$WhenMappings;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.stop.TransportStopRollupAction$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.RollupMetadata;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0014J&\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0002J&\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0002J.\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/action/stop/TransportStopRollupAction;", "Lorg/elasticsearch/action/support/HandledTransportAction;", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/action/stop/StopRollupRequest;", "Lorg/elasticsearch/action/support/master/AcknowledgedResponse;", "transportService", "Lorg/elasticsearch/transport/TransportService;", "client", "Lorg/elasticsearch/client/Client;", "actionFilters", "Lorg/elasticsearch/action/support/ActionFilters;", "(Lorg/elasticsearch/transport/TransportService;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/action/support/ActionFilters;)V", "getClient", "()Lorg/elasticsearch/client/Client;", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "doExecute", "", "task", "Lorg/elasticsearch/tasks/Task;", "request", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "getRollupMetadata", "rollup", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;", "updateRollupJob", "updateRollupMetadata", "metadata", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/RollupMetadata;", "opendistro-index-management"})
public final class TransportStopRollupAction
extends HandledTransportAction<StopRollupRequest, AcknowledgedResponse> {
    private final Logger log;
    @NotNull
    private final Client client;

    protected void doExecute(@NotNull Task task, @NotNull StopRollupRequest request, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        this.log.debug("Executing StopRollupAction on " + request.id());
        String string = request.id();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.id()");
        GetRollupRequest getReq = new GetRollupRequest(string, null, null, 4, null);
        this.client.execute((ActionType)GetRollupAction.Companion.getINSTANCE(), (ActionRequest)getReq, (ActionListener)new ActionListener<GetRollupResponse>(this, actionListener, request){
            final /* synthetic */ TransportStopRollupAction this$0;
            final /* synthetic */ ActionListener $actionListener;
            final /* synthetic */ StopRollupRequest $request;

            public void onResponse(@NotNull GetRollupResponse response2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)response2), (String)"response");
                Rollup rollup2 = response2.getRollup();
                if (rollup2 == null) {
                    this.$actionListener.onFailure((Exception)new ElasticsearchStatusException("Could not find rollup [" + this.$request.id() + ']', RestStatus.NOT_FOUND, new Object[0]));
                    return;
                }
                if (rollup2.getMetadataID() != null) {
                    TransportStopRollupAction.access$getRollupMetadata(this.this$0, rollup2, this.$request, this.$actionListener);
                } else {
                    TransportStopRollupAction.access$updateRollupJob(this.this$0, rollup2, this.$request, this.$actionListener);
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                if (throwable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Exception /* = java.lang.Exception */");
                }
                this.$actionListener.onFailure((Exception)throwable);
            }
            {
                this.this$0 = $outer;
                this.$actionListener = $captured_local_variable$1;
                this.$request = $captured_local_variable$2;
            }
        });
    }

    private final void getRollupMetadata(Rollup rollup2, StopRollupRequest request, ActionListener<AcknowledgedResponse> actionListener) {
        GetRequest req = new GetRequest(".opendistro-ism-config", rollup2.getMetadataID()).routing(rollup2.getId());
        this.client.get(req, (ActionListener)new ActionListener<GetResponse>(this, rollup2, request, actionListener){
            final /* synthetic */ TransportStopRollupAction this$0;
            final /* synthetic */ Rollup $rollup;
            final /* synthetic */ StopRollupRequest $request;
            final /* synthetic */ ActionListener $actionListener;

            public void onResponse(@NotNull GetResponse response2) {
                Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                if (!response2.isExists() || response2.isSourceEmpty()) {
                    TransportStopRollupAction.access$updateRollupJob(this.this$0, this.$rollup, this.$request, this.$actionListener);
                } else {
                    RollupMetadata metadata2;
                    RollupMetadata rollupMetadata;
                    BytesReference bytesReference = response2.getSourceAsBytesRef();
                    if (bytesReference != null) {
                        XContentParser xcp;
                        BytesReference bytesReference2 = bytesReference;
                        boolean bl = false;
                        boolean bl2 = false;
                        BytesReference it = bytesReference2;
                        boolean bl3 = false;
                        XContentParser xContentParser = xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)it, (XContentType)XContentType.JSON);
                        Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"xcp");
                        String string = response2.getId();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.id");
                        rollupMetadata = (RollupMetadata)ElasticExtensionsKt.parseWithType(xContentParser, string, response2.getSeqNo(), response2.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, RollupMetadata>(RollupMetadata.Companion){

                            @NotNull
                            public final RollupMetadata invoke(@NotNull XContentParser p1, @NotNull String p2, long p3, long p4) {
                                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                                return ((RollupMetadata.Companion)this.receiver).parse(p1, p2, p3, p4);
                            }

                            public final KDeclarationContainer getOwner() {
                                return Reflection.getOrCreateKotlinClass(RollupMetadata.Companion.class);
                            }

                            public final String getName() {
                                return "parse";
                            }

                            public final String getSignature() {
                                return "parse(Lorg/elasticsearch/common/xcontent/XContentParser;Ljava/lang/String;JJ)Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/RollupMetadata;";
                            }
                        });
                    } else {
                        rollupMetadata = metadata2 = null;
                    }
                    if (metadata2 == null) {
                        TransportStopRollupAction.access$updateRollupJob(this.this$0, this.$rollup, this.$request, this.$actionListener);
                    } else {
                        TransportStopRollupAction.access$updateRollupMetadata(this.this$0, this.$rollup, metadata2, this.$request, this.$actionListener);
                    }
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                if (throwable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Exception /* = java.lang.Exception */");
                }
                this.$actionListener.onFailure((Exception)throwable);
            }
            {
                this.this$0 = $outer;
                this.$rollup = $captured_local_variable$1;
                this.$request = $captured_local_variable$2;
                this.$actionListener = $captured_local_variable$3;
            }
        });
    }

    private final void updateRollupMetadata(Rollup rollup2, RollupMetadata metadata2, StopRollupRequest request, ActionListener<AcknowledgedResponse> actionListener) {
        RollupMetadata.Status status;
        long now = Instant.now().toEpochMilli();
        switch (TransportStopRollupAction$WhenMappings.$EnumSwitchMapping$0[metadata2.getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                status = RollupMetadata.Status.STOPPED;
                break;
            }
            case 4: 
            case 5: {
                status = metadata2.getStatus();
                break;
            }
            case 6: {
                status = RollupMetadata.Status.FAILED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        RollupMetadata.Status updatedStatus = status;
        String failureReason = metadata2.getStatus() == RollupMetadata.Status.RETRY ? "Stopped a rollup that was in retry, rolling back to failed status" : null;
        UpdateRequest updateRequest = new UpdateRequest(".opendistro-ism-config", rollup2.getMetadataID()).doc(MapsKt.mapOf((Pair)TuplesKt.to((Object)"rollup_metadata", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"status", (Object)updatedStatus.getType()), TuplesKt.to((Object)"failure_reason", (Object)failureReason), TuplesKt.to((Object)"last_updated_time", (Object)now)}))));
        this.client.update(updateRequest, (ActionListener)new ActionListener<UpdateResponse>(this, rollup2, request, actionListener){
            final /* synthetic */ TransportStopRollupAction this$0;
            final /* synthetic */ Rollup $rollup;
            final /* synthetic */ StopRollupRequest $request;
            final /* synthetic */ ActionListener $actionListener;

            public void onResponse(@NotNull UpdateResponse response2) {
                Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                if (response2.getResult() == DocWriteResponse.Result.UPDATED) {
                    TransportStopRollupAction.access$updateRollupJob(this.this$0, this.$rollup, this.$request, this.$actionListener);
                } else {
                    this.$actionListener.onResponse((Object)new AcknowledgedResponse(false));
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                if (throwable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Exception /* = java.lang.Exception */");
                }
                this.$actionListener.onFailure((Exception)throwable);
            }
            {
                this.this$0 = $outer;
                this.$rollup = $captured_local_variable$1;
                this.$request = $captured_local_variable$2;
                this.$actionListener = $captured_local_variable$3;
            }
        });
    }

    private final void updateRollupJob(Rollup rollup2, StopRollupRequest request, ActionListener<AcknowledgedResponse> actionListener) {
        long now = Instant.now().toEpochMilli();
        ((UpdateRequest)request.index(".opendistro-ism-config")).setIfSeqNo(rollup2.getSeqNo()).setIfPrimaryTerm(rollup2.getPrimaryTerm()).doc(MapsKt.mapOf((Pair)TuplesKt.to((Object)"rollup", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"enabled", (Object)false), TuplesKt.to((Object)"enabled_time", null), TuplesKt.to((Object)"last_updated_time", (Object)now)}))));
        this.client.update((UpdateRequest)request, (ActionListener)new ActionListener<UpdateResponse>(actionListener){
            final /* synthetic */ ActionListener $actionListener;

            public void onResponse(@NotNull UpdateResponse response2) {
                Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                this.$actionListener.onResponse((Object)new AcknowledgedResponse(response2.getResult() == DocWriteResponse.Result.UPDATED));
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                if (throwable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Exception /* = java.lang.Exception */");
                }
                this.$actionListener.onFailure((Exception)throwable);
            }
            {
                this.$actionListener = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @Inject
    public TransportStopRollupAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters) {
        Intrinsics.checkParameterIsNotNull((Object)transportService, (String)"transportService");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)actionFilters, (String)"actionFilters");
        String string = StopRollupAction.Companion.getNAME();
        Object object = 1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new TransportStopRollupAction$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0(function1);
        }
        super(string, transportService, actionFilters, (Writeable.Reader)object);
        this.client = client;
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    public static final /* synthetic */ void access$getRollupMetadata(TransportStopRollupAction $this, Rollup rollup2, StopRollupRequest request, ActionListener actionListener) {
        $this.getRollupMetadata(rollup2, request, (ActionListener<AcknowledgedResponse>)actionListener);
    }

    public static final /* synthetic */ void access$updateRollupJob(TransportStopRollupAction $this, Rollup rollup2, StopRollupRequest request, ActionListener actionListener) {
        $this.updateRollupJob(rollup2, request, (ActionListener<AcknowledgedResponse>)actionListener);
    }

    public static final /* synthetic */ void access$updateRollupMetadata(TransportStopRollupAction $this, Rollup rollup2, RollupMetadata metadata2, StopRollupRequest request, ActionListener actionListener) {
        $this.updateRollupMetadata(rollup2, metadata2, request, (ActionListener<AcknowledgedResponse>)actionListener);
    }
}

