/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.mapping;

import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.util.RestHandlerUtilsKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.mapping.UpdateRollupMappingAction;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.mapping.UpdateRollupMappingRequest;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B7\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0014J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u0014R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/action/mapping/TransportUpdateRollupMappingAction;", "Lorg/elasticsearch/action/support/master/TransportMasterNodeAction;", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/action/mapping/UpdateRollupMappingRequest;", "Lorg/elasticsearch/action/support/master/AcknowledgedResponse;", "threadPool", "Lorg/elasticsearch/threadpool/ThreadPool;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "transportService", "Lorg/elasticsearch/transport/TransportService;", "actionFilters", "Lorg/elasticsearch/action/support/ActionFilters;", "indexNameExpressionResolver", "Lorg/elasticsearch/cluster/metadata/IndexNameExpressionResolver;", "client", "Lorg/elasticsearch/client/Client;", "(Lorg/elasticsearch/threadpool/ThreadPool;Lorg/elasticsearch/cluster/service/ClusterService;Lorg/elasticsearch/transport/TransportService;Lorg/elasticsearch/action/support/ActionFilters;Lorg/elasticsearch/cluster/metadata/IndexNameExpressionResolver;Lorg/elasticsearch/client/Client;)V", "getClient", "()Lorg/elasticsearch/client/Client;", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "checkBlock", "Lorg/elasticsearch/cluster/block/ClusterBlockException;", "request", "state", "Lorg/elasticsearch/cluster/ClusterState;", "executor", "", "masterOperation", "", "listener", "Lorg/elasticsearch/action/ActionListener;", "read", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "opendistro-index-management"})
public final class TransportUpdateRollupMappingAction
extends TransportMasterNodeAction<UpdateRollupMappingRequest, AcknowledgedResponse> {
    private final Logger log;
    @NotNull
    private final Client client;

    @Nullable
    protected ClusterBlockException checkBlock(@NotNull UpdateRollupMappingRequest request, @NotNull ClusterState state2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        return state2.getBlocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, new String[]{request.getRollup().getTargetIndex()});
    }

    protected void masterOperation(@NotNull UpdateRollupMappingRequest request, @NotNull ClusterState state2, @NotNull ActionListener<AcknowledgedResponse> listener) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        IndexMetadata index = state2.getMetadata().index(request.getRollup().getTargetIndex());
        if (index == null) {
            this.log.debug("Could not find index [" + index + ']');
            listener.onFailure((Exception)new IllegalStateException("Could not find index [" + index + ']'));
            return;
        }
        MappingMetadata mappings = index.mapping();
        if (mappings == null) {
            this.log.debug("Could not find mapping for index [" + index + ']');
            listener.onFailure((Exception)new IllegalStateException("Could not find mapping for index [" + index + ']'));
            return;
        }
        Map source = mappings.getSourceAsMap();
        if (source == null) {
            this.log.debug("Could not find source for index mapping [" + index + ']');
            listener.onFailure((Exception)new IllegalStateException("Could not find source for index mapping [" + index + ']'));
            return;
        }
        Rollup rollup2 = request.getRollup();
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"XContentFactory.jsonBuilder()");
        Map rollup3 = (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)rollup2.toXContent(xContentBuilder, (ToXContent.Params)RestHandlerUtilsKt.getXCONTENT_WITHOUT_TYPE())), (boolean)false, (XContentType)XContentType.JSON).v2();
        boolean bl = false;
        Map metaMappings = new LinkedHashMap();
        Object meta = source.get("_meta");
        if (meta == null) {
            this.log.debug("Could not find meta mappings for index [" + index + "], creating meta mappings");
            Map rollupJobEntries = MapsKt.mapOf((Pair)TuplesKt.to((Object)request.getRollup().getId(), (Object)rollup3));
            Map rollups2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"rollups", (Object)rollupJobEntries));
            metaMappings.put("_meta", rollups2);
        } else {
            Object updatedRollups;
            Map rollupJobEntries;
            Map rollups2 = (Map)meta;
            String string = "rollups";
            boolean bl2 = false;
            Object rollups3 = rollups2.get(string);
            if (rollups3 == null) {
                this.log.debug("Could not find meta rollup mappings for index [" + index + "], creating meta rollup mappings");
                rollupJobEntries = MapsKt.mapOf((Pair)TuplesKt.to((Object)request.getRollup().getId(), (Object)rollup3));
                updatedRollups = MapsKt.mapOf((Pair)TuplesKt.to((Object)"rollups", (Object)rollupJobEntries));
                metaMappings.put("_meta", updatedRollups);
            } else {
                rollupJobEntries = (Map)rollups3;
                updatedRollups = request.getRollup().getId();
                bl2 = false;
                if (rollupJobEntries.containsKey(updatedRollups)) {
                    this.log.debug("Meta rollup mappings already contain rollup " + request.getRollup().getId() + " for index [" + index + ']');
                    listener.onFailure((Exception)new IllegalStateException("Meta rollup mappings already contain rollup " + request.getRollup().getId() + " for index [" + index + ']'));
                    return;
                }
                rollupJobEntries = MapsKt.toMutableMap((Map)((Map)rollups3));
                rollupJobEntries.put(request.getRollup().getId(), rollup3);
                updatedRollups = MapsKt.mapOf((Pair)TuplesKt.to((Object)"rollups", (Object)rollupJobEntries));
                metaMappings.put("_meta", updatedRollups);
            }
        }
        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{request.getRollup().getTargetIndex()}).type("_doc").source(metaMappings);
        this.client.admin().indices().putMapping(putMappingRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(listener){
            final /* synthetic */ ActionListener $listener;

            public void onResponse(@NotNull AcknowledgedResponse response2) {
                Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                this.$listener.onResponse((Object)response2);
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    protected AcknowledgedResponse read(@NotNull StreamInput sin) {
        Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
        return new AcknowledgedResponse(sin);
    }

    @NotNull
    protected String executor() {
        return "same";
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @Inject
    public TransportUpdateRollupMappingAction(@NotNull ThreadPool threadPool, @NotNull ClusterService clusterService, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Client client) {
        Intrinsics.checkParameterIsNotNull((Object)threadPool, (String)"threadPool");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        Intrinsics.checkParameterIsNotNull((Object)transportService, (String)"transportService");
        Intrinsics.checkParameterIsNotNull((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkParameterIsNotNull((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        super(UpdateRollupMappingAction.Companion.getINSTANCE().name(), transportService, clusterService, threadPool, actionFilters, (Writeable.Reader)1.INSTANCE, indexNameExpressionResolver);
        this.client = client;
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }
}

