/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.index;

import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/action/index/IndexRollupRequest;", "Lorg/elasticsearch/action/index/IndexRequest;", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "(Lorg/elasticsearch/common/io/stream/StreamInput;)V", "rollup", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;", "refreshPolicy", "Lorg/elasticsearch/action/support/WriteRequest$RefreshPolicy;", "(Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;Lorg/elasticsearch/action/support/WriteRequest$RefreshPolicy;)V", "getRollup", "()Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;", "setRollup", "(Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;)V", "validate", "Lorg/elasticsearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/elasticsearch/common/io/stream/StreamOutput;", "opendistro-index-management"})
public final class IndexRollupRequest
extends IndexRequest {
    @NotNull
    private Rollup rollup;

    @NotNull
    public final Rollup getRollup() {
        return this.rollup;
    }

    public final void setRollup(@NotNull Rollup rollup2) {
        Intrinsics.checkParameterIsNotNull((Object)rollup2, (String)"<set-?>");
        this.rollup = rollup2;
    }

    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (StringsKt.isBlank((CharSequence)this.rollup.getId())) {
            validationException = ValidateActions.addValidationError((String)"rollupID is missing", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        super.writeTo(out);
        this.rollup.writeTo(out);
        this.getRefreshPolicy().writeTo(out);
    }

    public IndexRollupRequest(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
        super(sin);
        this.rollup = new Rollup(sin);
        super.setRefreshPolicy(WriteRequest.RefreshPolicy.readFrom((StreamInput)sin));
    }

    public IndexRollupRequest(@NotNull Rollup rollup2, @NotNull WriteRequest.RefreshPolicy refreshPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)rollup2, (String)"rollup");
        Intrinsics.checkParameterIsNotNull((Object)refreshPolicy, (String)"refreshPolicy");
        this.rollup = rollup2;
        if (rollup2.getSeqNo() == -2L || rollup2.getPrimaryTerm() == 0L) {
            this.opType(DocWriteRequest.OpType.CREATE);
        } else {
            this.setIfSeqNo(rollup2.getSeqNo()).setIfPrimaryTerm(rollup2.getPrimaryTerm());
        }
        super.setRefreshPolicy(refreshPolicy);
    }
}

