/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.get;

import com.amazon.opendistroforelasticsearch.indexmanagement.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.get.GetRollupsAction;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.get.GetRollupsRequest;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.get.GetRollupsResponse;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.action.get.TransportGetRollupsAction$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B'\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/action/get/TransportGetRollupsAction;", "Lorg/elasticsearch/action/support/HandledTransportAction;", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/action/get/GetRollupsRequest;", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/action/get/GetRollupsResponse;", "transportService", "Lorg/elasticsearch/transport/TransportService;", "client", "Lorg/elasticsearch/client/Client;", "actionFilters", "Lorg/elasticsearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "(Lorg/elasticsearch/transport/TransportService;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/action/support/ActionFilters;Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/elasticsearch/client/Client;", "getXContentRegistry", "()Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/elasticsearch/tasks/Task;", "request", "listener", "Lorg/elasticsearch/action/ActionListener;", "opendistro-index-management"})
public final class TransportGetRollupsAction
extends HandledTransportAction<GetRollupsRequest, GetRollupsResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;

    protected void doExecute(@NotNull Task task, @NotNull GetRollupsRequest request, @NotNull ActionListener<GetRollupsResponse> listener) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        String string = request.getSearchString();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String searchString = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        int from = request.getFrom();
        int size = request.getSize();
        String sortField = request.getSortField();
        String sortDirection = request.getSortDirection();
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)new ExistsQueryBuilder("rollup"));
        CharSequence charSequence = searchString;
        boolean bl2 = false;
        if (charSequence.length() > 0) {
            boolQueryBuilder.filter((QueryBuilder)new WildcardQueryBuilder("rollup.rollup_id.keyword", '*' + searchString + '*'));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).from(from).size(size).seqNoAndPrimaryTerm(Boolean.valueOf(true)).sort(sortField, SortOrder.fromString((String)sortDirection));
        SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-ism-config"}).source(searchSourceBuilder);
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(listener){
            final /* synthetic */ ActionListener $listener;

            /*
             * WARNING - void declaration
             */
            public void onResponse(@NotNull SearchResponse response2) {
                Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                SearchHits searchHits = response2.getHits();
                Intrinsics.checkExpressionValueIsNotNull((Object)searchHits, (String)"response.hits");
                TotalHits totalHits = searchHits.getTotalHits();
                long totalRollups = totalHits != null ? totalHits.value : 0L;
                ShardSearchFailure[] shardSearchFailureArray = response2.getShardFailures();
                Intrinsics.checkExpressionValueIsNotNull((Object)shardSearchFailureArray, (String)"response.shardFailures");
                ShardSearchFailure[] shardSearchFailureArray2 = shardSearchFailureArray;
                boolean bl = false;
                ShardSearchFailure[] shardSearchFailureArray3 = shardSearchFailureArray2;
                boolean bl2 = false;
                if (!(shardSearchFailureArray3.length == 0)) {
                    Object[] objectArray = response2.getShardFailures();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"response.shardFailures");
                    Object[] $this$reduce$iv = objectArray;
                    boolean $i$f$reduce = false;
                    Object[] objectArray2 = $this$reduce$iv;
                    int n = 0;
                    if (objectArray2.length == 0) {
                        throw (Throwable)new UnsupportedOperationException("Empty array can't be reduced.");
                    }
                    ShardSearchFailure accumulator$iv = $this$reduce$iv[0];
                    n = 1;
                    int n2 = ArraysKt.getLastIndex((Object[])$this$reduce$iv);
                    if (n <= n2) {
                        while (true) {
                            void s2;
                            void index$iv;
                            Object object = $this$reduce$iv[index$iv];
                            ShardSearchFailure s1 = accumulator$iv;
                            boolean bl3 = false;
                            RestStatus restStatus = s1.status();
                            Intrinsics.checkExpressionValueIsNotNull((Object)restStatus, (String)"s1.status()");
                            int n3 = restStatus.getStatus();
                            RestStatus restStatus2 = s2.status();
                            Intrinsics.checkExpressionValueIsNotNull((Object)restStatus2, (String)"s2.status()");
                            Object object2 = accumulator$iv = n3 > restStatus2.getStatus() ? s1 : s2;
                            if (index$iv == n2) break;
                            ++index$iv;
                        }
                    }
                    ShardSearchFailure failure = accumulator$iv;
                    RestStatus restStatus = failure.status();
                    ShardSearchFailure shardSearchFailure = failure;
                    Intrinsics.checkExpressionValueIsNotNull((Object)shardSearchFailure, (String)"failure");
                    this.$listener.onFailure((Exception)new ElasticsearchStatusException("Get rollups failed on some shards", restStatus, shardSearchFailure.getCause(), new Object[0]));
                } else {
                    try {
                        void $this$mapTo$iv$iv;
                        SearchHits searchHits2 = response2.getHits();
                        Intrinsics.checkExpressionValueIsNotNull((Object)searchHits2, (String)"response.hits");
                        SearchHit[] searchHitArray = searchHits2.getHits();
                        Intrinsics.checkExpressionValueIsNotNull((Object)searchHitArray, (String)"response.hits.hits");
                        SearchHit[] $this$map$iv = searchHitArray;
                        boolean $i$f$map = false;
                        SearchHit[] accumulator$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        void var10_19 = $this$mapTo$iv$iv;
                        int n = ((void)var10_19).length;
                        for (int j = 0; j < n; ++j) {
                            void it;
                            void item$iv$iv;
                            void var14_25 = item$iv$iv = var10_19[j];
                            Collection collection = destination$iv$iv;
                            boolean bl4 = false;
                            void v12 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"it");
                            BytesReference bytesReference = v12.getSourceRef();
                            Intrinsics.checkExpressionValueIsNotNull((Object)bytesReference, (String)"it.sourceRef");
                            XContentParser xContentParser = ElasticExtensionsKt.contentParser(bytesReference);
                            String string = it.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.id");
                            Rollup rollup2 = (Rollup)ElasticExtensionsKt.parseWithType(xContentParser, string, it.getSeqNo(), it.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, Rollup>(Rollup.Companion){

                                @NotNull
                                public final Rollup invoke(@NotNull XContentParser p1, @NotNull String p2, long p3, long p4) {
                                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                                    Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                                    return ((Rollup.Companion)this.receiver).parse(p1, p2, p3, p4);
                                }

                                public final KDeclarationContainer getOwner() {
                                    return Reflection.getOrCreateKotlinClass(Rollup.Companion.class);
                                }

                                public final String getName() {
                                    return "parse";
                                }

                                public final String getSignature() {
                                    return "parse(Lorg/elasticsearch/common/xcontent/XContentParser;Ljava/lang/String;JJ)Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;";
                                }
                            });
                            collection.add(rollup2);
                        }
                        List rollups2 = (List)destination$iv$iv;
                        this.$listener.onResponse((Object)((Object)new GetRollupsResponse(rollups2, (int)totalRollups, RestStatus.OK)));
                    }
                    catch (Exception e) {
                        this.$listener.onFailure((Exception)new ElasticsearchStatusException("Failed to parse rollups", RestStatus.INTERNAL_SERVER_ERROR, ExceptionsHelper.unwrapCause((Throwable)e), new Object[0]));
                    }
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Inject
    public TransportGetRollupsAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)transportService, (String)"transportService");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkParameterIsNotNull((Object)xContentRegistry, (String)"xContentRegistry");
        String string = GetRollupsAction.Companion.getNAME();
        Object object = 1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new TransportGetRollupsAction$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0(function1);
        }
        super(string, transportService, actionFilters, (Writeable.Reader)object);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }
}

