/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.rollup;

import com.amazon.opendistroforelasticsearch.indexmanagement.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.RollupSearchResult;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.RollupSearchService;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.ContinuousMetadata;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.RollupMetadata;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.settings.RollupSettings;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.util.RollupUtilsKt;
import java.time.Instant;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.transport.RemoteTransportException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ!\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/RollupSearchService;", "", "settings", "Lorg/elasticsearch/common/settings/Settings;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "client", "Lorg/elasticsearch/client/Client;", "(Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/cluster/service/ClusterService;Lorg/elasticsearch/client/Client;)V", "getClient", "()Lorg/elasticsearch/client/Client;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "retrySearchPolicy", "Lorg/elasticsearch/action/bulk/BackoffPolicy;", "executeCompositeSearch", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/RollupSearchResult;", "job", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;", "metadata", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/RollupMetadata;", "(Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/Rollup;Lcom/amazon/opendistroforelasticsearch/indexmanagement/rollup/model/RollupMetadata;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasNextFullWindow", "", "shouldProcessRollup", "rollup", "opendistro-index-management"})
public final class RollupSearchService {
    private final Logger logger;
    private volatile BackoffPolicy retrySearchPolicy;
    @NotNull
    private final Client client;

    public final boolean shouldProcessRollup(@NotNull Rollup rollup2, @Nullable RollupMetadata metadata2) {
        Intrinsics.checkParameterIsNotNull((Object)rollup2, (String)"rollup");
        if (!rollup2.getEnabled()) {
            return false;
        }
        if (metadata2 == null) {
            return true;
        }
        if (metadata2.getStatus() == RollupMetadata.Status.RETRY) {
            return true;
        }
        if (CollectionsKt.listOf((Object[])new RollupMetadata.Status[]{RollupMetadata.Status.STOPPED, RollupMetadata.Status.FAILED}).contains((Object)metadata2.getStatus())) {
            return false;
        }
        if (metadata2.getAfterKey() != null) {
            return true;
        }
        if (!rollup2.getContinuous()) {
            if (CollectionsKt.listOf((Object[])new RollupMetadata.Status[]{RollupMetadata.Status.INIT, RollupMetadata.Status.STARTED}).contains((Object)metadata2.getStatus())) {
                return true;
            }
            this.logger.debug("Non-continuous job [" + rollup2.getId() + "] is not processing next window [" + metadata2 + ']');
            return false;
        }
        return this.hasNextFullWindow(metadata2);
    }

    private final boolean hasNextFullWindow(RollupMetadata metadata2) {
        Instant instant = Instant.now();
        ContinuousMetadata continuousMetadata = metadata2.getContinuous();
        if (continuousMetadata == null) {
            Intrinsics.throwNpe();
        }
        return instant.isAfter(continuousMetadata.getNextWindowEndTime());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object executeCompositeSearch(@NotNull Rollup job, @NotNull RollupMetadata metadata, @NotNull Continuation<? super RollupSearchResult> $completion) {
        if (!($completion instanceof executeCompositeSearch.1)) ** GOTO lbl-1000
        var19_4 = $completion;
        if ((var19_4.label & -2147483648) != 0) {
            var19_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ RollupSearchService this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executeCompositeSearch(null, null, (Continuation<? super RollupSearchResult>)this);
                }
                {
                    this.this$0 = rollupSearchService;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 /* !! */  = new Ref.IntRef();
                var4_7 /* !! */ .element = 0;
                v0 = this.retrySearchPolicy;
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"retrySearchPolicy");
                v1 = this.logger;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"logger");
                $continuation.L$0 = this;
                $continuation.L$1 = job;
                $continuation.L$2 = metadata;
                $continuation.L$3 = retryCount;
                $continuation.label = 1;
                v2 = ElasticExtensionsKt.retry$default(v0, v1, null, (Function2)new Function2<TimeValue, Continuation<? super SearchResponse>, Object>(this, retryCount, job, metadata, null){
                    private TimeValue p$0;
                    Object L$0;
                    float F$0;
                    int label;
                    final /* synthetic */ RollupSearchService this$0;
                    final /* synthetic */ Ref.IntRef $retryCount;
                    final /* synthetic */ Rollup $job;
                    final /* synthetic */ RollupMetadata $metadata;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                TimeValue it = this.p$0;
                                float f = 2.0f;
                                int n = this.$retryCount.element;
                                this.$retryCount.element = n + 1;
                                boolean bl = false;
                                float decay = (float)Math.pow(f, n);
                                this.L$0 = it;
                                this.F$0 = decay;
                                this.label = 1;
                                Object object2 = ElasticExtensionsKt.suspendUntil((ElasticsearchClient)this.this$0.getClient(), (Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(this, decay){
                                    final /* synthetic */ executeCompositeSearch.2 this$0;
                                    final /* synthetic */ float $decay;

                                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> listener) {
                                        Intrinsics.checkParameterIsNotNull((Object)$this$suspendUntil, (String)"$receiver");
                                        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
                                        int n = 1;
                                        int n2 = this.this$0.$job.getPageSize() / (int)this.$decay;
                                        boolean bl = false;
                                        int pageSize = Math.max(n, n2);
                                        if (this.$decay > 1.0f) {
                                            RollupSearchService.access$getLogger$p(this.this$0.this$0).warn("Composite search failed for rollup, retrying [#" + (this.this$0.$retryCount.element - 1) + "] -" + " reducing page size of composite aggregation from " + this.this$0.$job.getPageSize() + " to " + pageSize);
                                        }
                                        $this$suspendUntil.search(RollupUtilsKt.getRollupSearchRequest(Rollup.copy$default(this.this$0.$job, null, 0L, 0L, false, 0L, null, null, null, null, null, null, null, null, pageSize, null, false, null, null, 253951, null), this.this$0.$metadata), listener);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$decay = f;
                                        super(2);
                                    }
                                }, this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                float decay = this.F$0;
                                TimeValue it = (TimeValue)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = rollupSearchService;
                        this.$retryCount = intRef;
                        this.$job = rollup2;
                        this.$metadata = rollupMetadata;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                        Function2<TimeValue, Continuation<? super SearchResponse>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        TimeValue timeValue = function2.p$0 = (TimeValue)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Continuation)$continuation, 2, null);
                ** if (v2 != var21_6) goto lbl28
lbl27:
                // 1 sources

                return var21_6;
lbl28:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                retryCount = (Ref.IntRef)$continuation.L$3;
                metadata = (RollupMetadata)$continuation.L$2;
                job = (Rollup)$continuation.L$1;
                this = (RollupSearchService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl38:
                    // 2 sources

                    var17_8 = v2;
                    var20_9 = (SearchResponse)var17_8;
                    var4_7 /* !! */  = new RollupSearchResult.Success(var20_9);
                }
                catch (SearchPhaseExecutionException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    v3 = e.shardFailures();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"e.shardFailures()");
                    var6_15 = v3;
                    var7_16 = false;
                    if (var6_15.length == 0) {
                        v4 = ExceptionsHelper.unwrapCause((Throwable)e);
                        if (v4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Exception /* = java.lang.Exception */");
                        }
                        v5 = new RollupSearchResult.Failure(null, (Exception)v4, 1, null);
                    } else {
                        v6 = e.shardFailures();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"e.shardFailures()");
                        $this$reduce$iv = v6;
                        $i$f$reduce = false;
                        var9_19 = $this$reduce$iv;
                        var10_20 = 0;
                        if (var9_19.length == 0) {
                            throw (Throwable)new UnsupportedOperationException("Empty array can't be reduced.");
                        }
                        accumulator$iv = $this$reduce$iv[0];
                        var10_20 = 1;
                        var11_21 = ArraysKt.getLastIndex((Object[])$this$reduce$iv);
                        if (var10_20 <= var11_21) {
                            while (true) {
                                var12_22 = $this$reduce$iv[index$iv];
                                s1 = accumulator$iv;
                                $i$a$-reduce-RollupSearchService$executeCompositeSearch$shardFailure$1 = false;
                                v7 = s1.status();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"s1.status()");
                                v8 = v7.getStatus();
                                v9 = s2.status();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"s2.status()");
                                v10 /* !! */  = accumulator$iv = v8 > v9.getStatus() ? s1 : s2;
                                if (index$iv == var11_21) break;
                                ++index$iv;
                            }
                        }
                        v11 = shardFailure = accumulator$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"shardFailure");
                        v12 = ExceptionsHelper.unwrapCause((Throwable)v11.getCause());
                        if (v12 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Exception /* = java.lang.Exception */");
                        }
                        v5 = new RollupSearchResult.Failure(null, (Exception)v12, 1, null);
                    }
                    var4_7 /* !! */  = v5;
                }
                catch (RemoteTransportException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    v13 = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (v13 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Exception /* = java.lang.Exception */");
                    }
                    var4_7 /* !! */  = new RollupSearchResult.Failure(null, (Exception)v13, 1, null);
                }
                catch (CircuitBreakingException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    var4_7 /* !! */  = new RollupSearchResult.Failure(null, (Exception)e, 1, null);
                }
                catch (MultiBucketConsumerService.TooManyBucketsException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    var4_7 /* !! */  = new RollupSearchResult.Failure(null, (Exception)e, 1, null);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    var4_7 /* !! */  = new RollupSearchResult.Failure(null, e, 1, null);
                }
                return var4_7 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    public RollupSearchService(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull Client client) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
        this.logger = LogManager.getLogger(this.getClass());
        TimeValue timeValue = (TimeValue)RollupSettings.Companion.getROLLUP_SEARCH_BACKOFF_MILLIS().get(settings);
        Object object = RollupSettings.Companion.getROLLUP_SEARCH_BACKOFF_COUNT().get(settings);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ROLLUP_SEARCH_BACKOFF_COUNT.get(settings)");
        this.retrySearchPolicy = BackoffPolicy.constantBackoff((TimeValue)timeValue, (int)((Number)object).intValue());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.Companion.getROLLUP_SEARCH_BACKOFF_MILLIS(), RollupSettings.Companion.getROLLUP_SEARCH_BACKOFF_COUNT(), (BiConsumer)new BiConsumer<TimeValue, Integer>(){

            @Override
            public final void accept(TimeValue millis, Integer count) {
                Integer n = count;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"count");
                retrySearchPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)n);
            }
        });
    }

    public static final /* synthetic */ Logger access$getLogger$p(RollupSearchService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ BackoffPolicy access$getRetrySearchPolicy$p(RollupSearchService $this) {
        return $this.retrySearchPolicy;
    }
}

