/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy;

import com.amazon.opendistroforelasticsearch.indexmanagement.IndexManagementIndices;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.ISMTemplateServiceKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.ISMTemplate;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.Policy;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyAction;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyRequest;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyResponse;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.TransportIndexPolicyActionKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.TransportIndexPolicyActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0;
import com.amazon.opendistroforelasticsearch.indexmanagement.util.IndexManagementException;
import com.amazon.opendistroforelasticsearch.indexmanagement.util.IndexUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001cB/\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00022\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/TransportIndexPolicyAction;", "Lorg/elasticsearch/action/support/HandledTransportAction;", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/IndexPolicyRequest;", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/IndexPolicyResponse;", "client", "Lorg/elasticsearch/client/node/NodeClient;", "transportService", "Lorg/elasticsearch/transport/TransportService;", "actionFilters", "Lorg/elasticsearch/action/support/ActionFilters;", "ismIndices", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/IndexManagementIndices;", "xContentRegistry", "Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "(Lorg/elasticsearch/client/node/NodeClient;Lorg/elasticsearch/transport/TransportService;Lorg/elasticsearch/action/support/ActionFilters;Lcom/amazon/opendistroforelasticsearch/indexmanagement/IndexManagementIndices;Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/elasticsearch/client/node/NodeClient;", "getIsmIndices", "()Lcom/amazon/opendistroforelasticsearch/indexmanagement/IndexManagementIndices;", "getXContentRegistry", "()Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/elasticsearch/tasks/Task;", "request", "listener", "Lorg/elasticsearch/action/ActionListener;", "IndexPolicyHandler", "opendistro-index-management"})
public final class TransportIndexPolicyAction
extends HandledTransportAction<IndexPolicyRequest, IndexPolicyResponse> {
    @NotNull
    private final NodeClient client;
    @NotNull
    private final IndexManagementIndices ismIndices;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;

    protected void doExecute(@NotNull Task task, @NotNull IndexPolicyRequest request, @NotNull ActionListener<IndexPolicyResponse> listener) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        new IndexPolicyHandler(this.client, listener, request).start();
    }

    @NotNull
    public final NodeClient getClient() {
        return this.client;
    }

    @NotNull
    public final IndexManagementIndices getIsmIndices() {
        return this.ismIndices;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Inject
    public TransportIndexPolicyAction(@NotNull NodeClient client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull IndexManagementIndices ismIndices, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)transportService, (String)"transportService");
        Intrinsics.checkParameterIsNotNull((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkParameterIsNotNull((Object)ismIndices, (String)"ismIndices");
        Intrinsics.checkParameterIsNotNull((Object)xContentRegistry, (String)"xContentRegistry");
        String string = IndexPolicyAction.Companion.getNAME();
        Object object = 1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new TransportIndexPolicyActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0(function1);
        }
        super(string, transportService, actionFilters, (Writeable.Reader)object);
        this.client = client;
        this.ismIndices = ismIndices;
        this.xContentRegistry = xContentRegistry;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u000fH\u0002J\u0006\u0010\u0017\u001a\u00020\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/TransportIndexPolicyAction$IndexPolicyHandler;", "", "client", "Lorg/elasticsearch/client/node/NodeClient;", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/IndexPolicyResponse;", "request", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/IndexPolicyRequest;", "(Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/TransportIndexPolicyAction;Lorg/elasticsearch/client/node/NodeClient;Lorg/elasticsearch/action/ActionListener;Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/IndexPolicyRequest;)V", "checkShardsFailure", "", "response", "Lorg/elasticsearch/action/index/IndexResponse;", "checkTemplate", "", "indexPatterns", "", "priority", "", "onCreateMappingsResponse", "Lorg/elasticsearch/action/support/master/AcknowledgedResponse;", "putPolicy", "start", "opendistro-index-management"})
    public final class IndexPolicyHandler {
        private final NodeClient client;
        private final ActionListener<IndexPolicyResponse> actionListener;
        private final IndexPolicyRequest request;

        public final void start() {
            TransportIndexPolicyAction.this.getIsmIndices().checkAndUpdateIMConfigIndex((ActionListener<AcknowledgedResponse>)((ActionListener)new ActionListener<AcknowledgedResponse>(this){
                final /* synthetic */ IndexPolicyHandler this$0;

                public void onResponse(@NotNull AcknowledgedResponse response2) {
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    IndexPolicyHandler.access$onCreateMappingsResponse(this.this$0, response2);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    if (throwable == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Exception /* = java.lang.Exception */");
                    }
                    IndexPolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)throwable);
                }
                {
                    this.this$0 = $outer;
                }
            }));
        }

        private final void onCreateMappingsResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexPolicyActionKt.access$getLog$p().info("Successfully created or updated .opendistro-ism-config with newest mappings.");
                ISMTemplate reqTemplate = this.request.getPolicy().getIsmTemplate();
                if (reqTemplate != null) {
                    this.checkTemplate(reqTemplate.getIndexPatterns(), reqTemplate.getPriority());
                } else {
                    this.putPolicy();
                }
            } else {
                TransportIndexPolicyActionKt.access$getLog$p().error("Unable to create or update .opendistro-ism-config with newest mapping.");
                this.actionListener.onFailure((Exception)new ElasticsearchStatusException("Unable to create or update .opendistro-ism-config with newest mapping.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }

        private final void checkTemplate(List<String> indexPatterns, int priority) {
            ElasticsearchException possibleEx = ISMTemplateServiceKt.validateFormat(indexPatterns);
            if (possibleEx != null) {
                this.actionListener.onFailure((Exception)((Object)possibleEx));
                return;
            }
            SearchRequest searchRequest = new SearchRequest().source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.existsQuery((String)"policy.ism_template"))).indices(new String[]{".opendistro-ism-config"});
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this, indexPatterns, priority){
                final /* synthetic */ IndexPolicyHandler this$0;
                final /* synthetic */ List $indexPatterns;
                final /* synthetic */ int $priority;

                public void onResponse(@NotNull SearchResponse response2) {
                    Map<String, List<String>> conflictingPolicyTemplates;
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    Map<String, ISMTemplate> policyToTemplateMap = ElasticExtensionsKt.filterNotNullValues(ElasticExtensionsKt.getPolicyToTemplateMap(response2, this.this$0.TransportIndexPolicyAction.this.getXContentRegistry()));
                    Map<String, List<String>> map = conflictingPolicyTemplates = ISMTemplateServiceKt.findConflictingPolicyTemplates(policyToTemplateMap, IndexPolicyHandler.access$getRequest$p(this.this$0).getPolicyID(), this.$indexPatterns, this.$priority);
                    boolean bl = false;
                    if (!map.isEmpty()) {
                        String errorMessage = "New policy " + IndexPolicyHandler.access$getRequest$p(this.this$0).getPolicyID() + " has an ISM template with index pattern " + this.$indexPatterns + ' ' + "matching existing policy templates," + " please use a different priority than " + this.$priority;
                        IndexPolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)((Object)IndexManagementException.Companion.wrap(new IllegalArgumentException(errorMessage))));
                        return;
                    }
                    IndexPolicyHandler.access$putPolicy(this.this$0);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    if (throwable == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Exception /* = java.lang.Exception */");
                    }
                    IndexPolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)throwable);
                }
                {
                    this.this$0 = $outer;
                    this.$indexPatterns = $captured_local_variable$1;
                    this.$priority = $captured_local_variable$2;
                }
            });
        }

        private final void putPolicy() {
            Policy.copy$default(this.request.getPolicy(), null, 0L, 0L, null, IndexUtils.Companion.getIndexManagementConfigSchemaVersion(), null, null, null, null, null, 1007, null);
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opendistro-ism-config").setRefreshPolicy(this.request.getRefreshPolicy());
            Policy policy2 = this.request.getPolicy();
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"XContentFactory.jsonBuilder()");
            IndexRequest indexRequest2 = (IndexRequest)indexRequest.source(policy2.toXContent(xContentBuilder)).id(this.request.getPolicyID()).timeout(IndexRequest.DEFAULT_TIMEOUT);
            if (this.request.getSeqNo() == -2L || this.request.getPrimaryTerm() == 0L) {
                indexRequest2.opType(DocWriteRequest.OpType.CREATE);
            } else {
                indexRequest2.setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm());
            }
            this.client.index(indexRequest2, (ActionListener)new ActionListener<IndexResponse>(this){
                final /* synthetic */ IndexPolicyHandler this$0;

                public void onResponse(@NotNull IndexResponse response2) {
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    String failureReasons2 = IndexPolicyHandler.access$checkShardsFailure(this.this$0, response2);
                    if (failureReasons2 != null) {
                        IndexPolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)new ElasticsearchStatusException(failureReasons2.toString(), response2.status(), new Object[0]));
                        return;
                    }
                    ActionListener actionListener = IndexPolicyHandler.access$getActionListener$p(this.this$0);
                    String string = response2.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.id");
                    long l = response2.getVersion();
                    long l2 = response2.getPrimaryTerm();
                    long l3 = response2.getSeqNo();
                    Policy policy2 = IndexPolicyHandler.access$getRequest$p(this.this$0).getPolicy();
                    RestStatus restStatus = response2.status();
                    Intrinsics.checkExpressionValueIsNotNull((Object)restStatus, (String)"response.status()");
                    actionListener.onResponse((Object)((Object)new IndexPolicyResponse(string, l, l2, l3, policy2, restStatus)));
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    if (throwable == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Exception /* = java.lang.Exception */");
                    }
                    IndexPolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)throwable);
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        private final String checkShardsFailure(IndexResponse response2) {
            StringBuilder failureReasons2 = new StringBuilder();
            ReplicationResponse.ShardInfo shardInfo = response2.getShardInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)shardInfo, (String)"response.shardInfo");
            if (shardInfo.getFailed() > 0) {
                ReplicationResponse.ShardInfo shardInfo2 = response2.getShardInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)shardInfo2, (String)"response.shardInfo");
                ReplicationResponse.ShardInfo.Failure[] failureArray = shardInfo2.getFailures();
                Intrinsics.checkExpressionValueIsNotNull((Object)failureArray, (String)"response.shardInfo.failures");
                ReplicationResponse.ShardInfo.Failure[] $this$forEach$iv = failureArray;
                boolean $i$f$forEach = false;
                ReplicationResponse.ShardInfo.Failure[] failureArray2 = $this$forEach$iv;
                int n = failureArray2.length;
                for (int j = 0; j < n; ++j) {
                    ReplicationResponse.ShardInfo.Failure element$iv;
                    ReplicationResponse.ShardInfo.Failure entry = element$iv = failureArray2[j];
                    boolean bl = false;
                    failureReasons2.append(entry.reason());
                }
                return failureReasons2.toString();
            }
            return null;
        }

        public IndexPolicyHandler(@NotNull NodeClient client, @NotNull ActionListener<IndexPolicyResponse> actionListener, IndexPolicyRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
            Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
        }

        public static final /* synthetic */ void access$onCreateMappingsResponse(IndexPolicyHandler $this, AcknowledgedResponse response2) {
            $this.onCreateMappingsResponse(response2);
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexPolicyHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ IndexPolicyRequest access$getRequest$p(IndexPolicyHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ void access$putPolicy(IndexPolicyHandler $this) {
            $this.putPolicy();
        }

        public static final /* synthetic */ String access$checkShardsFailure(IndexPolicyHandler $this, IndexResponse response2) {
            return $this.checkShardsFailure(response2);
        }
    }
}

