/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.step.forcemerge;

import com.amazon.opendistroforelasticsearch.indexmanagement.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.ManagedIndexMetaData;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.action.ForceMergeActionConfig;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.managedindexmetadata.ActionMetaData;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.managedindexmetadata.ActionProperties;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.managedindexmetadata.PolicyRetryInfoMetaData;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.managedindexmetadata.StateMetaData;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.managedindexmetadata.StepMetaData;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.step.Step;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.step.forcemerge.WaitForForceMergeStep;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.rest.RestStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u001a\u001a\u00020\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010 J#\u0010!\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u001fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\tH\u0016J\b\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006*"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/step/forcemerge/WaitForForceMergeStep;", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/step/Step;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "client", "Lorg/elasticsearch/client/Client;", "config", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/action/ForceMergeActionConfig;", "managedIndexMetaData", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/ManagedIndexMetaData;", "(Lorg/elasticsearch/cluster/service/ClusterService;Lorg/elasticsearch/client/Client;Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/action/ForceMergeActionConfig;Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/ManagedIndexMetaData;)V", "getClient", "()Lorg/elasticsearch/client/Client;", "getClusterService", "()Lorg/elasticsearch/cluster/service/ClusterService;", "getConfig", "()Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/action/ForceMergeActionConfig;", "info", "", "", "", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/step/Step$StepStatus;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getActionStartTime", "Ljava/time/Instant;", "getMaxNumSegments", "", "()Ljava/lang/Integer;", "getShardsStillMergingSegments", "indexName", "maxNumSegments", "(Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUpdatedManagedIndexMetaData", "currentMetaData", "isIdempotent", "", "Companion", "opendistro-index-management"})
public final class WaitForForceMergeStep
extends Step {
    private final Logger logger;
    private Step.StepStatus stepStatus;
    private Map<String, ? extends Object> info;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Client client;
    @NotNull
    private final ForceMergeActionConfig config;
    @NotNull
    public static final String name = "wait_for_force_merge";
    public static final long FORCE_MERGE_TIMEOUT_IN_SECONDS = 43200L;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isIdempotent() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super WaitForForceMergeStep> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ WaitForForceMergeStep this$0;
                Object L$0;
                int I$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((Continuation<? super WaitForForceMergeStep>)this);
                }
                {
                    this.this$0 = waitForForceMergeStep;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getMaxNumSegments();
                if (v0 == null) {
                    return this;
                }
                maxNumSegments = v0;
                $continuation.L$0 = this;
                $continuation.I$0 = maxNumSegments;
                $continuation.label = 1;
                v1 = this.getShardsStillMergingSegments(this.getIndexName(), maxNumSegments, (Continuation<? super Integer>)$continuation);
                if (v1 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                maxNumSegments = $continuation.I$0;
                this = (WaitForForceMergeStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                v2 = shardsStillMergingSegments = (Integer)v1;
                if (v2 == null) {
                    return this;
                }
                v2.intValue();
                if (shardsStillMergingSegments == 0) {
                    message = WaitForForceMergeStep.Companion.getSuccessMessage(this.getIndexName());
                    this.logger.info(message);
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
                } else {
                    v3 = Duration.between(this.getActionStartTime(), Instant.now());
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"Duration.between(getActi\u2026artTime(), Instant.now())");
                    timeWaitingForForceMerge = v3;
                    v4 = this.config.getConfigTimeout();
                    v5 = v4 != null && (v4 = v4.getTimeout()) != null && (v4 = Boxing.boxLong((long)v4.getSeconds())) != null ? v4.longValue() : (timeoutInSeconds = 43200L);
                    if (timeWaitingForForceMerge.toSeconds() > timeoutInSeconds) {
                        this.logger.error("Force merge on [" + this.getIndexName() + "] timed out with" + " [" + shardsStillMergingSegments + "] shards containing unmerged segments");
                        this.stepStatus = Step.StepStatus.FAILED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForForceMergeStep.Companion.getFailedTimedOutMessage(this.getIndexName())));
                    } else {
                        this.logger.debug("Force merge still running on [" + this.getIndexName() + "] with" + " [" + shardsStillMergingSegments + "] shards containing unmerged segments");
                        this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForForceMergeStep.Companion.getWaitingMessage(this.getIndexName())));
                    }
                }
                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Integer getMaxNumSegments() {
        ActionProperties actionProperties2;
        ActionMetaData actionMetaData = this.getManagedIndexMetaData().getActionMetaData();
        ActionProperties actionProperties3 = actionProperties2 = actionMetaData != null ? actionMetaData.getActionProperties() : null;
        if ((actionProperties3 != null ? actionProperties3.getMaxNumSegments() : null) == null) {
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)("Unable to retrieve [" + ActionProperties.Properties.MAX_NUM_SEGMENTS.getKey() + ']' + " from ActionProperties=" + actionProperties2)));
            return null;
        }
        return actionProperties2.getMaxNumSegments();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    final /* synthetic */ Object getShardsStillMergingSegments(@NotNull String indexName, int maxNumSegments, @NotNull Continuation<? super Integer> $completion) {
        if (!($completion instanceof getShardsStillMergingSegments.1)) ** GOTO lbl-1000
        var26_4 = $completion;
        if ((var26_4.label & -2147483648) != 0) {
            var26_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ WaitForForceMergeStep this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getShardsStillMergingSegments(null, 0, (Continuation<? super Integer>)this);
                }
                {
                    this.this$0 = waitForForceMergeStep;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var27_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                statsRequest = (IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{indexName});
                $continuation.L$0 = this;
                $continuation.L$1 = indexName;
                $continuation.I$0 = maxNumSegments;
                $continuation.L$2 = statsRequest;
                $continuation.label = 1;
                v0 = ElasticExtensionsKt.suspendUntil((ElasticsearchClient)this.client.admin().indices(), (Function2)new Function2<IndicesAdminClient, ActionListener<IndicesStatsResponse>, Unit>(statsRequest){
                    final /* synthetic */ IndicesStatsRequest $statsRequest;

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<IndicesStatsResponse> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        $this$suspendUntil.stats(this.$statsRequest, it);
                    }
                    {
                        this.$statsRequest = indicesStatsRequest;
                        super(2);
                    }
                }, $continuation);
                ** if (v0 != var27_6) goto lbl23
lbl22:
                // 1 sources

                return var27_6;
lbl23:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                statsRequest = (IndicesStatsRequest)$continuation.L$2;
                maxNumSegments = $continuation.I$0;
                indexName = (String)$continuation.L$1;
                this = (WaitForForceMergeStep)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    if ((statsResponse = (IndicesStatsResponse)v0).getStatus() == RestStatus.OK) {
                        v1 = statsResponse.getShards();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"statsResponse.shards");
                        $this$count$iv = v1;
                        $i$f$count = false;
                        count$iv = 0;
                        var9_19 = $this$count$iv;
                        var10_21 = var9_19.length;
                        for (var11_23 = 0; var11_23 < var10_21; ++var11_23) {
                            it = element$iv = var9_19[var11_23];
                            $i$a$-count-WaitForForceMergeStep$getShardsStillMergingSegments$2 = false;
                            v2 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                            v3 = v2.getStats().segments;
                            v4 = count = v3 != null ? Boxing.boxLong((long)v3.getCount()) : null;
                            if (count == null) {
                                this.logger.warn(indexName + " wait for force merge had null segments");
                                v5 = false;
                            } else {
                                v5 = count > (long)maxNumSegments;
                            }
                            if (!Boxing.boxBoolean((boolean)v5).booleanValue()) continue;
                            ++count$iv;
                        }
                        return Boxing.boxInt((int)count$iv);
                    }
                    message = WaitForForceMergeStep.Companion.getFailedSegmentCheckMessage(indexName);
                    this.logger.warn(message + " - " + statsResponse.getStatus());
                    this.stepStatus = Step.StepStatus.FAILED;
                    v6 = new Pair[2];
                    v6[0] = TuplesKt.to((Object)"message", (Object)message);
                    v7 = statsResponse.getShardFailures();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"statsResponse.shardFailures");
                    $i$f$count = v7;
                    var22_33 = "shard_failures";
                    var21_34 = 1;
                    var20_35 = v6;
                    var19_36 = v6;
                    var18_37 = this;
                    $i$f$map = false;
                    var9_20 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                    $i$f$mapTo = false;
                    var12_26 = $this$mapTo$iv$iv;
                    var13_28 = ((void)var12_26).length;
                    for (var14_30 = 0; var14_30 < var13_28; ++var14_30) {
                        var16_38 = item$iv$iv = var12_26[var14_30];
                        var23_40 = destination$iv$iv;
                        $i$a$-map-WaitForForceMergeStep$getShardsStillMergingSegments$3 = false;
                        v8 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it");
                        var24_41 = ElasticExtensionsKt.getUsefulCauseString((DefaultShardOperationFailedException)v8);
                        var23_40.add(var24_41);
                    }
                    var23_40 = (List)destination$iv$iv;
                    var20_35[var21_34] = TuplesKt.to((Object)var22_33, (Object)var23_40);
                    var18_37.info = MapsKt.mapOf((Pair[])var19_36);
                }
                catch (Exception e) {
                    message = WaitForForceMergeStep.Companion.getFailedSegmentCheckMessage(indexName);
                    this.logger.error(message, (Throwable)e);
                    this.stepStatus = Step.StepStatus.FAILED;
                    mutableInfo = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"message", (Object)message)});
                    errorMessage = e.getMessage();
                    if (errorMessage != null) {
                        mutableInfo.put("cause", errorMessage);
                    }
                    this.info = MapsKt.toMap((Map)mutableInfo);
                }
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Instant getActionStartTime() {
        ActionMetaData actionMetaData = this.getManagedIndexMetaData().getActionMetaData();
        if ((actionMetaData != null ? actionMetaData.getStartTime() : null) == null) {
            Instant instant = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
            return instant;
        }
        Instant instant = Instant.ofEpochMilli(this.getManagedIndexMetaData().getActionMetaData().getStartTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.ofEpochMilli(man\u2026actionMetaData.startTime)");
        return instant;
    }

    @Override
    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetaData(@NotNull ManagedIndexMetaData currentMetaData) {
        ActionMetaData actionMetaData;
        Object object;
        ActionMetaData currentActionMetaData;
        Intrinsics.checkParameterIsNotNull((Object)currentMetaData, (String)"currentMetaData");
        ActionMetaData actionMetaData2 = currentActionMetaData = currentMetaData.getActionMetaData();
        if (actionMetaData2 != null) {
            object = actionMetaData2;
            boolean bl = false;
            boolean bl2 = false;
            ActionMetaData it = object;
            boolean bl3 = false;
            actionMetaData = this.stepStatus != Step.StepStatus.COMPLETED ? it : ActionMetaData.copy$default(currentActionMetaData, null, null, 0, false, 0, null, null, 63, null);
        } else {
            actionMetaData = null;
        }
        ActionMetaData updatedActionMetaData = actionMetaData;
        object = this.info;
        PolicyRetryInfoMetaData policyRetryInfoMetaData = null;
        String string = null;
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime().toEpochMilli(), this.stepStatus);
        StateMetaData stateMetaData = null;
        ActionMetaData actionMetaData3 = updatedActionMetaData;
        return ManagedIndexMetaData.copy$default(currentMetaData, null, null, null, null, null, null, null, string, stateMetaData, actionMetaData3, stepMetaData, policyRetryInfoMetaData, (Map)object, 2431, null);
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ForceMergeActionConfig getConfig() {
        return this.config;
    }

    public WaitForForceMergeStep(@NotNull ClusterService clusterService, @NotNull Client client, @NotNull ForceMergeActionConfig config, @NotNull ManagedIndexMetaData managedIndexMetaData) {
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)managedIndexMetaData, (String)"managedIndexMetaData");
        super(name, managedIndexMetaData, false);
        this.clusterService = clusterService;
        this.client = client;
        this.config = config;
        this.logger = LogManager.getLogger(this.getClass());
        this.stepStatus = Step.StepStatus.STARTING;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/step/forcemerge/WaitForForceMergeStep$Companion;", "", "()V", "FORCE_MERGE_TIMEOUT_IN_SECONDS", "", "name", "", "getFailedSegmentCheckMessage", "index", "getFailedTimedOutMessage", "getSuccessMessage", "getWaitingMessage", "opendistro-index-management"})
    public static final class Companion {
        @NotNull
        public final String getFailedTimedOutMessage(@NotNull String index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            return "Force merge timed out [index=" + index + ']';
        }

        @NotNull
        public final String getFailedSegmentCheckMessage(@NotNull String index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            return "Failed to check segments when waiting for force merge to complete [index=" + index + ']';
        }

        @NotNull
        public final String getWaitingMessage(@NotNull String index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            return "Waiting for force merge to complete [index=" + index + ']';
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            return "Successfully confirmed segments force merged [index=" + index + ']';
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

