/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.step;

import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.ManagedIndexMetaData;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.managedindexmetadata.StepMetaData;
import java.time.Instant;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0010\u001a\u00020\u0000H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H&J\b\u0010\u0018\u001a\u00020\u0007H&J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\t\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/step/Step;", "", "name", "", "managedIndexMetaData", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/ManagedIndexMetaData;", "isSafeToDisableOn", "", "(Ljava/lang/String;Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/ManagedIndexMetaData;Z)V", "indexName", "getIndexName", "()Ljava/lang/String;", "()Z", "getManagedIndexMetaData", "()Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/ManagedIndexMetaData;", "getName", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getStartingStepMetaData", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/managedindexmetadata/StepMetaData;", "getStepStartTime", "Ljava/time/Instant;", "getUpdatedManagedIndexMetaData", "currentMetaData", "isIdempotent", "postExecute", "logger", "Lorg/apache/logging/log4j/Logger;", "preExecute", "StepStatus", "opendistro-index-management"})
public abstract class Step {
    @NotNull
    private final String indexName;
    @NotNull
    private final String name;
    @NotNull
    private final ManagedIndexMetaData managedIndexMetaData;
    private final boolean isSafeToDisableOn;

    @NotNull
    public final Step preExecute(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        logger.info("Executing " + this.name + " for " + this.managedIndexMetaData.getIndex());
        return this;
    }

    @Nullable
    public abstract Object execute(@NotNull Continuation<? super Step> var1);

    @NotNull
    public final Step postExecute(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        logger.info("Finished executing " + this.name + " for " + this.managedIndexMetaData.getIndex());
        return this;
    }

    @NotNull
    public abstract ManagedIndexMetaData getUpdatedManagedIndexMetaData(@NotNull ManagedIndexMetaData var1);

    public abstract boolean isIdempotent();

    @NotNull
    public final StepMetaData getStartingStepMetaData() {
        return new StepMetaData(this.name, this.getStepStartTime().toEpochMilli(), StepStatus.STARTING);
    }

    @NotNull
    public final Instant getStepStartTime() {
        Instant instant;
        if (this.managedIndexMetaData.getStepMetaData() == null) {
            Instant instant2 = Instant.now();
            instant = instant2;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"Instant.now()");
        } else if (Intrinsics.areEqual((Object)this.managedIndexMetaData.getStepMetaData().getName(), (Object)this.name) ^ true) {
            Instant instant3 = Instant.now();
            instant = instant3;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant3, (String)"Instant.now()");
        } else if (this.managedIndexMetaData.getStepMetaData().getStepStatus() == StepStatus.COMPLETED) {
            Instant instant4 = Instant.now();
            instant = instant4;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant4, (String)"Instant.now()");
        } else {
            Instant instant5 = Instant.ofEpochMilli(this.managedIndexMetaData.getStepMetaData().getStartTime());
            instant = instant5;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant5, (String)"Instant.ofEpochMilli(man\u2026a.stepMetaData.startTime)");
        }
        return instant;
    }

    @NotNull
    protected final String getIndexName() {
        return this.indexName;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final ManagedIndexMetaData getManagedIndexMetaData() {
        return this.managedIndexMetaData;
    }

    public final boolean isSafeToDisableOn() {
        return this.isSafeToDisableOn;
    }

    public Step(@NotNull String name, @NotNull ManagedIndexMetaData managedIndexMetaData, boolean isSafeToDisableOn) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)managedIndexMetaData, (String)"managedIndexMetaData");
        this.name = name;
        this.managedIndexMetaData = managedIndexMetaData;
        this.isSafeToDisableOn = isSafeToDisableOn;
        this.indexName = this.managedIndexMetaData.getIndex();
    }

    public /* synthetic */ Step(String string, ManagedIndexMetaData managedIndexMetaData, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(string, managedIndexMetaData, bl);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0001\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0011B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0012"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/step/Step$StepStatus;", "", "Lorg/elasticsearch/common/io/stream/Writeable;", "status", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getStatus", "()Ljava/lang/String;", "toString", "writeTo", "", "out", "Lorg/elasticsearch/common/io/stream/StreamOutput;", "STARTING", "CONDITION_NOT_MET", "FAILED", "COMPLETED", "Companion", "opendistro-index-management"})
    public static final class StepStatus
    extends Enum<StepStatus>
    implements Writeable {
        public static final /* enum */ StepStatus STARTING;
        public static final /* enum */ StepStatus CONDITION_NOT_MET;
        public static final /* enum */ StepStatus FAILED;
        public static final /* enum */ StepStatus COMPLETED;
        private static final /* synthetic */ StepStatus[] $VALUES;
        @NotNull
        private final String status;
        public static final Companion Companion;

        static {
            StepStatus[] stepStatusArray = new StepStatus[4];
            StepStatus[] stepStatusArray2 = stepStatusArray;
            stepStatusArray[0] = STARTING = new StepStatus("starting");
            stepStatusArray[1] = CONDITION_NOT_MET = new StepStatus("condition_not_met");
            stepStatusArray[2] = FAILED = new StepStatus("failed");
            stepStatusArray[3] = COMPLETED = new StepStatus("completed");
            $VALUES = stepStatusArray;
            Companion = new Companion(null);
        }

        @NotNull
        public String toString() {
            return this.status;
        }

        public void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            out.writeString(this.status);
        }

        @NotNull
        public final String getStatus() {
            return this.status;
        }

        private StepStatus(String status) {
            this.status = status;
        }

        public static StepStatus[] values() {
            return (StepStatus[])$VALUES.clone();
        }

        public static StepStatus valueOf(String string) {
            return Enum.valueOf(StepStatus.class, string);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/step/Step$StepStatus$Companion;", "", "()V", "read", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/step/Step$StepStatus;", "streamInput", "Lorg/elasticsearch/common/io/stream/StreamInput;", "opendistro-index-management"})
        public static final class Companion {
            @NotNull
            public final StepStatus read(@NotNull StreamInput streamInput) {
                Intrinsics.checkParameterIsNotNull((Object)streamInput, (String)"streamInput");
                String string = streamInput.readString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"streamInput.readString()");
                String string2 = string;
                Locale locale = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toUpperCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase(locale)");
                return StepStatus.valueOf(string4);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

