/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.resthandler;

import com.amazon.opendistroforelasticsearch.indexmanagement.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.Policy;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyAction;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyRequest;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyResponse;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestResponseListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\bH\u0016R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t \n*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/resthandler/RestIndexPolicyAction;", "Lorg/elasticsearch/rest/BaseRestHandler;", "settings", "Lorg/elasticsearch/common/settings/Settings;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "(Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/cluster/service/ClusterService;)V", "allowList", "", "", "kotlin.jvm.PlatformType", "getClusterService", "()Lorg/elasticsearch/cluster/service/ClusterService;", "getName", "prepareRequest", "Lorg/elasticsearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/elasticsearch/rest/RestRequest;", "client", "Lorg/elasticsearch/client/node/NodeClient;", "routes", "Lorg/elasticsearch/rest/RestHandler$Route;", "opendistro-index-management"})
public final class RestIndexPolicyAction
extends BaseRestHandler {
    private volatile List<String> allowList;
    @NotNull
    private final ClusterService clusterService;

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object[])new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.PUT, "/_opendistro/_ism/policies"), new RestHandler.Route(RestRequest.Method.PUT, "/_opendistro/_ism/policies/{policyID}")});
    }

    @NotNull
    public String getName() {
        return "index_policy_action";
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        XContentParser xcp;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        String id = request.param("policyID", "");
        if (Intrinsics.areEqual((Object)"", (Object)id)) {
            throw (Throwable)new IllegalArgumentException("Missing policy ID");
        }
        XContentParser xContentParser = xcp = request.contentParser();
        Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"xcp");
        String string = id;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
        Policy policy2 = (Policy)ElasticExtensionsKt.parseWithType$default(xContentParser, string, 0L, 0L, (Function4)new Function4<XContentParser, String, Long, Long, Policy>(Policy.Companion){

            @NotNull
            public final Policy invoke(@NotNull XContentParser p1, @NotNull String p2, long p3, long p4) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return ((Policy.Companion)this.receiver).parse(p1, p2, p3, p4);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Policy.Companion.class);
            }

            public final String getName() {
                return "parse";
            }

            public final String getSignature() {
                return "parse(Lorg/elasticsearch/common/xcontent/XContentParser;Ljava/lang/String;JJ)Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/Policy;";
            }
        }, 6, null);
        Instant instant = Instant.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
        Policy policy3 = Policy.copy$default(policy2, null, 0L, 0L, null, 0L, instant, null, null, null, null, 991, null);
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        List<String> list = this.allowList;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"allowList");
        List<String> disallowedActions = ManagedIndexUtils.getDisallowedActions(policy3, list);
        Collection collection = disallowedActions;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return new BaseRestHandler.RestChannelConsumer(disallowedActions){
                final /* synthetic */ List $disallowedActions;

                public final void accept(RestChannel channel) {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "You have actions that are not allowed in your policy " + this.$disallowedActions));
                }
                {
                    this.$disallowedActions = list;
                }
            };
        }
        WriteRequest.RefreshPolicy refreshPolicy2 = refreshPolicy;
        Intrinsics.checkExpressionValueIsNotNull((Object)refreshPolicy2, (String)"refreshPolicy");
        IndexPolicyRequest indexPolicyRequest = new IndexPolicyRequest(id, policy3, seqNo, primaryTerm, refreshPolicy2);
        return new BaseRestHandler.RestChannelConsumer(client, indexPolicyRequest){
            final /* synthetic */ NodeClient $client;
            final /* synthetic */ IndexPolicyRequest $indexPolicyRequest;

            public final void accept(RestChannel channel) {
                this.$client.execute((ActionType)IndexPolicyAction.Companion.getINSTANCE(), (ActionRequest)this.$indexPolicyRequest, (ActionListener)new RestResponseListener<IndexPolicyResponse>(channel, channel){
                    final /* synthetic */ RestChannel $channel;

                    @NotNull
                    public RestResponse buildResponse(@NotNull IndexPolicyResponse response2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)response2), (String)"response");
                        RestStatus restStatus = response2.getStatus();
                        XContentBuilder xContentBuilder = this.$channel.newBuilder();
                        Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"channel.newBuilder()");
                        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                        Intrinsics.checkExpressionValueIsNotNull((Object)params, (String)"ToXContent.EMPTY_PARAMS");
                        BytesRestResponse restResponse = new BytesRestResponse(restStatus, response2.toXContent(xContentBuilder, params));
                        if (response2.getStatus() == RestStatus.CREATED) {
                            String location = "/_opendistro/_ism/policies/" + response2.getId();
                            restResponse.addHeader("Location", location);
                        }
                        return (RestResponse)restResponse;
                    }
                    {
                        this.$channel = $captured_local_variable$0;
                        super($super_call_param$1);
                    }
                });
            }
            {
                this.$client = nodeClient;
                this.$indexPolicyRequest = indexPolicyRequest;
            }
        };
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    public RestIndexPolicyAction(@NotNull Settings settings, @NotNull ClusterService clusterService) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        this.clusterService = clusterService;
        this.allowList = (List)ManagedIndexSettings.Companion.getALLOW_LIST().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getALLOW_LIST(), (Consumer)new Consumer<List<? extends String>>(){

            @Override
            public final void accept(List<String> it) {
                allowList = it;
            }
        });
    }

    public static final /* synthetic */ List access$getAllowList$p(RestIndexPolicyAction $this) {
        return $this.allowList;
    }
}

