/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.destination;

import com.amazon.opendistroforelasticsearch.alerting.destination.Notification;
import com.amazon.opendistroforelasticsearch.alerting.destination.message.BaseMessage;
import com.amazon.opendistroforelasticsearch.alerting.destination.message.ChimeMessage;
import com.amazon.opendistroforelasticsearch.alerting.destination.message.CustomWebhookMessage;
import com.amazon.opendistroforelasticsearch.alerting.destination.message.SlackMessage;
import com.amazon.opendistroforelasticsearch.alerting.destination.response.BaseResponse;
import com.amazon.opendistroforelasticsearch.alerting.destination.response.DestinationResponse;
import com.amazon.opendistroforelasticsearch.indexmanagement.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.destination.Chime;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.destination.CustomWebhook;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.destination.Destination$WhenMappings;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.destination.Destination$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.destination.DestinationType;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.destination.Slack;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B+\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007J7\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J&\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020&0)J\t\u0010*\u001a\u00020&H\u00d6\u0001J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0016J\u001e\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\f\u0010(\u001a\b\u0012\u0004\u0012\u00020&0)H\u0002J\u0010\u00104\u001a\u0002012\u0006\u00105\u001a\u000206H\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00068"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/Destination;", "Lorg/elasticsearch/common/xcontent/ToXContentObject;", "Lorg/elasticsearch/common/io/stream/Writeable;", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "(Lorg/elasticsearch/common/io/stream/StreamInput;)V", "type", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/DestinationType;", "chime", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/Chime;", "slack", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/Slack;", "customWebhook", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/CustomWebhook;", "(Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/DestinationType;Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/Chime;Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/Slack;Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/CustomWebhook;)V", "getChime", "()Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/Chime;", "getCustomWebhook", "()Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/CustomWebhook;", "getSlack", "()Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/Slack;", "getType", "()Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/DestinationType;", "component1", "component2", "component3", "component4", "constructResponseForDestinationType", "", "copy", "equals", "", "other", "hashCode", "", "publish", "Lcom/amazon/opendistroforelasticsearch/alerting/destination/response/DestinationResponse;", "compiledSubject", "", "compiledMessage", "denyHostRanges", "", "toString", "toXContent", "Lorg/elasticsearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/elasticsearch/common/xcontent/ToXContent$Params;", "validateDestinationUri", "", "destinationMessage", "Lcom/amazon/opendistroforelasticsearch/alerting/destination/message/BaseMessage;", "writeTo", "out", "Lorg/elasticsearch/common/io/stream/StreamOutput;", "Companion", "opendistro-index-management"})
public final class Destination
implements ToXContentObject,
Writeable {
    @NotNull
    private final DestinationType type;
    @Nullable
    private final Chime chime;
    @Nullable
    private final Slack slack;
    @Nullable
    private final CustomWebhook customWebhook;
    @NotNull
    public static final String CHIME = "chime";
    @NotNull
    public static final String SLACK = "slack";
    @NotNull
    public static final String CUSTOMWEBHOOK = "custom_webhook";
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        builder.startObject().field(this.type.getValue(), this.constructResponseForDestinationType(this.type)).endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        out.writeEnum((Enum)this.type);
        out.writeOptionalWriteable((Writeable)this.chime);
        out.writeOptionalWriteable((Writeable)this.slack);
        out.writeOptionalWriteable((Writeable)this.customWebhook);
    }

    @NotNull
    public final DestinationResponse publish(@Nullable String compiledSubject, @NotNull String compiledMessage, @NotNull List<String> denyHostRanges) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)compiledMessage, (String)"compiledMessage");
        Intrinsics.checkParameterIsNotNull(denyHostRanges, (String)"denyHostRanges");
        BaseMessage destinationMessage = null;
        switch (Destination$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                Chime chime = this.chime;
                String messageContent = chime != null ? chime.constructMessageContent(compiledSubject, compiledMessage) : null;
                Chime chime2 = this.chime;
                ChimeMessage chimeMessage = new ChimeMessage.Builder("chime_message").withUrl(chime2 != null ? chime2.getUrl() : null).withMessage(messageContent).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)chimeMessage, (String)"ChimeMessage.Builder(\"ch\u2026                 .build()");
                destinationMessage = (BaseMessage)chimeMessage;
                break;
            }
            case 2: {
                Slack slack = this.slack;
                String messageContent = slack != null ? slack.constructMessageContent(compiledSubject, compiledMessage) : null;
                Slack slack2 = this.slack;
                SlackMessage slackMessage = new SlackMessage.Builder("slack_message").withUrl(slack2 != null ? slack2.getUrl() : null).withMessage(messageContent).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)slackMessage, (String)"SlackMessage.Builder(\"sl\u2026                 .build()");
                destinationMessage = (BaseMessage)slackMessage;
                break;
            }
            case 3: {
                CustomWebhook customWebhook = this.customWebhook;
                CustomWebhook customWebhook2 = this.customWebhook;
                CustomWebhook customWebhook3 = this.customWebhook;
                CustomWebhook customWebhook4 = this.customWebhook;
                CustomWebhook customWebhook5 = this.customWebhook;
                CustomWebhook customWebhook6 = this.customWebhook;
                CustomWebhook customWebhook7 = this.customWebhook;
                CustomWebhookMessage customWebhookMessage = new CustomWebhookMessage.Builder(CUSTOMWEBHOOK).withUrl(customWebhook != null ? customWebhook.getUrl() : null).withScheme(customWebhook2 != null ? customWebhook2.getScheme() : null).withHost(customWebhook3 != null ? customWebhook3.getHost() : null).withPort(customWebhook4 != null ? Integer.valueOf(customWebhook4.getPort()) : null).withPath(customWebhook5 != null ? customWebhook5.getPath() : null).withQueryParams(customWebhook6 != null ? customWebhook6.getQueryParams() : null).withHeaderParams(customWebhook7 != null ? customWebhook7.getHeaderParams() : null).withMessage(compiledMessage).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)customWebhookMessage, (String)"CustomWebhookMessage.Bui\u2026(compiledMessage).build()");
                destinationMessage = (BaseMessage)customWebhookMessage;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.validateDestinationUri(destinationMessage, denyHostRanges);
        BaseResponse baseResponse = Notification.publish((BaseMessage)destinationMessage);
        if (baseResponse == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.amazon.opendistroforelasticsearch.alerting.destination.response.DestinationResponse");
        }
        DestinationResponse response2 = (DestinationResponse)baseResponse;
        logger.info("Message published for action type: " + (Object)((Object)this.type) + ", messageid: " + response2.getResponseContent() + ", statuscode: " + response2.getStatusCode());
        return response2;
    }

    @NotNull
    public final Object constructResponseForDestinationType(@NotNull DestinationType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Object content = null;
        switch (Destination$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                Object object = this.chime;
                content = object != null && (object = ElasticExtensionsKt.convertToMap((ToXContent)object)) != null ? object.get(type.getValue()) : null;
                break;
            }
            case 2: {
                Object object = this.slack;
                content = object != null && (object = ElasticExtensionsKt.convertToMap((ToXContent)object)) != null ? object.get(type.getValue()) : null;
                break;
            }
            case 3: {
                Object object = this.customWebhook;
                content = object != null && (object = ElasticExtensionsKt.convertToMap((ToXContent)object)) != null ? object.get(type.getValue()) : null;
                break;
            }
        }
        if (content == null) {
            throw (Throwable)new IllegalArgumentException("Content is NULL for destination type " + type.getValue());
        }
        return content;
    }

    private final void validateDestinationUri(BaseMessage destinationMessage, List<String> denyHostRanges) {
        if (ManagedIndexUtils.isHostInDenylist(destinationMessage, denyHostRanges)) {
            throw (Throwable)new IllegalArgumentException("The destination address is invalid.");
        }
    }

    @NotNull
    public final DestinationType getType() {
        return this.type;
    }

    @Nullable
    public final Chime getChime() {
        return this.chime;
    }

    @Nullable
    public final Slack getSlack() {
        return this.slack;
    }

    @Nullable
    public final CustomWebhook getCustomWebhook() {
        return this.customWebhook;
    }

    public Destination(@NotNull DestinationType type, @Nullable Chime chime, @Nullable Slack slack, @Nullable CustomWebhook customWebhook) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        this.type = type;
        this.chime = chime;
        this.slack = slack;
        this.customWebhook = customWebhook;
    }

    public Destination(@NotNull StreamInput sin) throws IOException {
        Function1 function1;
        Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
        Enum enum_ = sin.readEnum(DestinationType.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)enum_, (String)"sin.readEnum(DestinationType::class.java)");
        DestinationType destinationType = (DestinationType)enum_;
        Object object = 1.INSTANCE;
        if (object != null) {
            function1 = object;
            object = new Destination$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0(function1);
        }
        Chime chime = (Chime)sin.readOptionalWriteable((Writeable.Reader)object);
        Object object2 = 2.INSTANCE;
        if (object2 != null) {
            function1 = object2;
            object2 = new Destination$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0(function1);
        }
        Slack slack = (Slack)sin.readOptionalWriteable((Writeable.Reader)object2);
        Object object3 = 3.INSTANCE;
        if (object3 != null) {
            function1 = object3;
            object3 = new Destination$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0(function1);
        }
        this(destinationType, chime, slack, (CustomWebhook)sin.readOptionalWriteable((Writeable.Reader)object3));
    }

    static {
        Companion = new Companion(null);
        logger = LogManager.getLogger(Destination.class);
    }

    @NotNull
    public final DestinationType component1() {
        return this.type;
    }

    @Nullable
    public final Chime component2() {
        return this.chime;
    }

    @Nullable
    public final Slack component3() {
        return this.slack;
    }

    @Nullable
    public final CustomWebhook component4() {
        return this.customWebhook;
    }

    @NotNull
    public final Destination copy(@NotNull DestinationType type, @Nullable Chime chime, @Nullable Slack slack, @Nullable CustomWebhook customWebhook) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return new Destination(type, chime, slack, customWebhook);
    }

    public static /* synthetic */ Destination copy$default(Destination destination, DestinationType destinationType, Chime chime, Slack slack, CustomWebhook customWebhook, int n, Object object) {
        if ((n & 1) != 0) {
            destinationType = destination.type;
        }
        if ((n & 2) != 0) {
            chime = destination.chime;
        }
        if ((n & 4) != 0) {
            slack = destination.slack;
        }
        if ((n & 8) != 0) {
            customWebhook = destination.customWebhook;
        }
        return destination.copy(destinationType, chime, slack, customWebhook);
    }

    @NotNull
    public String toString() {
        return "Destination(type=" + (Object)((Object)this.type) + ", chime=" + this.chime + ", slack=" + this.slack + ", customWebhook=" + this.customWebhook + ")";
    }

    public int hashCode() {
        DestinationType destinationType = this.type;
        Chime chime = this.chime;
        Slack slack = this.slack;
        CustomWebhook customWebhook = this.customWebhook;
        return (((destinationType != null ? ((Object)((Object)destinationType)).hashCode() : 0) * 31 + (chime != null ? ((Object)chime).hashCode() : 0)) * 31 + (slack != null ? ((Object)slack).hashCode() : 0)) * 31 + (customWebhook != null ? ((Object)customWebhook).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Destination)) break block3;
                Destination destination = (Destination)object;
                if (!Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)destination.type)) || !Intrinsics.areEqual((Object)this.chime, (Object)destination.chime) || !Intrinsics.areEqual((Object)this.slack, (Object)destination.slack) || !Intrinsics.areEqual((Object)this.customWebhook, (Object)destination.customWebhook)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Destination parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/Destination$Companion;", "", "()V", "CHIME", "", "CUSTOMWEBHOOK", "SLACK", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "parse", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/destination/Destination;", "xcp", "Lorg/elasticsearch/common/xcontent/XContentParser;", "opendistro-index-management"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @NotNull
        public final Destination parse(@NotNull XContentParser xcp) throws IOException {
            DestinationType destinationType;
            Intrinsics.checkParameterIsNotNull((Object)xcp, (String)"xcp");
            Slack slack = null;
            Chime chime = null;
            CustomWebhook customWebhook = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block5: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block10: {
                    String string;
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    if (fieldName == null) throw (Throwable)new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Destination.");
                    switch (string.hashCode()) {
                        case 109518736: {
                            if (!string.equals(Destination.SLACK)) throw (Throwable)new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Destination.");
                            break;
                        }
                        case 697640873: {
                            if (!string.equals(Destination.CUSTOMWEBHOOK)) throw (Throwable)new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Destination.");
                            break block10;
                        }
                        case 94631228: {
                            if (!string.equals(Destination.CHIME)) throw (Throwable)new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Destination.");
                            chime = Chime.Companion.parse(xcp);
                            continue block5;
                        }
                    }
                    slack = Slack.Companion.parse(xcp);
                    continue;
                }
                customWebhook = CustomWebhook.Companion.parse(xcp);
                continue;
                throw (Throwable)new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Destination.");
            }
            if (chime != null) {
                destinationType = DestinationType.CHIME;
            } else if (slack != null) {
                destinationType = DestinationType.SLACK;
            } else {
                if (customWebhook == null) throw (Throwable)new IllegalArgumentException("Must specify a destination type");
                destinationType = DestinationType.CUSTOM_WEBHOOK;
            }
            DestinationType type = destinationType;
            return new Destination(type, chime, slack, customWebhook);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

