/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model;

import com.amazon.opendistroforelasticsearch.indexmanagement.elasticapi.ElasticExtensionsKt;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B#\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\fH\u00c6\u0003J-\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/ISMTemplate;", "Lorg/elasticsearch/common/xcontent/ToXContentObject;", "Lorg/elasticsearch/common/io/stream/Writeable;", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "(Lorg/elasticsearch/common/io/stream/StreamInput;)V", "indexPatterns", "", "", "priority", "", "lastUpdatedTime", "Ljava/time/Instant;", "(Ljava/util/List;ILjava/time/Instant;)V", "getIndexPatterns", "()Ljava/util/List;", "getLastUpdatedTime", "()Ljava/time/Instant;", "getPriority", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "toXContent", "Lorg/elasticsearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/elasticsearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/elasticsearch/common/io/stream/StreamOutput;", "Companion", "opendistro-index-management"})
public final class ISMTemplate
implements ToXContentObject,
Writeable {
    @NotNull
    private final List<String> indexPatterns;
    private final int priority;
    @NotNull
    private final Instant lastUpdatedTime;
    @NotNull
    public static final String ISM_TEMPLATE_TYPE = "ism_template";
    @NotNull
    public static final String INDEX_PATTERN = "index_patterns";
    @NotNull
    public static final String PRIORITY = "priority";
    @NotNull
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        XContentBuilder xContentBuilder = builder.startObject().field(INDEX_PATTERN, (Iterable)this.indexPatterns).field(PRIORITY, this.priority);
        Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026field(PRIORITY, priority)");
        XContentBuilder xContentBuilder2 = ElasticExtensionsKt.optionalTimeField(xContentBuilder, LAST_UPDATED_TIME_FIELD, this.lastUpdatedTime).endObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder2, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder2;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        out.writeStringCollection((Collection)this.indexPatterns);
        out.writeInt(this.priority);
        out.writeInstant(this.lastUpdatedTime);
    }

    @NotNull
    public final List<String> getIndexPatterns() {
        return this.indexPatterns;
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ISMTemplate(@NotNull List<String> indexPatterns, int priority, @NotNull Instant lastUpdatedTime) {
        Intrinsics.checkParameterIsNotNull(indexPatterns, (String)"indexPatterns");
        Intrinsics.checkParameterIsNotNull((Object)lastUpdatedTime, (String)"lastUpdatedTime");
        this.indexPatterns = indexPatterns;
        this.priority = priority;
        this.lastUpdatedTime = lastUpdatedTime;
        boolean bl = this.priority >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Requires priority to be >= 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Collection collection = this.indexPatterns;
        bl2 = false;
        boolean bl5 = !collection.isEmpty();
        bl2 = false;
        bl3 = false;
        if (!bl5) {
            boolean bl6 = false;
            String string = "Requires at least one index pattern";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public ISMTemplate(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
        List list = sin.readStringList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"sin.readStringList()");
        int n = sin.readInt();
        Instant instant = sin.readInstant();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"sin.readInstant()");
        this(list, n, instant);
    }

    @NotNull
    public final List<String> component1() {
        return this.indexPatterns;
    }

    public final int component2() {
        return this.priority;
    }

    @NotNull
    public final Instant component3() {
        return this.lastUpdatedTime;
    }

    @NotNull
    public final ISMTemplate copy(@NotNull List<String> indexPatterns, int priority, @NotNull Instant lastUpdatedTime) {
        Intrinsics.checkParameterIsNotNull(indexPatterns, (String)"indexPatterns");
        Intrinsics.checkParameterIsNotNull((Object)lastUpdatedTime, (String)"lastUpdatedTime");
        return new ISMTemplate(indexPatterns, priority, lastUpdatedTime);
    }

    public static /* synthetic */ ISMTemplate copy$default(ISMTemplate iSMTemplate, List list, int n, Instant instant, int n2, Object object) {
        if ((n2 & 1) != 0) {
            list = iSMTemplate.indexPatterns;
        }
        if ((n2 & 2) != 0) {
            n = iSMTemplate.priority;
        }
        if ((n2 & 4) != 0) {
            instant = iSMTemplate.lastUpdatedTime;
        }
        return iSMTemplate.copy(list, n, instant);
    }

    @NotNull
    public String toString() {
        return "ISMTemplate(indexPatterns=" + this.indexPatterns + ", priority=" + this.priority + ", lastUpdatedTime=" + this.lastUpdatedTime + ")";
    }

    public int hashCode() {
        List<String> list = this.indexPatterns;
        Instant instant = this.lastUpdatedTime;
        return ((list != null ? ((Object)list).hashCode() : 0) * 31 + Integer.hashCode(this.priority)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ISMTemplate)) break block3;
                ISMTemplate iSMTemplate = (ISMTemplate)object;
                if (!Intrinsics.areEqual(this.indexPatterns, iSMTemplate.indexPatterns) || this.priority != iSMTemplate.priority || !Intrinsics.areEqual((Object)this.lastUpdatedTime, (Object)iSMTemplate.lastUpdatedTime)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/ISMTemplate$Companion;", "", "()V", "INDEX_PATTERN", "", "ISM_TEMPLATE_TYPE", "LAST_UPDATED_TIME_FIELD", "PRIORITY", "parse", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/ISMTemplate;", "xcp", "Lorg/elasticsearch/common/xcontent/XContentParser;", "opendistro-index-management"})
    public static final class Companion {
        @NotNull
        public final ISMTemplate parse(@NotNull XContentParser xcp) {
            Intrinsics.checkParameterIsNotNull((Object)xcp, (String)"xcp");
            boolean bl = false;
            List indexPatterns = new ArrayList();
            int priority = 0;
            Instant lastUpdatedTime = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                if (fieldName != null) {
                    String string;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1670470950: {
                            if (!string.equals(ISMTemplate.LAST_UPDATED_TIME_FIELD)) break;
                            n = 1;
                            break;
                        }
                        case -1308992592: {
                            if (!string.equals(ISMTemplate.INDEX_PATTERN)) break;
                            n = 2;
                            break;
                        }
                        case -1165461084: {
                            if (!string.equals(ISMTemplate.PRIORITY)) break;
                            n = 3;
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                String string2 = xcp.text();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"xcp.text()");
                                indexPatterns.add(string2);
                            }
                            continue block10;
                        }
                        case 3: {
                            priority = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? 0 : xcp.intValue();
                            continue block10;
                        }
                        case 1: {
                            lastUpdatedTime = ElasticExtensionsKt.instant(xcp);
                            continue block10;
                        }
                    }
                }
                throw (Throwable)new IllegalArgumentException("Invalid field: [" + fieldName + "] found in ISMTemplate.");
            }
            Instant instant = lastUpdatedTime;
            if (instant == null) {
                Instant instant2 = Instant.now();
                instant = instant2;
                Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"Instant.now()");
            }
            return new ISMTemplate(indexPatterns, priority, instant);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

