/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.action;

import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.action.Action;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.ManagedIndexMetaData;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.action.ActionConfig;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.action.ForceMergeActionConfig;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.managedindexmetadata.StepMetaData;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.step.Step;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.step.forcemerge.AttemptCallForceMergeStep;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.step.forcemerge.AttemptSetReadOnlyStep;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.step.forcemerge.WaitForForceMergeStep;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/action/ForceMergeAction;", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/action/Action;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "client", "Lorg/elasticsearch/client/Client;", "managedIndexMetaData", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/ManagedIndexMetaData;", "config", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/action/ForceMergeActionConfig;", "(Lorg/elasticsearch/cluster/service/ClusterService;Lorg/elasticsearch/client/Client;Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/ManagedIndexMetaData;Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/action/ForceMergeActionConfig;)V", "attemptCallForceMergeStep", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/step/forcemerge/AttemptCallForceMergeStep;", "attemptSetReadOnlyStep", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/step/forcemerge/AttemptSetReadOnlyStep;", "stepNameToStep", "Ljava/util/LinkedHashMap;", "", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/step/Step;", "Lkotlin/collections/LinkedHashMap;", "waitForForceMergeStep", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/step/forcemerge/WaitForForceMergeStep;", "getStepToExecute", "getSteps", "", "opendistro-index-management"})
public final class ForceMergeAction
extends Action {
    private final AttemptSetReadOnlyStep attemptSetReadOnlyStep;
    private final AttemptCallForceMergeStep attemptCallForceMergeStep;
    private final WaitForForceMergeStep waitForForceMergeStep;
    private final LinkedHashMap<String, Step> stepNameToStep;

    @Override
    @NotNull
    public List<Step> getSteps() {
        Collection<Step> collection = this.stepNameToStep.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"stepNameToStep.values");
        return CollectionsKt.toList((Iterable)collection);
    }

    @Override
    @NotNull
    public Step getStepToExecute() {
        StepMetaData stepMetaData = this.getManagedIndexMetaData().getStepMetaData();
        if (stepMetaData == null) {
            return this.attemptSetReadOnlyStep;
        }
        StepMetaData stepMetaData2 = stepMetaData;
        String currentStep = stepMetaData2.getName();
        if (!this.stepNameToStep.containsKey(currentStep)) {
            return this.attemptSetReadOnlyStep;
        }
        Step.StepStatus currentStepStatus = stepMetaData2.getStepStatus();
        if (currentStepStatus == Step.StepStatus.COMPLETED) {
            Step step2;
            switch (currentStep) {
                case "attempt_set_read_only": {
                    step2 = this.attemptCallForceMergeStep;
                    break;
                }
                case "attempt_call_force_merge": {
                    step2 = this.waitForForceMergeStep;
                    break;
                }
                default: {
                    Step step3 = this.stepNameToStep.get(currentStep);
                    if (step3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)step3, (String)"stepNameToStep[currentStep]!!");
                    step2 = step3;
                }
            }
            return step2;
        }
        Step step4 = this.stepNameToStep.get(currentStep);
        if (step4 == null) {
            Intrinsics.throwNpe();
        }
        return step4;
    }

    public ForceMergeAction(@NotNull ClusterService clusterService, @NotNull Client client, @NotNull ManagedIndexMetaData managedIndexMetaData, @NotNull ForceMergeActionConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)managedIndexMetaData, (String)"managedIndexMetaData");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(ActionConfig.ActionType.FORCE_MERGE, config, managedIndexMetaData);
        this.attemptSetReadOnlyStep = new AttemptSetReadOnlyStep(clusterService, client, config, managedIndexMetaData);
        this.attemptCallForceMergeStep = new AttemptCallForceMergeStep(clusterService, client, config, managedIndexMetaData);
        this.waitForForceMergeStep = new WaitForForceMergeStep(clusterService, client, config, managedIndexMetaData);
        this.stepNameToStep = MapsKt.linkedMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"attempt_set_read_only", (Object)this.attemptSetReadOnlyStep), TuplesKt.to((Object)"attempt_call_force_merge", (Object)this.attemptCallForceMergeStep), TuplesKt.to((Object)"wait_for_force_merge", (Object)this.waitForForceMergeStep)});
    }
}

