/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement;

import com.amazon.opendistroforelasticsearch.indexmanagement.IndexManagementIndices;
import com.amazon.opendistroforelasticsearch.indexmanagement.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.IndexStateManagementHistory;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.IndexStateManagementHistory$WhenMappings;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.ManagedIndexMetaData;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.managedindexmetadata.StepMetaData;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.step.Step;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001f\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020$H\u0002J\b\u0010(\u001a\u00020!H\u0002J\b\u0010)\u001a\u00020!H\u0016J\b\u0010*\u001a\u00020!H\u0016J\b\u0010+\u001a\u00020!H\u0002J\b\u0010,\u001a\u00020!H\u0002J\b\u0010-\u001a\u00020\u000eH\u0002J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020$H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0016\u0010\u0011\u001a\n \u000f*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n \u000f*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0018\u0010\u0016\u001a\n \u000f*\u0004\u0018\u00010\u00170\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0018\u0010\u0019\u001a\n \u000f*\u0004\u0018\u00010\u00170\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0016\u0010\u001a\u001a\n \u000f*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u000f*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u000f*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006/"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/IndexStateManagementHistory;", "Lorg/elasticsearch/cluster/LocalNodeMasterListener;", "settings", "Lorg/elasticsearch/common/settings/Settings;", "client", "Lorg/elasticsearch/client/Client;", "threadPool", "Lorg/elasticsearch/threadpool/ThreadPool;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "indexManagementIndices", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/IndexManagementIndices;", "(Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/threadpool/ThreadPool;Lorg/elasticsearch/cluster/service/ClusterService;Lcom/amazon/opendistroforelasticsearch/indexmanagement/IndexManagementIndices;)V", "historyEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "historyMaxAge", "Lorg/elasticsearch/common/unit/TimeValue;", "historyMaxDocs", "", "Ljava/lang/Long;", "historyNumberOfReplicas", "", "Ljava/lang/Integer;", "historyNumberOfShards", "historyRetentionPeriod", "historyRolloverCheckPeriod", "logger", "Lorg/apache/logging/log4j/Logger;", "scheduledRollover", "Lorg/elasticsearch/threadpool/Scheduler$Cancellable;", "addManagedIndexMetaDataHistory", "", "managedIndexMetaData", "", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/ManagedIndexMetaData;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createManagedIndexMetaDataHistoryIndexRequest", "Lorg/elasticsearch/action/index/IndexRequest;", "deleteOldHistoryIndex", "offMaster", "onMaster", "rescheduleRollover", "rolloverAndDeleteHistoryIndex", "rolloverHistoryIndex", "shouldAddManagedIndexMetaDataToHistory", "opendistro-index-management"})
public final class IndexStateManagementHistory
implements LocalNodeMasterListener {
    private final Logger logger;
    private Scheduler.Cancellable scheduledRollover;
    private volatile Boolean historyEnabled;
    private volatile Long historyMaxDocs;
    private volatile TimeValue historyMaxAge;
    private volatile TimeValue historyRolloverCheckPeriod;
    private volatile TimeValue historyRetentionPeriod;
    private volatile Integer historyNumberOfShards;
    private volatile Integer historyNumberOfReplicas;
    private final Client client;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndexManagementIndices indexManagementIndices;

    public void onMaster() {
        try {
            this.rolloverHistoryIndex();
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(new Runnable(this){
                final /* synthetic */ IndexStateManagementHistory this$0;

                public final void run() {
                    IndexStateManagementHistory.access$rolloverAndDeleteHistoryIndex(this.this$0);
                }
                {
                    this.this$0 = indexStateManagementHistory;
                }
            }, this.historyRolloverCheckPeriod, "management");
        }
        catch (Exception e) {
            this.logger.error("Error creating ISM history index.", (Throwable)e);
        }
    }

    public void offMaster() {
        block0: {
            Scheduler.Cancellable cancellable = this.scheduledRollover;
            if (cancellable == null) break block0;
            cancellable.cancel();
        }
    }

    private final void rescheduleRollover() {
        ClusterState clusterState = this.clusterService.state();
        Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterService.state()");
        DiscoveryNodes discoveryNodes = clusterState.getNodes();
        Intrinsics.checkExpressionValueIsNotNull((Object)discoveryNodes, (String)"clusterService.state().nodes");
        if (discoveryNodes.isLocalNodeElectedMaster()) {
            Scheduler.Cancellable cancellable = this.scheduledRollover;
            if (cancellable != null) {
                cancellable.cancel();
            }
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(new Runnable(this){
                final /* synthetic */ IndexStateManagementHistory this$0;

                public final void run() {
                    IndexStateManagementHistory.access$rolloverAndDeleteHistoryIndex(this.this$0);
                }
                {
                    this.this$0 = indexStateManagementHistory;
                }
            }, this.historyRolloverCheckPeriod, "management");
        }
    }

    private final void rolloverAndDeleteHistoryIndex() {
        Boolean bl = this.historyEnabled;
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"historyEnabled");
        if (bl.booleanValue()) {
            this.rolloverHistoryIndex();
        }
        this.deleteOldHistoryIndex();
    }

    private final boolean rolloverHistoryIndex() {
        RolloverResponse response2;
        if (!this.indexManagementIndices.indexStateManagementIndexHistoryExists()) {
            return false;
        }
        RolloverRequest request = new RolloverRequest(".opendistro-ism-managed-index-history-write", null);
        CreateIndexRequest createIndexRequest = request.getCreateIndexRequest().index("<.opendistro-ism-managed-index-history-{now/d{yyyy.MM.dd}}-1>").mapping("_doc", IndexManagementIndices.Companion.getIndexStateManagementHistoryMappings(), XContentType.JSON);
        Settings.Builder builder = Settings.builder().put("index.hidden", true);
        Integer n = this.historyNumberOfShards;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"historyNumberOfShards");
        Settings.Builder builder2 = builder.put("index.number_of_shards", n.intValue());
        Integer n2 = this.historyNumberOfReplicas;
        Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"historyNumberOfReplicas");
        createIndexRequest.settings(builder2.put("index.number_of_replicas", n2.intValue()));
        Long l = this.historyMaxDocs;
        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"historyMaxDocs");
        request.addMaxIndexDocsCondition(l.longValue());
        request.addMaxIndexAgeCondition(this.historyMaxAge);
        RolloverResponse rolloverResponse = response2 = (RolloverResponse)this.client.admin().indices().rolloverIndex(request).actionGet();
        Intrinsics.checkExpressionValueIsNotNull((Object)rolloverResponse, (String)"response");
        if (!rolloverResponse.isRolledOver()) {
            this.logger.info(".opendistro-ism-managed-index-history-write not rolled over. Conditions were: " + response2.getConditionStatus());
        }
        return response2.isRolledOver();
    }

    private final void deleteOldHistoryIndex() {
        Collection entry2;
        ClusterStateResponse clusterStateResponse;
        boolean bl = false;
        List indexToDelete = new ArrayList();
        ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(new String[]{".opendistro-ism-managed-index-history*"}).metadata(true).local(true)).indicesOptions(IndicesOptions.strictExpand());
        ClusterStateResponse clusterStateResponse2 = clusterStateResponse = (ClusterStateResponse)this.client.admin().cluster().state(clusterStateRequest).actionGet();
        Intrinsics.checkExpressionValueIsNotNull((Object)clusterStateResponse2, (String)"clusterStateResponse");
        ClusterState clusterState = clusterStateResponse2.getState();
        Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterStateResponse.state");
        for (Collection entry2 : clusterState.getMetadata().indices()) {
            Object v7;
            IndexMetadata indexMetaData;
            block10: {
                IndexMetadata indexMetadata = indexMetaData = (IndexMetadata)((ObjectObjectCursor)entry2).value;
                Intrinsics.checkExpressionValueIsNotNull((Object)indexMetadata, (String)"indexMetaData");
                long creationTime = indexMetadata.getCreationDate();
                long l = Instant.now().toEpochMilli() - creationTime;
                TimeValue timeValue = this.historyRetentionPeriod;
                Intrinsics.checkExpressionValueIsNotNull((Object)timeValue, (String)"historyRetentionPeriod");
                if (l <= timeValue.getMillis()) continue;
                ImmutableOpenMap immutableOpenMap = indexMetaData.getAliases();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableOpenMap, (String)"indexMetaData.aliases");
                Iterable $this$firstOrNull$iv = (Iterable)immutableOpenMap;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ObjectObjectCursor it = (ObjectObjectCursor)element$iv;
                    boolean bl2 = false;
                    Object object = it.value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.value");
                    if (!Intrinsics.areEqual((Object)".opendistro-ism-managed-index-history-write", (Object)((AliasMetadata)object).getAlias())) continue;
                    v7 = element$iv;
                    break block10;
                }
                v7 = null;
            }
            ObjectObjectCursor alias = v7;
            if (alias != null) {
                Boolean bl3 = this.historyEnabled;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl3, (String)"historyEnabled");
                if (bl3.booleanValue()) continue;
            }
            Index index = indexMetaData.getIndex();
            Intrinsics.checkExpressionValueIsNotNull((Object)index, (String)"indexMetaData.index");
            String string = index.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"indexMetaData.index.name");
            indexToDelete.add(string);
        }
        entry2 = indexToDelete;
        boolean bl4 = false;
        if (!entry2.isEmpty()) {
            AcknowledgedResponse deleteResponse;
            Collection $this$toTypedArray$iv = indexToDelete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray2 = stringArray;
            String[] stringArray3 = Arrays.copyOf(stringArray2, stringArray2.length);
            DeleteIndexRequest deleteRequest = new DeleteIndexRequest(stringArray3);
            AcknowledgedResponse acknowledgedResponse = deleteResponse = (AcknowledgedResponse)this.client.admin().indices().delete(deleteRequest).actionGet();
            Intrinsics.checkExpressionValueIsNotNull((Object)acknowledgedResponse, (String)"deleteResponse");
            if (!acknowledgedResponse.isAcknowledged()) {
                this.logger.error("could not delete one or more ISM history index. " + indexToDelete + ". Retrying one by one.");
                for (String index : indexToDelete) {
                    try {
                        AcknowledgedResponse singleDeleteResponse;
                        Collection $this$toTypedArray$iv2 = indexToDelete;
                        boolean $i$f$toTypedArray2 = false;
                        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                        if (thisCollection$iv2.toArray(new String[0]) == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        String[] stringArray4 = Arrays.copyOf(stringArray2, stringArray2.length);
                        DeleteIndexRequest singleDeleteRequest = new DeleteIndexRequest(stringArray4);
                        AcknowledgedResponse acknowledgedResponse2 = singleDeleteResponse = (AcknowledgedResponse)this.client.admin().indices().delete(singleDeleteRequest).actionGet();
                        Intrinsics.checkExpressionValueIsNotNull((Object)acknowledgedResponse2, (String)"singleDeleteResponse");
                        if (acknowledgedResponse2.isAcknowledged()) continue;
                        this.logger.error("could not delete one or more ISM history index. " + index + '.');
                    }
                    catch (IndexNotFoundException e) {
                        this.logger.debug(index + " was already deleted. " + e.getMessage());
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object addManagedIndexMetaDataHistory(@NotNull List<ManagedIndexMetaData> managedIndexMetaData, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof addManagedIndexMetaDataHistory.1)) ** GOTO lbl-1000
        var16_3 = $completion;
        if ((var16_3.label & -2147483648) != 0) {
            var16_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ IndexStateManagementHistory this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.addManagedIndexMetaDataHistory(null, (Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = indexStateManagementHistory;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.historyEnabled.booleanValue()) {
                    this.logger.debug("Index State Management history is not enabled");
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = managedIndexMetaData;
                $continuation.label = 1;
                v0 = this.indexManagementIndices.checkAndUpdateHistoryIndex((Continuation<? super Boolean>)$continuation);
                if (v0 == var17_5) {
                    return var17_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                managedIndexMetaData = (List)$continuation.L$1;
                this = (IndexStateManagementHistory)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    this.logger.error("Failed to create or update the ism history index:");
                    return Unit.INSTANCE;
                }
                $this$filter$iv = managedIndexMetaData;
                $i$f$filter = false;
                var6_10 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ManagedIndexMetaData)element$iv$iv;
                    $i$a$-filter-IndexStateManagementHistory$addManagedIndexMetaDataHistory$docWriteRequest$1 = false;
                    if (!Boxing.boxBoolean((boolean)this.shouldAddManagedIndexMetaDataToHistory(it)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ManagedIndexMetaData)item$iv$iv;
                    var13_17 = destination$iv$iv;
                    $i$a$-map-IndexStateManagementHistory$addManagedIndexMetaDataHistory$docWriteRequest$2 = false;
                    var14_18 = this.createManagedIndexMetaDataHistoryIndexRequest(it);
                    var13_17.add(var14_18);
                }
                docWriteRequest = (List)destination$iv$iv;
                $this$map$iv = docWriteRequest;
                $i$f$map = false;
                if (!($this$map$iv.isEmpty() == false)) ** GOTO lbl91
                bulkRequest = new BulkRequest().add((Iterable)docWriteRequest);
                $continuation.L$0 = this;
                $continuation.L$1 = managedIndexMetaData;
                $continuation.L$2 = docWriteRequest;
                $continuation.L$3 = bulkRequest;
                $continuation.label = 2;
                v1 = ElasticExtensionsKt.suspendUntil((ElasticsearchClient)this.client, (Function2)new Function2<Client, ActionListener<BulkResponse>, Unit>(bulkRequest){
                    final /* synthetic */ BulkRequest $bulkRequest;

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<BulkResponse> it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$suspendUntil, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        $this$suspendUntil.bulk(this.$bulkRequest, it);
                    }
                    {
                        this.$bulkRequest = bulkRequest;
                        super(2);
                    }
                }, $continuation);
                ** if (v1 != var17_5) goto lbl70
lbl69:
                // 1 sources

                return var17_5;
lbl70:
                // 1 sources

                ** GOTO lbl80
            }
            case 2: {
                bulkRequest = (BulkRequest)$continuation.L$3;
                docWriteRequest = (List)$continuation.L$2;
                managedIndexMetaData = (List)$continuation.L$1;
                this = (IndexStateManagementHistory)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl80:
                    // 2 sources

                    bulkResponse = (BulkResponse)v1;
                    var7_11 = bulkResponse.iterator();
                    while (var7_11.hasNext()) {
                        v2 = bulkItemResponse = (BulkItemResponse)var7_11.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"bulkItemResponse");
                        if (!v2.isFailed()) continue;
                        this.logger.error("Failed to add history. Id: " + bulkItemResponse.getId() + ", failureMessage: " + bulkItemResponse.getFailureMessage());
                    }
                }
                catch (Exception e) {
                    this.logger.error("failed to index indexMetaData History.", (Throwable)e);
                }
lbl91:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldAddManagedIndexMetaDataToHistory(ManagedIndexMetaData managedIndexMetaData) {
        StepMetaData stepMetaData = managedIndexMetaData.getStepMetaData();
        if (stepMetaData == null) return true;
        Step.StepStatus stepStatus = stepMetaData.getStepStatus();
        if (stepStatus == null) return true;
        switch (IndexStateManagementHistory$WhenMappings.$EnumSwitchMapping$0[stepStatus.ordinal()]) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            default: {
                return true;
            }
        }
    }

    private final IndexRequest createManagedIndexMetaDataHistoryIndexRequest(ManagedIndexMetaData managedIndexMetaData) {
        XContentBuilder builder;
        XContentBuilder xContentBuilder = builder = XContentFactory.jsonBuilder().startObject().startObject("managed_index_meta_data");
        Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"builder");
        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)params, (String)"ToXContent.EMPTY_PARAMS");
        managedIndexMetaData.toXContent(xContentBuilder, params);
        builder.field("history_timestamp", Instant.now().toEpochMilli()).endObject().endObject();
        IndexRequest indexRequest = new IndexRequest(".opendistro-ism-managed-index-history-write").source(builder);
        Intrinsics.checkExpressionValueIsNotNull((Object)indexRequest, (String)"IndexRequest(IndexManage\u2026         .source(builder)");
        return indexRequest;
    }

    public IndexStateManagementHistory(@NotNull Settings settings, @NotNull Client client, @NotNull ThreadPool threadPool, @NotNull ClusterService clusterService, @NotNull IndexManagementIndices indexManagementIndices) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)threadPool, (String)"threadPool");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        Intrinsics.checkParameterIsNotNull((Object)indexManagementIndices, (String)"indexManagementIndices");
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indexManagementIndices = indexManagementIndices;
        this.logger = LogManager.getLogger(this.getClass());
        this.historyEnabled = (Boolean)ManagedIndexSettings.Companion.getHISTORY_ENABLED().get(settings);
        this.historyMaxDocs = (Long)ManagedIndexSettings.Companion.getHISTORY_MAX_DOCS().get(settings);
        this.historyMaxAge = (TimeValue)ManagedIndexSettings.Companion.getHISTORY_INDEX_MAX_AGE().get(settings);
        this.historyRolloverCheckPeriod = (TimeValue)ManagedIndexSettings.Companion.getHISTORY_ROLLOVER_CHECK_PERIOD().get(settings);
        this.historyRetentionPeriod = (TimeValue)ManagedIndexSettings.Companion.getHISTORY_RETENTION_PERIOD().get(settings);
        this.historyNumberOfShards = (Integer)ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_SHARDS().get(settings);
        this.historyNumberOfReplicas = (Integer)ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_REPLICAS().get(settings);
        this.clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_ENABLED(), (Consumer)new Consumer<Boolean>(){

            @Override
            public final void accept(Boolean it) {
                historyEnabled = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_MAX_DOCS(), (Consumer)new Consumer<Long>(){

            @Override
            public final void accept(Long it) {
                historyMaxDocs = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_INDEX_MAX_AGE(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                historyMaxAge = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_ROLLOVER_CHECK_PERIOD(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                historyRolloverCheckPeriod = it;
                this.rescheduleRollover();
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_RETENTION_PERIOD(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                historyRetentionPeriod = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_SHARDS(), (Consumer)new Consumer<Integer>(){

            @Override
            public final void accept(Integer it) {
                historyNumberOfShards = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_REPLICAS(), (Consumer)new Consumer<Integer>(){

            @Override
            public final void accept(Integer it) {
                historyNumberOfReplicas = it;
            }
        });
    }

    public static final /* synthetic */ void access$rolloverAndDeleteHistoryIndex(IndexStateManagementHistory $this) {
        $this.rolloverAndDeleteHistoryIndex();
    }

    public static final /* synthetic */ Boolean access$getHistoryEnabled$p(IndexStateManagementHistory $this) {
        return $this.historyEnabled;
    }

    public static final /* synthetic */ Long access$getHistoryMaxDocs$p(IndexStateManagementHistory $this) {
        return $this.historyMaxDocs;
    }

    public static final /* synthetic */ TimeValue access$getHistoryMaxAge$p(IndexStateManagementHistory $this) {
        return $this.historyMaxAge;
    }

    public static final /* synthetic */ TimeValue access$getHistoryRolloverCheckPeriod$p(IndexStateManagementHistory $this) {
        return $this.historyRolloverCheckPeriod;
    }

    public static final /* synthetic */ TimeValue access$getHistoryRetentionPeriod$p(IndexStateManagementHistory $this) {
        return $this.historyRetentionPeriod;
    }

    public static final /* synthetic */ Integer access$getHistoryNumberOfShards$p(IndexStateManagementHistory $this) {
        return $this.historyNumberOfShards;
    }

    public static final /* synthetic */ Integer access$getHistoryNumberOfReplicas$p(IndexStateManagementHistory $this) {
        return $this.historyNumberOfReplicas;
    }
}

