/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement;

import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.ISMTemplateServiceKt$sam$i$java_util_function_Predicate$0;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.ISMTemplate;
import com.amazon.opendistroforelasticsearch.indexmanagement.util.IndexManagementException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.Index;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001aF\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\t*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00072\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\r\u001a \u0010\u000e\u001a\u0004\u0018\u00010\u0007*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000f\u001a\u00020\u0010\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "validateFormat", "Lorg/elasticsearch/ElasticsearchException;", "indexPatterns", "", "", "findConflictingPolicyTemplates", "", "Lcom/amazon/opendistroforelasticsearch/indexmanagement/indexstatemanagement/model/ISMTemplate;", "candidate", "priority", "", "findMatchingPolicy", "indexMetadata", "Lorg/elasticsearch/cluster/metadata/IndexMetadata;", "opendistro-index-management"})
public final class ISMTemplateServiceKt {
    private static final Logger log = LogManager.getLogger((String)"ISMTemplateService");

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String findMatchingPolicy(@NotNull Map<String, ISMTemplate> $this$findMatchingPolicy, @NotNull IndexMetadata indexMetadata) {
        void $this$filterTo$iv$iv;
        Boolean isHidden;
        Intrinsics.checkParameterIsNotNull($this$findMatchingPolicy, (String)"$this$findMatchingPolicy");
        Intrinsics.checkParameterIsNotNull((Object)indexMetadata, (String)"indexMetadata");
        if ($this$findMatchingPolicy.isEmpty()) {
            return null;
        }
        Index index = indexMetadata.getIndex();
        Intrinsics.checkExpressionValueIsNotNull((Object)index, (String)"indexMetadata.index");
        String indexName = index.getName();
        Boolean bl = isHidden = (Boolean)IndexMetadata.INDEX_HIDDEN_SETTING.get(indexMetadata.getSettings());
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"isHidden");
        if (bl.booleanValue()) {
            return null;
        }
        Function1 patternMatchPredicate2 = (Function1)new Function1<String, Boolean>(indexName){
            final /* synthetic */ String $indexName;

            public final boolean invoke(@NotNull String pattern) {
                Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
                return Regex.simpleMatch((String)pattern, (String)this.$indexName);
            }
            {
                this.$indexName = string;
                super(1);
            }
        };
        String matchedPolicy = null;
        int highestPriority = -1;
        Map $this$filter$iv = $this$findMatchingPolicy;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var12_14 = $this$filterTo$iv$iv;
        boolean bl2 = false;
        Iterator iterator = var12_14.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry $dstr$_u24__u24$template = element$iv$iv = iterator.next();
            boolean bl3 = false;
            Map.Entry entry = $dstr$_u24__u24$template;
            boolean bl4 = false;
            ISMTemplate template = (ISMTemplate)entry.getValue();
            if (!(template.getLastUpdatedTime().toEpochMilli() < indexMetadata.getCreationDate())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        map = $this$forEach$iv;
        boolean bl5 = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            void policyID;
            boolean matched;
            Map.Entry element$iv;
            Map.Entry $dstr$policyID$template = element$iv = iterator2.next();
            boolean bl6 = false;
            Map.Entry element$iv$iv = $dstr$policyID$template;
            boolean bl7 = false;
            String bl3 = (String)element$iv$iv.getKey();
            element$iv$iv = $dstr$policyID$template;
            bl7 = false;
            ISMTemplate template = (ISMTemplate)element$iv$iv.getValue();
            Stream stream = template.getIndexPatterns().stream();
            Object object = patternMatchPredicate2;
            if (object != null) {
                Function1 function1 = object;
                object = new ISMTemplateServiceKt$sam$i$java_util_function_Predicate$0(function1);
            }
            if (!(matched = stream.anyMatch((Predicate)object)) || highestPriority >= template.getPriority()) continue;
            highestPriority = template.getPriority();
            matchedPolicy = policyID;
        }
        return matchedPolicy;
    }

    @Nullable
    public static final ElasticsearchException validateFormat(@NotNull List<String> indexPatterns) {
        Intrinsics.checkParameterIsNotNull(indexPatterns, (String)"indexPatterns");
        boolean bl = false;
        List indexPatternFormatErrors = new ArrayList();
        for (String indexPattern : indexPatterns) {
            if (StringsKt.contains$default((CharSequence)indexPattern, (CharSequence)"#", (boolean)false, (int)2, null)) {
                indexPatternFormatErrors.add("index_pattern [" + indexPattern + "] must not contain a '#'");
            }
            if (StringsKt.contains$default((CharSequence)indexPattern, (CharSequence)":", (boolean)false, (int)2, null)) {
                indexPatternFormatErrors.add("index_pattern [" + indexPattern + "] must not contain a ':'");
            }
            if (StringsKt.startsWith$default((String)indexPattern, (String)"_", (boolean)false, (int)2, null)) {
                indexPatternFormatErrors.add("index_pattern [" + indexPattern + "] must not start with '_'");
            }
            if (Strings.validFileNameExcludingAstrix((String)indexPattern)) continue;
            indexPatternFormatErrors.add("index_pattern [" + indexPattern + "] must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (indexPatternFormatErrors.size() > 0) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors((Iterable)indexPatternFormatErrors);
            return IndexManagementException.Companion.wrap((Exception)validationException);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<String>> findConflictingPolicyTemplates(@NotNull Map<String, ISMTemplate> $this$findConflictingPolicyTemplates, @NotNull String candidate, @NotNull List<String> indexPatterns, int priority) {
        Map.Entry element$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$findConflictingPolicyTemplates, (String)"$this$findConflictingPolicyTemplates");
        Intrinsics.checkParameterIsNotNull((Object)candidate, (String)"candidate");
        Intrinsics.checkParameterIsNotNull(indexPatterns, (String)"indexPatterns");
        Collection $this$toTypedArray$iv = indexPatterns;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Automaton automaton1 = Regex.simpleMatchToAutomaton((String[])Arrays.copyOf(stringArray, stringArray.length));
        $i$f$toTypedArray = false;
        Map overlappingTemplates = new LinkedHashMap();
        Map $this$filter$iv = $this$findConflictingPolicyTemplates;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var11_15 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var11_15.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!(((ISMTemplate)it.getValue()).getPriority() == priority)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        map = $this$forEach$iv;
        boolean bl3 = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            void policyID;
            Map.Entry element$iv;
            Map.Entry $dstr$policyID$template = element$iv = iterator2.next();
            boolean bl4 = false;
            element$iv$iv = $dstr$policyID$template;
            boolean it = false;
            String bl2 = (String)element$iv$iv.getKey();
            element$iv$iv = $dstr$policyID$template;
            it = false;
            ISMTemplate template = (ISMTemplate)element$iv$iv.getValue();
            Collection $this$toTypedArray$iv2 = template.getIndexPatterns();
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Automaton automaton2 = Regex.simpleMatchToAutomaton((String[])Arrays.copyOf(stringArray2, stringArray2.length));
            if (Operations.isEmpty((Automaton)Operations.intersection((Automaton)automaton1, (Automaton)automaton2))) continue;
            log.info("Existing ism_template for " + (String)policyID + " overlaps candidate " + candidate);
            overlappingTemplates.put(policyID, template.getIndexPatterns());
        }
        overlappingTemplates.remove(candidate);
        return overlappingTemplates;
    }
}

