/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement;

import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.ManagedIndexRunner;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.model.ManagedIndexConfig;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.RollupRunner;
import com.amazon.opendistroforelasticsearch.indexmanagement.rollup.model.Rollup;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.JobExecutionContext;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.ScheduledJobParameter;
import com.amazon.opendistroforelasticsearch.jobscheduler.spi.ScheduledJobRunner;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/IndexManagementRunner;", "Lcom/amazon/opendistroforelasticsearch/jobscheduler/spi/ScheduledJobRunner;", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "runJob", "", "job", "Lcom/amazon/opendistroforelasticsearch/jobscheduler/spi/ScheduledJobParameter;", "context", "Lcom/amazon/opendistroforelasticsearch/jobscheduler/spi/JobExecutionContext;", "opendistro-index-management"})
public final class IndexManagementRunner
implements ScheduledJobRunner {
    private static final Logger logger;
    public static final IndexManagementRunner INSTANCE;

    public void runJob(@NotNull ScheduledJobParameter job, @NotNull JobExecutionContext context) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ScheduledJobParameter scheduledJobParameter = job;
        if (scheduledJobParameter instanceof ManagedIndexConfig) {
            ManagedIndexRunner.INSTANCE.runJob(job, context);
        } else if (scheduledJobParameter instanceof Rollup) {
            RollupRunner.INSTANCE.runJob(job, context);
        } else {
            String errorMessage = "Invalid job type, found " + job.getClass().getSimpleName() + " with id: " + context.getJobId();
            logger.error(errorMessage);
            throw (Throwable)new IllegalArgumentException(errorMessage);
        }
    }

    private IndexManagementRunner() {
    }

    static {
        IndexManagementRunner indexManagementRunner;
        INSTANCE = indexManagementRunner = new IndexManagementRunner();
        logger = LogManager.getLogger(indexManagementRunner.getClass());
    }
}

