/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.indexmanagement;

import com.amazon.opendistroforelasticsearch.indexmanagement.IndexManagementIndices;
import com.amazon.opendistroforelasticsearch.indexmanagement.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import com.amazon.opendistroforelasticsearch.indexmanagement.util.IndexUtils;
import com.amazon.opendistroforelasticsearch.indexmanagement.util.OpenForTesting;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OpenForTesting
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0017\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0011\u0010\u0014\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J%\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0092@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0011H\u0016J\b\u0010!\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0018\u0010\r\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\u000f0\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/IndexManagementIndices;", "", "settings", "Lorg/elasticsearch/common/settings/Settings;", "client", "Lorg/elasticsearch/client/IndicesAdminClient;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "(Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/client/IndicesAdminClient;Lorg/elasticsearch/cluster/service/ClusterService;)V", "historyNumberOfReplicas", "", "kotlin.jvm.PlatformType", "Ljava/lang/Integer;", "historyNumberOfShards", "logger", "Lorg/apache/logging/log4j/Logger;", "attemptInitStateManagementIndex", "", "Lorg/elasticsearch/client/Client;", "(Lorg/elasticsearch/client/Client;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkAndUpdateHistoryIndex", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkAndUpdateIMConfigIndex", "", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "Lorg/elasticsearch/action/support/master/AcknowledgedResponse;", "createHistoryIndex", "index", "", "alias", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indexManagementIndexExists", "indexStateManagementIndexHistoryExists", "Companion", "opendistro-index-management"})
public class IndexManagementIndices {
    private final Logger logger;
    private volatile Integer historyNumberOfShards;
    private volatile Integer historyNumberOfReplicas;
    private final IndicesAdminClient client;
    private final ClusterService clusterService;
    @NotNull
    public static final String HISTORY_INDEX_BASE = ".opendistro-ism-managed-index-history";
    @NotNull
    public static final String HISTORY_WRITE_INDEX_ALIAS = ".opendistro-ism-managed-index-history-write";
    @NotNull
    public static final String HISTORY_INDEX_PATTERN = "<.opendistro-ism-managed-index-history-{now/d{yyyy.MM.dd}}-1>";
    @NotNull
    public static final String HISTORY_ALL = ".opendistro-ism-managed-index-history*";
    @NotNull
    private static final String indexManagementMappings;
    @NotNull
    private static final String indexStateManagementHistoryMappings;
    @NotNull
    private static final String rollupTargetMappings;
    public static final Companion Companion;

    public void checkAndUpdateIMConfigIndex(@NotNull ActionListener<AcknowledgedResponse> actionListener) {
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        if (!this.indexManagementIndexExists()) {
            CreateIndexRequest indexRequest = new CreateIndexRequest(".opendistro-ism-config").mapping("_doc", indexManagementMappings, XContentType.JSON).settings(Settings.builder().put("index.hidden", true).build());
            this.client.create(indexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(actionListener){
                final /* synthetic */ ActionListener $actionListener;

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    this.$actionListener.onFailure(e);
                }

                public void onResponse(@NotNull CreateIndexResponse response2) {
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    this.$actionListener.onResponse((Object)response2);
                }
                {
                    this.$actionListener = $captured_local_variable$0;
                }
            });
        } else {
            ClusterState clusterState = this.clusterService.state();
            Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterService.state()");
            IndexUtils.Companion.checkAndUpdateConfigIndexMapping(clusterState, this.client, actionListener);
        }
    }

    public boolean indexManagementIndexExists() {
        ClusterState clusterState = this.clusterService.state();
        Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterService.state()");
        return clusterState.getRoutingTable().hasIndex(".opendistro-ism-config");
    }

    @Nullable
    public Object attemptInitStateManagementIndex(@NotNull Client client, @NotNull Continuation<? super Boolean> $completion) {
        return IndexManagementIndices.attemptInitStateManagementIndex$suspendImpl(this, client, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object attemptInitStateManagementIndex$suspendImpl(IndexManagementIndices this, Client client, Continuation $completion) {
        if (!($completion instanceof attemptInitStateManagementIndex.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ IndexManagementIndices this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexManagementIndices.attemptInitStateManagementIndex$suspendImpl(this.this$0, null, (Continuation)this);
                }
                {
                    this.this$0 = indexManagementIndices;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.indexManagementIndexExists()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = client;
                $continuation.label = 1;
                v0 = ElasticExtensionsKt.suspendUntil((ElasticsearchClient)client, (Function2)new Function2<Client, ActionListener<AcknowledgedResponse>, Unit>(this){
                    final /* synthetic */ IndexManagementIndices this$0;

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$suspendUntil, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        this.this$0.checkAndUpdateIMConfigIndex(it);
                    }
                    {
                        this.this$0 = indexManagementIndices;
                        super(2);
                    }
                }, $continuation);
                ** if (v0 != var7_5) goto lbl22
lbl21:
                // 1 sources

                return var7_5;
lbl22:
                // 1 sources

                ** GOTO lbl30
            }
            case 1: {
                client = (Client)$continuation.L$1;
                this = (IndexManagementIndices)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    if ((response = (AcknowledgedResponse)v0).isAcknowledged()) {
                        return Boxing.boxBoolean((boolean)true);
                    }
                    this.logger.error("Creating .opendistro-ism-config with mappings NOT acknowledged");
                    return Boxing.boxBoolean((boolean)false);
                }
                catch (ResourceAlreadyExistsException e) {
                    var3_7 = true;
                }
                catch (Exception e) {
                    this.logger.error("Error trying to create .opendistro-ism-config", (Throwable)e);
                    var3_7 = false;
                }
                return Boxing.boxBoolean((boolean)var3_7);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public boolean indexStateManagementIndexHistoryExists() {
        ClusterState clusterState = this.clusterService.state();
        Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterService.state()");
        return clusterState.getMetadata().hasAlias(HISTORY_WRITE_INDEX_ALIAS);
    }

    @Nullable
    public Object checkAndUpdateHistoryIndex(@NotNull Continuation<? super Boolean> $completion) {
        return IndexManagementIndices.checkAndUpdateHistoryIndex$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object checkAndUpdateHistoryIndex$suspendImpl(IndexManagementIndices this, Continuation $completion) {
        if (!($completion instanceof checkAndUpdateHistoryIndex.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ IndexManagementIndices this$0;
                Object L$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexManagementIndices.checkAndUpdateHistoryIndex$suspendImpl(this.this$0, (Continuation)this);
                }
                {
                    this.this$0 = indexManagementIndices;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.indexStateManagementIndexHistoryExists()) break;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.createHistoryIndex("<.opendistro-ism-managed-index-history-{now/d{yyyy.MM.dd}}-1>", ".opendistro-ism-managed-index-history-write", (Continuation<? super Boolean>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (IndexManagementIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                return v0;
            }
        }
        $continuation.L$0 = this;
        $continuation.label = 2;
        v1 = ElasticExtensionsKt.suspendUntil((ElasticsearchClient)this.client, (Function2)new Function2<IndicesAdminClient, ActionListener<AcknowledgedResponse>, Unit>(this){
            final /* synthetic */ IndexManagementIndices this$0;

            public final void invoke(@NotNull IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$suspendUntil, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                ClusterState clusterState = IndexManagementIndices.access$getClusterService$p(this.this$0).state();
                Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterService.state()");
                IndexUtils.Companion.checkAndUpdateHistoryIndexMapping(clusterState, IndexManagementIndices.access$getClient$p(this.this$0), it);
            }
            {
                this.this$0 = indexManagementIndices;
                super(2);
            }
        }, $continuation);
        if (v1 == var5_4) {
            return var5_4;
        }
        ** GOTO lbl34
        {
            case 2: {
                this = (IndexManagementIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl34:
                // 2 sources

                if ((response = (AcknowledgedResponse)v1).isAcknowledged()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                this.logger.error("Updating .opendistro-ism-managed-index-history-write with new mappings NOT acknowledged");
                return Boxing.boxBoolean((boolean)false);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    /* synthetic */ Object createHistoryIndex(@NotNull String index, @Nullable String alias, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof createHistoryIndex.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ IndexManagementIndices this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createHistoryIndex(null, null, (Continuation<? super Boolean>)this);
                }
                {
                    this.this$0 = indexManagementIndices;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = index;
                $continuation.L$2 = alias;
                $continuation.label = 1;
                v0 = ElasticExtensionsKt.suspendUntil((ElasticsearchClient)this.client, (Function2)new Function2<IndicesAdminClient, ActionListener<IndicesExistsResponse>, Unit>(this, index){
                    final /* synthetic */ IndexManagementIndices this$0;
                    final /* synthetic */ String $index;

                    public final void invoke(@NotNull IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<IndicesExistsResponse> it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$suspendUntil, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        IndexManagementIndices.access$getClient$p(this.this$0).exists((IndicesExistsRequest)new IndicesExistsRequest(new String[]{this.$index}).local(true), it);
                    }
                    {
                        this.this$0 = indexManagementIndices;
                        this.$index = string;
                        super(2);
                    }
                }, $continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                alias = (String)$continuation.L$2;
                index = (String)$continuation.L$1;
                this = (IndexManagementIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if ((existsResponse = (IndicesExistsResponse)v0).isExists()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                v1 = new CreateIndexRequest(index).mapping("_doc", IndexManagementIndices.indexStateManagementHistoryMappings, XContentType.JSON);
                v2 = Settings.builder().put("index.hidden", true);
                v3 = this.historyNumberOfShards;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"historyNumberOfShards");
                v4 = v2.put("index.number_of_shards", v3.intValue());
                v5 = this.historyNumberOfReplicas;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"historyNumberOfReplicas");
                request = v1.settings(v4.put("index.number_of_replicas", v5.intValue()).build());
                if (alias != null) {
                    request.alias(new Alias(alias));
                }
                $continuation.L$0 = this;
                $continuation.L$1 = index;
                $continuation.L$2 = alias;
                $continuation.L$3 = existsResponse;
                $continuation.L$4 = request;
                $continuation.label = 2;
                v6 = ElasticExtensionsKt.suspendUntil((ElasticsearchClient)this.client, (Function2)new Function2<IndicesAdminClient, ActionListener<CreateIndexResponse>, Unit>(this, request){
                    final /* synthetic */ IndexManagementIndices this$0;
                    final /* synthetic */ CreateIndexRequest $request;

                    public final void invoke(@NotNull IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<CreateIndexResponse> it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$suspendUntil, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        IndexManagementIndices.access$getClient$p(this.this$0).create(this.$request, it);
                    }
                    {
                        this.this$0 = indexManagementIndices;
                        this.$request = createIndexRequest;
                        super(2);
                    }
                }, $continuation);
                ** if (v6 != var10_6) goto lbl50
lbl49:
                // 1 sources

                return var10_6;
lbl50:
                // 1 sources

                ** GOTO lbl61
            }
            case 2: {
                request = (CreateIndexRequest)$continuation.L$4;
                existsResponse = (IndicesExistsResponse)$continuation.L$3;
                alias = (String)$continuation.L$2;
                index = (String)$continuation.L$1;
                this = (IndexManagementIndices)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl61:
                    // 2 sources

                    if ((createIndexResponse = (CreateIndexResponse)v6).isAcknowledged()) {
                        v7 = true;
                    } else {
                        this.logger.error("Creating " + index + " with mappings NOT acknowledged");
                        v7 = false;
                    }
                    var6_12 = v7;
                }
                catch (ResourceAlreadyExistsException e) {
                    var6_12 = true;
                }
                catch (Exception e) {
                    this.logger.error("Error trying to create " + index, (Throwable)e);
                    var6_12 = false;
                }
                return Boxing.boxBoolean((boolean)var6_12);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object createHistoryIndex$default(IndexManagementIndices indexManagementIndices, String string, String string2, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createHistoryIndex");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return indexManagementIndices.createHistoryIndex(string, string2, (Continuation<? super Boolean>)continuation);
    }

    public IndexManagementIndices(@NotNull Settings settings, @NotNull IndicesAdminClient client, @NotNull ClusterService clusterService) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        this.client = client;
        this.clusterService = clusterService;
        this.logger = LogManager.getLogger(this.getClass());
        this.historyNumberOfShards = (Integer)ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_SHARDS().get(settings);
        this.historyNumberOfReplicas = (Integer)ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_REPLICAS().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_SHARDS(), (Consumer)new Consumer<Integer>(){

            @Override
            public final void accept(Integer it) {
                historyNumberOfShards = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_REPLICAS(), (Consumer)new Consumer<Integer>(){

            @Override
            public final void accept(Integer it) {
                historyNumberOfReplicas = it;
            }
        });
    }

    static {
        Companion = new Companion(null);
        URL uRL = IndexManagementIndices.class.getClassLoader().getResource("mappings/opendistro-ism-config.json");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"IndexManagementIndices::\u2026ndistro-ism-config.json\")");
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        boolean bl2 = false;
        boolean bl3 = false;
        indexManagementMappings = new String(byArray, charset);
        URL uRL3 = IndexManagementIndices.class.getClassLoader().getResource("mappings/opendistro-ism-history.json");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL3, (String)"IndexManagementIndices::\u2026distro-ism-history.json\")");
        uRL2 = uRL3;
        charset = Charsets.UTF_8;
        bl = false;
        byArray = TextStreamsKt.readBytes((URL)uRL2);
        bl2 = false;
        bl3 = false;
        indexStateManagementHistoryMappings = new String(byArray, charset);
        URL uRL4 = IndexManagementIndices.class.getClassLoader().getResource("mappings/opendistro-rollup-target.json");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL4, (String)"IndexManagementIndices::\u2026stro-rollup-target.json\")");
        uRL2 = uRL4;
        charset = Charsets.UTF_8;
        bl = false;
        byArray = TextStreamsKt.readBytes((URL)uRL2);
        bl2 = false;
        bl3 = false;
        rollupTargetMappings = new String(byArray, charset);
    }

    public static final /* synthetic */ ClusterService access$getClusterService$p(IndexManagementIndices $this) {
        return $this.clusterService;
    }

    public static final /* synthetic */ IndicesAdminClient access$getClient$p(IndexManagementIndices $this) {
        return $this.client;
    }

    public static final /* synthetic */ Integer access$getHistoryNumberOfShards$p(IndexManagementIndices $this) {
        return $this.historyNumberOfShards;
    }

    public static final /* synthetic */ Integer access$getHistoryNumberOfReplicas$p(IndexManagementIndices $this) {
        return $this.historyNumberOfReplicas;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/amazon/opendistroforelasticsearch/indexmanagement/IndexManagementIndices$Companion;", "", "()V", "HISTORY_ALL", "", "HISTORY_INDEX_BASE", "HISTORY_INDEX_PATTERN", "HISTORY_WRITE_INDEX_ALIAS", "indexManagementMappings", "getIndexManagementMappings", "()Ljava/lang/String;", "indexStateManagementHistoryMappings", "getIndexStateManagementHistoryMappings", "rollupTargetMappings", "getRollupTargetMappings", "opendistro-index-management"})
    public static final class Companion {
        @NotNull
        public final String getIndexManagementMappings() {
            return indexManagementMappings;
        }

        @NotNull
        public final String getIndexStateManagementHistoryMappings() {
            return indexStateManagementHistoryMappings;
        }

        @NotNull
        public final String getRollupTargetMappings() {
            return rollupTargetMappings;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

