/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.search.asynchronous.transport;

import com.amazon.opendistroforelasticsearch.commons.authuser.User;
import com.amazon.opendistroforelasticsearch.search.asynchronous.context.AsynchronousSearchContext;
import com.amazon.opendistroforelasticsearch.search.asynchronous.id.AsynchronousSearchId;
import com.amazon.opendistroforelasticsearch.search.asynchronous.listener.AsynchronousSearchProgressListener;
import com.amazon.opendistroforelasticsearch.search.asynchronous.listener.AsynchronousSearchTimeoutWrapper;
import com.amazon.opendistroforelasticsearch.search.asynchronous.listener.PrioritizedActionListener;
import com.amazon.opendistroforelasticsearch.search.asynchronous.request.GetAsynchronousSearchRequest;
import com.amazon.opendistroforelasticsearch.search.asynchronous.response.AsynchronousSearchResponse;
import com.amazon.opendistroforelasticsearch.search.asynchronous.service.AsynchronousSearchService;
import com.amazon.opendistroforelasticsearch.search.asynchronous.transport.TransportAsynchronousSearchRoutingAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetAsynchronousSearchAction
extends TransportAsynchronousSearchRoutingAction<GetAsynchronousSearchRequest, AsynchronousSearchResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGetAsynchronousSearchAction.class);
    private final ThreadPool threadPool;
    private final AsynchronousSearchService asynchronousSearchService;

    @Inject
    public TransportGetAsynchronousSearchAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, AsynchronousSearchService asynchronousSearchService, Client client) {
        super(transportService, clusterService, threadPool, client, "cluster:admin/opendistro/asynchronous_search/get", actionFilters, asynchronousSearchService, GetAsynchronousSearchRequest::new, AsynchronousSearchResponse::new);
        this.threadPool = threadPool;
        this.asynchronousSearchService = asynchronousSearchService;
    }

    @Override
    public void handleRequest(AsynchronousSearchId asynchronousSearchId, GetAsynchronousSearchRequest request, ActionListener<AsynchronousSearchResponse> listener, User user) {
        try {
            boolean updateNeeded;
            boolean bl = updateNeeded = request.getKeepAlive() != null;
            if (updateNeeded) {
                this.asynchronousSearchService.updateKeepAliveAndGetContext(request.getId(), request.getKeepAlive(), asynchronousSearchId.getAsynchronousSearchContextId(), user, (ActionListener<AsynchronousSearchContext>)ActionListener.wrap(context -> this.handleWaitForCompletion((AsynchronousSearchContext)context, request, listener), e -> {
                    logger.debug(() -> new ParameterizedMessage("Unable to update and get asynchronous search request [{}]", (Object)asynchronousSearchId), (Throwable)e);
                    listener.onFailure(e);
                }));
            } else {
                this.asynchronousSearchService.findContext(request.getId(), asynchronousSearchId.getAsynchronousSearchContextId(), user, (ActionListener<AsynchronousSearchContext>)ActionListener.wrap(context -> this.handleWaitForCompletion((AsynchronousSearchContext)context, request, listener), e -> {
                    logger.debug(() -> new ParameterizedMessage("Unable to get asynchronous search [{}]", (Object)asynchronousSearchId), (Throwable)e);
                    listener.onFailure(e);
                }));
            }
        }
        catch (Exception e2) {
            logger.error(() -> new ParameterizedMessage("Unable to update and get asynchronous search [{}]", (Object)request.getId()), (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private void handleWaitForCompletion(AsynchronousSearchContext context, GetAsynchronousSearchRequest request, ActionListener<AsynchronousSearchResponse> listener) {
        if (context.isRunning() && request.getWaitForCompletionTimeout() != null) {
            logger.debug("Context is running for asynchronous search id [{}]", (Object)context.getAsynchronousSearchId());
            AsynchronousSearchProgressListener progressActionListener = context.getAsynchronousSearchProgressListener();
            assert (progressActionListener != null) : "progress listener cannot be null";
            PrioritizedActionListener<AsynchronousSearchResponse> wrappedListener = AsynchronousSearchTimeoutWrapper.wrapScheduledTimeout(this.threadPool, request.getWaitForCompletionTimeout(), "opendistro_asynchronous_search_generic", listener, actionListener -> {
                progressActionListener.searchProgressActionListener().removeListener((ActionListener<AsynchronousSearchResponse>)actionListener);
                listener.onResponse((Object)context.getAsynchronousSearchResponse());
            });
            progressActionListener.searchProgressActionListener().addOrExecuteListener(wrappedListener);
        } else {
            logger.debug("Context is not running for asynchronous search id [{}]", (Object)context.getAsynchronousSearchId());
            listener.onResponse((Object)context.getAsynchronousSearchResponse());
        }
    }
}

