/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.search.asynchronous.transport;

import com.amazon.opendistroforelasticsearch.commons.authuser.User;
import com.amazon.opendistroforelasticsearch.search.asynchronous.id.AsynchronousSearchId;
import com.amazon.opendistroforelasticsearch.search.asynchronous.request.DeleteAsynchronousSearchRequest;
import com.amazon.opendistroforelasticsearch.search.asynchronous.response.AcknowledgedResponse;
import com.amazon.opendistroforelasticsearch.search.asynchronous.service.AsynchronousSearchService;
import com.amazon.opendistroforelasticsearch.search.asynchronous.transport.TransportAsynchronousSearchRoutingAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteAsynchronousSearchAction
extends TransportAsynchronousSearchRoutingAction<DeleteAsynchronousSearchRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportAsynchronousSearchRoutingAction.class);
    private final AsynchronousSearchService asynchronousSearchService;

    @Inject
    public TransportDeleteAsynchronousSearchAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, AsynchronousSearchService asynchronousSearchService, Client client) {
        super(transportService, clusterService, threadPool, client, "cluster:admin/opendistro/asynchronous_search/delete", actionFilters, asynchronousSearchService, DeleteAsynchronousSearchRequest::new, AcknowledgedResponse::new);
        this.asynchronousSearchService = asynchronousSearchService;
    }

    @Override
    public void handleRequest(AsynchronousSearchId asynchronousSearchId, DeleteAsynchronousSearchRequest request, ActionListener<AcknowledgedResponse> listener, User user) {
        try {
            this.asynchronousSearchService.freeContext(request.getId(), asynchronousSearchId.getAsynchronousSearchContextId(), user, (ActionListener<Boolean>)ActionListener.wrap(complete -> listener.onResponse((Object)new AcknowledgedResponse((boolean)complete)), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("Unable to delete asynchronous search [{}]", (Object)request.getId()), (Throwable)e);
            listener.onFailure(e);
        }
    }
}

