/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.search.asynchronous.transport;

import com.amazon.opendistroforelasticsearch.commons.authuser.User;
import com.amazon.opendistroforelasticsearch.search.asynchronous.id.AsynchronousSearchId;
import com.amazon.opendistroforelasticsearch.search.asynchronous.id.AsynchronousSearchIdConverter;
import com.amazon.opendistroforelasticsearch.search.asynchronous.request.AsynchronousSearchRoutingRequest;
import com.amazon.opendistroforelasticsearch.search.asynchronous.service.AsynchronousSearchService;
import com.amazon.opendistroforelasticsearch.search.asynchronous.utils.AsynchronousSearchExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public abstract class TransportAsynchronousSearchRoutingAction<Request extends AsynchronousSearchRoutingRequest<Request>, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    private static final Logger logger = LogManager.getLogger(TransportAsynchronousSearchRoutingAction.class);
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final Writeable.Reader<Response> responseReader;
    private final String actionName;
    private final ThreadPool threadPool;
    private final Client client;
    private final AsynchronousSearchService asynchronousSearchService;

    public TransportAsynchronousSearchRoutingAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Client client, String actionName, ActionFilters actionFilters, AsynchronousSearchService asynchronousSearchService, Writeable.Reader<Request> requestReader, Writeable.Reader<Response> responseReader) {
        super(actionName, transportService, actionFilters, requestReader);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.responseReader = responseReader;
        this.actionName = actionName;
        this.threadPool = threadPool;
        this.client = client;
        this.asynchronousSearchService = asynchronousSearchService;
    }

    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        try {
            new AsyncForwardAction(this, request, listener).run();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public abstract void handleRequest(AsynchronousSearchId var1, Request var2, ActionListener<Response> var3, User var4);

    static final class AsyncForwardAction
    extends AbstractRunnable {
        private final ActionListener<Response> listener;
        private final Request request;
        private DiscoveryNode targetNode;
        private AsynchronousSearchId asynchronousSearchId;
        final /* synthetic */ TransportAsynchronousSearchRoutingAction this$0;

        AsyncForwardAction(Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            try {
                this.asynchronousSearchId = AsynchronousSearchIdConverter.parseAsyncId(((AsynchronousSearchRoutingRequest)((Object)request)).getId());
                this.request = request;
                this.listener = listener;
                this.targetNode = ((TransportAsynchronousSearchRoutingAction)this$0).clusterService.state().nodes().get(this.asynchronousSearchId.getNode());
            }
            catch (IllegalArgumentException e) {
                logger.error(() -> new ParameterizedMessage("Failed to parse asynchronous search ID [{}]", (Object)request.getId()), (Throwable)e);
                listener.onFailure((Exception)AsynchronousSearchExceptionUtils.buildResourceNotFoundException(((AsynchronousSearchRoutingRequest)((Object)request)).getId()));
                throw e;
            }
        }

        public void onFailure(Exception e) {
            logger.error(() -> new ParameterizedMessage("Failed to dispatch request for action [{}] for asynchronous search [{}]", (Object)this.this$0.actionName, (Object)((AsynchronousSearchRoutingRequest)((Object)((Object)this.request))).getId()), (Throwable)e);
            this.sendLocalRequest(this.asynchronousSearchId, this.request, this.listener);
        }

        protected void doRun() {
            ClusterState state = this.this$0.clusterService.state();
            TransportRequestOptions requestOptions = TransportRequestOptions.builder().withTimeout(this.this$0.asynchronousSearchService.getMaxWaitForCompletionTimeout()).build();
            if (this.targetNode != null && !state.nodes().getLocalNode().equals((Object)this.targetNode) && state.nodes().nodeExists(this.targetNode)) {
                logger.debug("Forwarding asynchronous search id [{}] request to target node [{}]", (Object)((AsynchronousSearchRoutingRequest)((Object)this.request)).getId(), (Object)this.targetNode);
                this.this$0.transportService.sendRequest(this.targetNode, this.this$0.actionName, this.request, requestOptions, (TransportResponseHandler)new ActionListenerResponseHandler<Response>(this.listener, this.this$0.responseReader){

                    public void handleException(TransportException exp) {
                        Throwable cause = exp.unwrapCause();
                        if (cause instanceof ConnectTransportException || exp instanceof RemoteTransportException && cause instanceof NodeClosedException) {
                            logger.debug("Connection exception while trying to forward request with id[{}] to target node [{}] Error: [{}]", (Object)AsyncForwardAction.this.request.getId(), (Object)AsyncForwardAction.this.targetNode, (Object)exp.getDetailedMessage());
                            AsyncForwardAction.this.sendLocalRequest(AsyncForwardAction.this.asynchronousSearchId, (Object)((Object)AsyncForwardAction.this.request), (ActionListener)AsyncForwardAction.this.listener);
                        } else {
                            logger.debug("Exception received for request with id[{}] to from target node [{}],  Error: [{}]", (Object)AsyncForwardAction.this.request.getId(), (Object)AsyncForwardAction.this.targetNode, (Object)exp.getDetailedMessage());
                            AsyncForwardAction.this.listener.onFailure(cause instanceof Exception ? (Exception)cause : new NotSerializableExceptionWrapper(cause));
                        }
                    }

                    public void handleResponse(Response response) {
                        logger.debug("Received the response for asynchronous search id [{}] from target node [{}]", (Object)AsyncForwardAction.this.request.getId(), (Object)AsyncForwardAction.this.targetNode);
                        AsyncForwardAction.this.listener.onResponse(response);
                    }
                });
            } else {
                this.sendLocalRequest(this.asynchronousSearchId, this.request, this.listener);
            }
        }

        private void sendLocalRequest(AsynchronousSearchId asynchronousSearchId, Request request, ActionListener<Response> listener) {
            ThreadContext threadContext = this.this$0.threadPool.getThreadContext();
            String userStr = (String)threadContext.getTransient("_opendistro_security_user_info");
            User user = User.parse((String)userStr);
            try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
                this.this$0.handleRequest(asynchronousSearchId, request, listener, user);
            }
        }
    }
}

