/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.search.asynchronous.stats;

import com.amazon.opendistroforelasticsearch.search.asynchronous.context.AsynchronousSearchContextId;
import com.amazon.opendistroforelasticsearch.search.asynchronous.listener.AsynchronousSearchContextEventListener;
import com.amazon.opendistroforelasticsearch.search.asynchronous.stats.AsynchronousSearchCountStats;
import com.amazon.opendistroforelasticsearch.search.asynchronous.stats.AsynchronousSearchStats;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.metrics.CounterMetric;

public class InternalAsynchronousSearchStats
implements AsynchronousSearchContextEventListener {
    private final CountStatsHolder countStatsHolder = new CountStatsHolder();

    @Override
    public void onContextFailed(AsynchronousSearchContextId contextId) {
        this.countStatsHolder.failedAsynchronousSearchCount.inc();
        this.countStatsHolder.runningAsynchronousSearchCount.dec();
    }

    @Override
    public void onContextPersisted(AsynchronousSearchContextId asynchronousSearchContextId) {
        this.countStatsHolder.persistedAsynchronousSearchCount.inc();
    }

    @Override
    public void onContextPersistFailed(AsynchronousSearchContextId contextId) {
        this.countStatsHolder.persistFailedAsynchronousSearchCount.inc();
    }

    @Override
    public void onContextRunning(AsynchronousSearchContextId context) {
        this.countStatsHolder.runningAsynchronousSearchCount.inc();
    }

    @Override
    public void onContextRejected(AsynchronousSearchContextId contextId) {
        this.countStatsHolder.rejectedAsynchronousSearchCount.inc();
    }

    @Override
    public void onNewContext(AsynchronousSearchContextId contextId) {
        this.countStatsHolder.submittedAsynchronousSearchCount.inc();
    }

    @Override
    public void onContextCancelled(AsynchronousSearchContextId contextId) {
        this.countStatsHolder.cancelledAsynchronousSearchCount.inc();
    }

    @Override
    public void onContextInitialized(AsynchronousSearchContextId contextId) {
        this.countStatsHolder.initializedAsynchronousSearchCount.inc();
    }

    @Override
    public void onRunningContextDeleted(AsynchronousSearchContextId contextId) {
        this.countStatsHolder.runningAsynchronousSearchCount.dec();
    }

    @Override
    public void onContextCompleted(AsynchronousSearchContextId context) {
        this.countStatsHolder.completedAsynchronousSearchCount.inc();
        this.countStatsHolder.runningAsynchronousSearchCount.dec();
    }

    public AsynchronousSearchStats stats(DiscoveryNode node) {
        return new AsynchronousSearchStats(node, this.countStatsHolder.countStats());
    }

    static final class CountStatsHolder {
        final CounterMetric runningAsynchronousSearchCount = new CounterMetric();
        final CounterMetric persistedAsynchronousSearchCount = new CounterMetric();
        final CounterMetric persistFailedAsynchronousSearchCount = new CounterMetric();
        final CounterMetric failedAsynchronousSearchCount = new CounterMetric();
        final CounterMetric completedAsynchronousSearchCount = new CounterMetric();
        final CounterMetric rejectedAsynchronousSearchCount = new CounterMetric();
        final CounterMetric submittedAsynchronousSearchCount = new CounterMetric();
        final CounterMetric cancelledAsynchronousSearchCount = new CounterMetric();
        final CounterMetric initializedAsynchronousSearchCount = new CounterMetric();

        CountStatsHolder() {
        }

        public AsynchronousSearchCountStats countStats() {
            return new AsynchronousSearchCountStats(this.runningAsynchronousSearchCount.count(), this.persistedAsynchronousSearchCount.count(), this.completedAsynchronousSearchCount.count(), this.failedAsynchronousSearchCount.count(), this.rejectedAsynchronousSearchCount.count(), this.persistFailedAsynchronousSearchCount.count(), this.initializedAsynchronousSearchCount.count(), this.submittedAsynchronousSearchCount.count(), this.cancelledAsynchronousSearchCount.count());
        }
    }
}

