/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.search.asynchronous.rest;

import com.amazon.opendistroforelasticsearch.search.asynchronous.action.AsynchronousSearchStatsAction;
import com.amazon.opendistroforelasticsearch.search.asynchronous.request.AsynchronousSearchStatsRequest;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;

public class RestAsynchronousSearchStatsAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(RestAsynchronousSearchStatsAction.class);
    private static final String NAME = "asynchronous_search_stats_action";

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_asynchronous_search/_nodes/{nodeId}/stats"), new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_asynchronous_search/stats"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        AsynchronousSearchStatsRequest asynchronousSearchStatsRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)AsynchronousSearchStatsAction.INSTANCE, (ActionRequest)asynchronousSearchStatsRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    private AsynchronousSearchStatsRequest getRequest(RestRequest request) {
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        AsynchronousSearchStatsRequest asynchronousSearchStatsRequest = new AsynchronousSearchStatsRequest(nodesIds);
        asynchronousSearchStatsRequest.timeout(request.param("timeout"));
        return asynchronousSearchStatsRequest;
    }
}

