/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.search.asynchronous.response;

import com.amazon.opendistroforelasticsearch.search.asynchronous.context.state.AsynchronousSearchState;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;

public class AsynchronousSearchResponse
extends ActionResponse
implements StatusToXContentObject {
    private static final ParseField ID = new ParseField("id", new String[0]);
    private static final ParseField STATE = new ParseField("state", new String[0]);
    private static final ParseField START_TIME_IN_MILLIS = new ParseField("start_time_in_millis", new String[0]);
    private static final ParseField EXPIRATION_TIME_IN_MILLIS = new ParseField("expiration_time_in_millis", new String[0]);
    private static final ParseField RESPONSE = new ParseField("response", new String[0]);
    private static final ParseField ERROR = new ParseField("error", new String[0]);
    @Nullable
    private final String id;
    private final AsynchronousSearchState state;
    private final long startTimeMillis;
    private final long expirationTimeMillis;
    @Nullable
    private SearchResponse searchResponse;
    @Nullable
    private ElasticsearchException error;

    public AsynchronousSearchResponse(String id, AsynchronousSearchState state, long startTimeMillis, long expirationTimeMillis, SearchResponse searchResponse, Exception error) {
        this.id = id;
        this.state = state;
        this.startTimeMillis = startTimeMillis;
        this.expirationTimeMillis = expirationTimeMillis;
        this.searchResponse = searchResponse;
        this.error = error == null ? null : ExceptionsHelper.convertToElastic((Exception)error);
    }

    public AsynchronousSearchResponse(String id, AsynchronousSearchState state, long startTimeMillis, long expirationTimeMillis, SearchResponse searchResponse, ElasticsearchException error) {
        this.id = id;
        this.state = state;
        this.startTimeMillis = startTimeMillis;
        this.expirationTimeMillis = expirationTimeMillis;
        this.searchResponse = searchResponse;
        this.error = error;
    }

    public AsynchronousSearchResponse(AsynchronousSearchState state, long startTimeMillis, long expirationTimeMillis, SearchResponse searchResponse, ElasticsearchException error) {
        this.state = state;
        this.startTimeMillis = startTimeMillis;
        this.expirationTimeMillis = expirationTimeMillis;
        this.searchResponse = searchResponse;
        this.error = error;
        this.id = null;
    }

    public AsynchronousSearchResponse(StreamInput in) throws IOException {
        this.id = in.readOptionalString();
        this.state = (AsynchronousSearchState)in.readEnum(AsynchronousSearchState.class);
        this.startTimeMillis = in.readLong();
        this.expirationTimeMillis = in.readLong();
        this.searchResponse = (SearchResponse)in.readOptionalWriteable(SearchResponse::new);
        this.error = in.readBoolean() ? (ElasticsearchException)in.readException() : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.id);
        out.writeEnum((Enum)this.state);
        out.writeLong(this.startTimeMillis);
        out.writeLong(this.expirationTimeMillis);
        out.writeOptionalWriteable((Writeable)this.searchResponse);
        if (this.error != null) {
            out.writeBoolean(true);
            out.writeException((Throwable)this.error);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.id != null) {
            builder.field(ID.getPreferredName(), this.id);
        }
        builder.field(STATE.getPreferredName(), (Object)this.state);
        builder.field(START_TIME_IN_MILLIS.getPreferredName(), this.startTimeMillis);
        builder.field(EXPIRATION_TIME_IN_MILLIS.getPreferredName(), this.expirationTimeMillis);
        if (this.searchResponse != null) {
            builder.startObject(RESPONSE.getPreferredName());
            this.searchResponse.innerToXContent(builder, params);
            builder.endObject();
        }
        if (this.error != null) {
            builder.startObject(ERROR.getPreferredName());
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (Throwable)this.error);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public AsynchronousSearchState getState() {
        return this.state;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public SearchResponse getSearchResponse() {
        return this.searchResponse;
    }

    public ElasticsearchException getError() {
        return this.error;
    }

    public long getExpirationTimeMillis() {
        return this.expirationTimeMillis;
    }

    public String getId() {
        return this.id;
    }

    public RestStatus status() {
        return RestStatus.OK;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.startTimeMillis, this.expirationTimeMillis});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AsynchronousSearchResponse other = (AsynchronousSearchResponse)((Object)o);
        try {
            return (this.id == null && other.id == null || this.id != null && this.id.equals(other.id)) && this.state.equals((Object)other.state) && this.startTimeMillis == other.startTimeMillis && this.expirationTimeMillis == other.expirationTimeMillis && Objects.equals(this.getErrorAsMap(this.error), this.getErrorAsMap(other.error)) && Objects.equals(this.getResponseAsMap(this.searchResponse), this.getResponseAsMap(other.searchResponse));
        }
        catch (IOException e) {
            return false;
        }
    }

    private Map<String, Object> getErrorAsMap(ElasticsearchException exception) throws IOException {
        if (exception != null) {
            try (XContentBuilder builder = XContentFactory.contentBuilder((XContentType)Requests.INDEX_CONTENT_TYPE);){
                builder.startObject();
                ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (Throwable)exception);
                builder.endObject();
                BytesReference error = BytesReference.bytes((XContentBuilder)builder);
                Map map = (Map)XContentHelper.convertToMap((BytesReference)error, (boolean)false, (XContentType)Requests.INDEX_CONTENT_TYPE).v2();
                return map;
            }
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> getResponseAsMap(SearchResponse searchResponse) throws IOException {
        if (searchResponse != null) {
            BytesReference response = XContentHelper.toXContent((ToXContent)searchResponse, (XContentType)Requests.INDEX_CONTENT_TYPE, (boolean)true);
            if (response == null) {
                return Collections.emptyMap();
            }
            return (Map)XContentHelper.convertToMap((BytesReference)response, (boolean)false, (XContentType)Requests.INDEX_CONTENT_TYPE).v2();
        }
        return null;
    }

    public static AsynchronousSearchResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        parser.nextToken();
        return AsynchronousSearchResponse.innerFromXContent(parser);
    }

    public static AsynchronousSearchResponse innerFromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        String id = null;
        AsynchronousSearchState status = null;
        long startTimeMillis = -1L;
        long expirationTimeMillis = -1L;
        SearchResponse searchResponse = null;
        ElasticsearchException error = null;
        String currentFieldName = null;
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            currentFieldName = parser.currentName();
            if (RESPONSE.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.START_OBJECT) {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    searchResponse = SearchResponse.innerFromXContent((XContentParser)parser);
                }
            } else if (ERROR.match(currentFieldName, parser.getDeprecationHandler())) {
                parser.nextToken();
                error = ElasticsearchException.fromXContent((XContentParser)parser);
            } else if (token.isValue()) {
                if (ID.match(currentFieldName, parser.getDeprecationHandler())) {
                    id = parser.text();
                } else if (START_TIME_IN_MILLIS.match(currentFieldName, parser.getDeprecationHandler())) {
                    startTimeMillis = parser.longValue();
                } else if (EXPIRATION_TIME_IN_MILLIS.match(currentFieldName, parser.getDeprecationHandler())) {
                    expirationTimeMillis = parser.longValue();
                } else if (STATE.match(currentFieldName, parser.getDeprecationHandler())) {
                    status = AsynchronousSearchState.valueOf(parser.text());
                } else {
                    parser.skipChildren();
                }
            }
            token = parser.nextToken();
        }
        return new AsynchronousSearchResponse(id, status, startTimeMillis, expirationTimeMillis, searchResponse, error);
    }

    public static AsynchronousSearchResponse empty(String id, SearchResponse searchResponse, Exception exception) {
        return new AsynchronousSearchResponse(id, null, -1L, -1L, searchResponse, exception);
    }
}

