/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.search.asynchronous.processor;

import com.amazon.opendistroforelasticsearch.search.asynchronous.context.AsynchronousSearchContextId;
import com.amazon.opendistroforelasticsearch.search.asynchronous.context.active.AsynchronousSearchActiveContext;
import com.amazon.opendistroforelasticsearch.search.asynchronous.context.active.AsynchronousSearchActiveStore;
import com.amazon.opendistroforelasticsearch.search.asynchronous.context.active.AsynchronousSearchContextClosedException;
import com.amazon.opendistroforelasticsearch.search.asynchronous.context.persistence.AsynchronousSearchPersistenceModel;
import com.amazon.opendistroforelasticsearch.search.asynchronous.context.state.AsynchronousSearchState;
import com.amazon.opendistroforelasticsearch.search.asynchronous.context.state.AsynchronousSearchStateMachine;
import com.amazon.opendistroforelasticsearch.search.asynchronous.context.state.AsynchronousSearchStateMachineClosedException;
import com.amazon.opendistroforelasticsearch.search.asynchronous.context.state.event.BeginPersistEvent;
import com.amazon.opendistroforelasticsearch.search.asynchronous.context.state.event.SearchFailureEvent;
import com.amazon.opendistroforelasticsearch.search.asynchronous.context.state.event.SearchResponsePersistFailedEvent;
import com.amazon.opendistroforelasticsearch.search.asynchronous.context.state.event.SearchResponsePersistedEvent;
import com.amazon.opendistroforelasticsearch.search.asynchronous.context.state.event.SearchSuccessfulEvent;
import com.amazon.opendistroforelasticsearch.search.asynchronous.response.AsynchronousSearchResponse;
import com.amazon.opendistroforelasticsearch.search.asynchronous.service.AsynchronousSearchPersistenceService;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;

public class AsynchronousSearchPostProcessor {
    private static final Logger logger = LogManager.getLogger(AsynchronousSearchPostProcessor.class);
    private final AsynchronousSearchPersistenceService asynchronousSearchPersistenceService;
    private final AsynchronousSearchActiveStore asynchronousSearchActiveStore;
    private final AsynchronousSearchStateMachine asynchronousSearchStateMachine;
    private final Consumer<AsynchronousSearchActiveContext> freeActiveContextConsumer;
    private final ThreadPool threadPool;

    public AsynchronousSearchPostProcessor(AsynchronousSearchPersistenceService asynchronousSearchPersistenceService, AsynchronousSearchActiveStore asynchronousSearchActiveStore, AsynchronousSearchStateMachine stateMachine, Consumer<AsynchronousSearchActiveContext> freeActiveContextConsumer, ThreadPool threadPool, ClusterService clusterService) {
        this.asynchronousSearchActiveStore = asynchronousSearchActiveStore;
        this.asynchronousSearchPersistenceService = asynchronousSearchPersistenceService;
        this.asynchronousSearchStateMachine = stateMachine;
        this.freeActiveContextConsumer = freeActiveContextConsumer;
        this.threadPool = threadPool;
    }

    public AsynchronousSearchResponse processSearchFailure(Exception exception, AsynchronousSearchContextId asynchronousSearchContextId) {
        Optional<AsynchronousSearchActiveContext> asynchronousSearchContextOptional = this.asynchronousSearchActiveStore.getContext(asynchronousSearchContextId);
        try {
            if (asynchronousSearchContextOptional.isPresent()) {
                AsynchronousSearchActiveContext asynchronousSearchContext = asynchronousSearchContextOptional.get();
                this.asynchronousSearchStateMachine.trigger(new SearchFailureEvent(asynchronousSearchContext, exception));
                this.handlePersist(asynchronousSearchContext);
                return asynchronousSearchContext.getAsynchronousSearchResponse();
            }
            return new AsynchronousSearchResponse(AsynchronousSearchState.FAILED, -1L, -1L, null, ExceptionsHelper.convertToElastic((Exception)exception));
        }
        catch (AsynchronousSearchStateMachineClosedException ex) {
            return new AsynchronousSearchResponse(AsynchronousSearchState.FAILED, -1L, -1L, null, ExceptionsHelper.convertToElastic((Exception)exception));
        }
    }

    public AsynchronousSearchResponse processSearchResponse(SearchResponse searchResponse, AsynchronousSearchContextId asynchronousSearchContextId) {
        Optional<AsynchronousSearchActiveContext> asynchronousSearchContextOptional = this.asynchronousSearchActiveStore.getContext(asynchronousSearchContextId);
        try {
            if (asynchronousSearchContextOptional.isPresent()) {
                AsynchronousSearchActiveContext asynchronousSearchContext = asynchronousSearchContextOptional.get();
                this.asynchronousSearchStateMachine.trigger(new SearchSuccessfulEvent(asynchronousSearchContext, searchResponse));
                this.handlePersist(asynchronousSearchContext);
                return asynchronousSearchContext.getAsynchronousSearchResponse();
            }
            return new AsynchronousSearchResponse(AsynchronousSearchState.SUCCEEDED, -1L, -1L, searchResponse, null);
        }
        catch (AsynchronousSearchStateMachineClosedException ex) {
            return new AsynchronousSearchResponse(AsynchronousSearchState.SUCCEEDED, -1L, -1L, searchResponse, null);
        }
    }

    public void persistResponse(AsynchronousSearchActiveContext asynchronousSearchContext, AsynchronousSearchPersistenceModel persistenceModel) {
        asynchronousSearchContext.acquireAllContextPermits((ActionListener<Releasable>)ActionListener.wrap(releasable -> {
            if (!asynchronousSearchContext.shouldPersist()) {
                logger.debug("Async search context [{}] has been closed while waiting to acquire permits for post processing", (Object)asynchronousSearchContext.getAsynchronousSearchId());
                releasable.close();
                return;
            }
            logger.debug("Persisting response for asynchronous search id [{}]", (Object)asynchronousSearchContext.getAsynchronousSearchId());
            try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
                this.asynchronousSearchPersistenceService.storeResponse(asynchronousSearchContext.getAsynchronousSearchId(), persistenceModel, (ActionListener<IndexResponse>)ActionListener.runAfter((ActionListener)ActionListener.wrap(indexResponse -> {
                    logger.debug("Successfully persisted response for asynchronous search id [{}]", (Object)asynchronousSearchContext.getAsynchronousSearchId());
                    try {
                        this.asynchronousSearchStateMachine.trigger(new SearchResponsePersistedEvent(asynchronousSearchContext));
                    }
                    catch (AsynchronousSearchStateMachineClosedException ex) {
                        logger.warn("Unexpected state, possibly caused by external task cancellation, context with id [{}] closed while triggering event [{}]", (Object)asynchronousSearchContext.getAsynchronousSearchId(), (Object)SearchResponsePersistedEvent.class.getName());
                    }
                    finally {
                        this.freeActiveContextConsumer.accept(asynchronousSearchContext);
                    }
                }, e -> {
                    try {
                        this.asynchronousSearchStateMachine.trigger(new SearchResponsePersistFailedEvent(asynchronousSearchContext));
                    }
                    catch (AsynchronousSearchStateMachineClosedException ex) {
                        logger.warn("Unexpected state, possibly caused by external task cancellation, context with id [{}] closed while triggering event [{}]", (Object)asynchronousSearchContext.getAsynchronousSearchId(), (Object)SearchResponsePersistFailedEvent.class.getName());
                    }
                    finally {
                        this.freeActiveContextConsumer.accept(asynchronousSearchContext);
                    }
                    logger.error(() -> new ParameterizedMessage("Failed to persist final response for [{}] due to [{}]", (Object)asynchronousSearchContext.getAsynchronousSearchId(), e));
                }), () -> ((Releasable)releasable).close()));
            }
        }, e -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            Level level = cause instanceof AsynchronousSearchContextClosedException || cause instanceof TimeoutException ? Level.DEBUG : Level.WARN;
            logger.log(level, () -> new ParameterizedMessage("Exception  occured while acquiring the permit for asynchronousSearchContext [{}]", (Object)asynchronousSearchContext.getAsynchronousSearchId()), (Throwable)e);
            this.freeActiveContextConsumer.accept(asynchronousSearchContext);
        }), TimeValue.timeValueSeconds((long)120L), "persisting response");
    }

    private void handlePersist(AsynchronousSearchActiveContext asynchronousSearchContext) {
        if (asynchronousSearchContext.shouldPersist()) {
            try {
                this.asynchronousSearchStateMachine.trigger(new BeginPersistEvent(asynchronousSearchContext));
            }
            catch (AsynchronousSearchStateMachineClosedException e) {
                this.freeActiveContextConsumer.accept(asynchronousSearchContext);
            }
        } else {
            this.freeActiveContextConsumer.accept(asynchronousSearchContext);
        }
    }
}

