/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.search.asynchronous.listener;

import com.amazon.opendistroforelasticsearch.search.asynchronous.listener.PrioritizedActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class AsynchronousSearchTimeoutWrapper {
    private static final Logger logger = LogManager.getLogger(AsynchronousSearchTimeoutWrapper.class);

    public static <Response> PrioritizedActionListener<Response> wrapScheduledTimeout(ThreadPool threadPool, TimeValue timeout, String executor, ActionListener<Response> actionListener, Consumer<ActionListener<Response>> timeoutConsumer) {
        return AsynchronousSearchTimeoutWrapper.scheduleTimeout(threadPool, timeout, executor, AsynchronousSearchTimeoutWrapper.initListener(actionListener, timeoutConsumer));
    }

    public static <Response> PrioritizedActionListener<Response> initListener(ActionListener<Response> actionListener, Consumer<ActionListener<Response>> timeoutConsumer) {
        CompletionPrioritizedActionListener<Response> completionTimeoutListener = new CompletionPrioritizedActionListener<Response>(actionListener, timeoutConsumer);
        return completionTimeoutListener;
    }

    public static <Response> PrioritizedActionListener<Response> scheduleTimeout(ThreadPool threadPool, TimeValue timeout, String executor, PrioritizedActionListener<Response> completionTimeoutListener) {
        ((CompletionPrioritizedActionListener)completionTimeoutListener).cancellable = threadPool.schedule((Runnable)((Object)completionTimeoutListener), timeout, executor);
        return completionTimeoutListener;
    }

    static class CompletionPrioritizedActionListener<Response>
    implements PrioritizedActionListener<Response>,
    Runnable {
        private final ActionListener<Response> actionListener;
        private volatile Scheduler.ScheduledCancellable cancellable;
        private final AtomicBoolean complete = new AtomicBoolean(false);
        private final Consumer<ActionListener<Response>> timeoutConsumer;

        CompletionPrioritizedActionListener(ActionListener<Response> actionListener, Consumer<ActionListener<Response>> timeoutConsumer) {
            this.actionListener = actionListener;
            this.timeoutConsumer = timeoutConsumer;
        }

        void cancel() {
            if (this.cancellable != null && !this.cancellable.isCancelled()) {
                this.cancellable.cancel();
            }
        }

        @Override
        public void run() {
            this.executeImmediately();
        }

        @Override
        public void executeImmediately() {
            if (this.complete.compareAndSet(false, true)) {
                this.cancel();
                this.timeoutConsumer.accept(this);
            }
        }

        public void onResponse(Response response) {
            if (this.complete.compareAndSet(false, true)) {
                this.cancel();
                this.actionListener.onResponse(response);
            }
        }

        public void onFailure(Exception e) {
            if (this.complete.compareAndSet(false, true)) {
                this.cancel();
                this.actionListener.onFailure(e);
            }
        }
    }
}

