/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.search.asynchronous.id;

import com.amazon.opendistroforelasticsearch.search.asynchronous.context.AsynchronousSearchContextId;
import com.amazon.opendistroforelasticsearch.search.asynchronous.id.AsynchronousSearchId;
import java.io.IOException;
import java.util.Base64;
import org.apache.lucene.store.ByteArrayDataInput;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;

public class AsynchronousSearchIdConverter {
    public static String buildAsyncId(AsynchronousSearchId asynchronousSearchId) {
        String string;
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            out.writeString(asynchronousSearchId.getNode());
            out.writeString(String.valueOf(asynchronousSearchId.getTaskId()));
            out.writeString(asynchronousSearchId.getAsynchronousSearchContextId().getContextId());
            out.writeString(String.valueOf(asynchronousSearchId.getAsynchronousSearchContextId().getId()));
            string = Base64.getUrlEncoder().encodeToString(BytesReference.toBytes((BytesReference)out.bytes()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot build asynchronous search id", e);
            }
        }
        out.close();
        return string;
    }

    public static AsynchronousSearchId parseAsyncId(String asynchronousSearchId) {
        try {
            byte[] bytes = Base64.getUrlDecoder().decode(asynchronousSearchId);
            ByteArrayDataInput in = new ByteArrayDataInput(bytes);
            String node = in.readString();
            long taskId = Long.parseLong(in.readString());
            String contextId = in.readString();
            long id = Long.parseLong(in.readString());
            if (in.getPosition() != bytes.length) {
                throw new IllegalArgumentException("Not all bytes were read");
            }
            return new AsynchronousSearchId(node, taskId, new AsynchronousSearchContextId(contextId, id));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse asynchronous search id", e);
        }
    }
}

