/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.search.asynchronous.context.persistence;

import com.amazon.opendistroforelasticsearch.commons.authuser.User;
import java.io.IOException;
import java.util.Base64;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class AsynchronousSearchPersistenceModel {
    private final long expirationTimeMillis;
    private final long startTimeMillis;
    private final String response;
    private final String error;
    private final User user;

    public AsynchronousSearchPersistenceModel(long startTimeMillis, long expirationTimeMillis, String response, String error, User user) {
        this.startTimeMillis = startTimeMillis;
        this.expirationTimeMillis = expirationTimeMillis;
        this.response = response;
        this.error = error;
        this.user = user;
    }

    public AsynchronousSearchPersistenceModel(long startTimeMillis, long expirationTimeMillis, SearchResponse response, Exception error, User user) throws IOException {
        this.startTimeMillis = startTimeMillis;
        this.expirationTimeMillis = expirationTimeMillis;
        this.response = this.serializeResponse(response);
        this.error = this.serializeError(error);
        this.user = user;
    }

    private String serializeResponse(SearchResponse response) throws IOException {
        if (response == null) {
            return null;
        }
        try (BytesStreamOutput out = new BytesStreamOutput();){
            Version.writeVersion((Version)Version.CURRENT, (StreamOutput)out);
            response.writeTo((StreamOutput)out);
            byte[] bytes = BytesReference.toBytes((BytesReference)out.bytes());
            String string = Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
            return string;
        }
    }

    private String serializeError(Exception error) throws IOException {
        if (error == null) {
            return null;
        }
        try (BytesStreamOutput out = new BytesStreamOutput();){
            Version.writeVersion((Version)Version.CURRENT, (StreamOutput)out);
            out.writeException((Throwable)(error instanceof ElasticsearchException ? error : new ElasticsearchException((Throwable)error)));
            byte[] bytes = BytesReference.toBytes((BytesReference)out.bytes());
            String string = Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
            return string;
        }
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public String getResponse() {
        return this.response;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getError() {
        return this.error;
    }

    public long getExpirationTimeMillis() {
        return this.expirationTimeMillis;
    }

    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsynchronousSearchPersistenceModel other = (AsynchronousSearchPersistenceModel)o;
        return this.startTimeMillis == other.startTimeMillis && this.expirationTimeMillis == other.expirationTimeMillis && (this.response == null && other.response == null || this.response != null && other.response != null && this.response.equals(other.response)) && (this.error == null && other.error == null || this.error != null && other.error != null && this.error.equals(other.error)) && (this.user == null && other.user == null || this.user != null && other.user != null && this.user.equals((Object)other.user));
    }
}

