/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.serialize;

import com.amazon.randomcutforest.AbstractForestTraversalExecutor;
import com.amazon.randomcutforest.ParallelForestTraversalExecutor;
import com.amazon.randomcutforest.SequentialForestTraversalExecutor;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class AbstractForestTraversalExecutorAdapter
implements JsonSerializer<AbstractForestTraversalExecutor>,
JsonDeserializer<AbstractForestTraversalExecutor> {
    public static final String PROPERTY_EXECUTOR_TYPE = "executor_type";
    public static final String PROPERTY_EXECUTOR = "executor";

    public JsonElement serialize(AbstractForestTraversalExecutor src, Type type, JsonSerializationContext context) {
        JsonObject executorJson = new JsonObject();
        if (src instanceof SequentialForestTraversalExecutor) {
            executorJson.addProperty(PROPERTY_EXECUTOR_TYPE, SequentialForestTraversalExecutor.class.getSimpleName());
            executorJson.add(PROPERTY_EXECUTOR, context.serialize((Object)src, SequentialForestTraversalExecutor.class));
        } else if (src instanceof ParallelForestTraversalExecutor) {
            executorJson.addProperty(PROPERTY_EXECUTOR_TYPE, ParallelForestTraversalExecutor.class.getSimpleName());
            executorJson.add(PROPERTY_EXECUTOR, context.serialize((Object)src, ParallelForestTraversalExecutor.class));
        } else {
            throw new IllegalArgumentException("Unsupported executor type " + type.getTypeName());
        }
        return executorJson;
    }

    public AbstractForestTraversalExecutor deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) {
        AbstractForestTraversalExecutor executor = null;
        JsonObject executorJson = json.getAsJsonObject();
        String executorType = executorJson.getAsJsonPrimitive(PROPERTY_EXECUTOR_TYPE).getAsString();
        if (SequentialForestTraversalExecutor.class.getSimpleName().equals(executorType)) {
            executor = (AbstractForestTraversalExecutor)ctx.deserialize(executorJson.get(PROPERTY_EXECUTOR), SequentialForestTraversalExecutor.class);
        } else if (ParallelForestTraversalExecutor.class.getSimpleName().equals(executorType)) {
            executor = (AbstractForestTraversalExecutor)ctx.deserialize(executorJson.get(PROPERTY_EXECUTOR), ParallelForestTraversalExecutor.class);
        } else {
            throw new IllegalArgumentException("Unsupported executor type " + type.getTypeName());
        }
        return executor;
    }
}

