/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.util;

import com.amazon.opendistroforelasticsearch.alerting.destination.message.BaseMessage;
import com.amazon.opendistroforelasticsearch.alerting.model.destination.Destination;
import com.amazon.opendistroforelasticsearch.alerting.util.AlertingException;
import com.amazon.opendistroforelasticsearch.commons.authuser.User;
import inet.ipaddr.IPAddressString;
import java.net.InetAddress;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.TransportChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\b\u001aJ\u0010\t\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u001a\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\r\u001a\u0018\u0010\u0011\u001a\u00020\u0001*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014\u001a\u0018\u0010\u0015\u001a\u00020\u0001*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0014\u00a8\u0006\u0018"}, d2={"checkFilterByUserBackendRoles", "", "T", "", "filterByEnabled", "user", "Lcom/amazon/opendistroforelasticsearch/commons/authuser/User;", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "checkUserFilterByPermissions", "requesterUser", "resourceUser", "resourceType", "", "resourceId", "isValidEmail", "email", "isAllowed", "Lcom/amazon/opendistroforelasticsearch/alerting/model/destination/Destination;", "allowList", "", "isHostInDenylist", "Lcom/amazon/opendistroforelasticsearch/alerting/destination/message/BaseMessage;", "networks", "opendistro-alerting"})
public final class AlertingUtilsKt {
    public static final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Regex validEmailPattern = new Regex("(?:[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", RegexOption.IGNORE_CASE);
        return validEmailPattern.matches((CharSequence)email);
    }

    public static final boolean isAllowed(@NotNull Destination $this$isAllowed, @NotNull List<String> allowList) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAllowed, (String)"$this$isAllowed");
        Intrinsics.checkParameterIsNotNull(allowList, (String)"allowList");
        return allowList.contains($this$isAllowed.getType().getValue());
    }

    public static final boolean isHostInDenylist(@NotNull BaseMessage $this$isHostInDenylist, @NotNull List<String> networks) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isHostInDenylist, (String)"$this$isHostInDenylist");
        Intrinsics.checkParameterIsNotNull(networks, (String)"networks");
        URI uRI = $this$isHostInDenylist.getUri();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"this.uri");
        IPAddressString ipStr = new IPAddressString(uRI.getHost());
        for (String network : networks) {
            IPAddressString netStr = new IPAddressString(network);
            if (!netStr.contains(ipStr)) continue;
            TransportChannel.logger.error("Host: {} resolves to: {} which is in denylist: {}.", (Object)$this$isHostInDenylist.getUri().getHost(), (Object)InetAddress.getByName($this$isHostInDenylist.getUri().getHost()), (Object)netStr);
            return true;
        }
        return false;
    }

    public static final <T> boolean checkFilterByUserBackendRoles(boolean filterByEnabled, @Nullable User user, @NotNull ActionListener<T> actionListener) {
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        if (filterByEnabled) {
            if (user == null) {
                actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("Filter by user backend roles is not enabled with security disabled.", RestStatus.FORBIDDEN, new Object[0])));
                return false;
            }
            Collection collection = user.getBackendRoles();
            boolean bl = false;
            boolean bl2 = false;
            if (collection == null || collection.isEmpty()) {
                actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("User doesn't have backend roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0])));
                return false;
            }
        }
        return true;
    }

    public static final <T> boolean checkUserFilterByPermissions(boolean filterByEnabled, @Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        List requesterBackendRoles;
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
        Intrinsics.checkParameterIsNotNull((Object)resourceId, (String)"resourceId");
        if (!filterByEnabled) {
            return true;
        }
        User user = resourceUser;
        List resourceBackendRoles = user != null ? user.getBackendRoles() : null;
        User user2 = requesterUser;
        List list = requesterBackendRoles = user2 != null ? user2.getBackendRoles() : null;
        if (resourceBackendRoles == null || requesterBackendRoles == null || CollectionsKt.intersect((Iterable)resourceBackendRoles, (Iterable)requesterBackendRoles).isEmpty()) {
            actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("Do not have permissions to resource, " + resourceType + ", with id, " + resourceId, RestStatus.FORBIDDEN, new Object[0])));
            return false;
        }
        return true;
    }
}

