/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.transport;

import com.amazon.opendistroforelasticsearch.alerting.action.SearchMonitorAction;
import com.amazon.opendistroforelasticsearch.alerting.action.SearchMonitorRequest;
import com.amazon.opendistroforelasticsearch.alerting.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.alerting.settings.AlertingSettings;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportSearchMonitorActionKt;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportSearchMonitorActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0;
import com.amazon.opendistroforelasticsearch.alerting.util.AlertingException;
import com.amazon.opendistroforelasticsearch.commons.authuser.User;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B/\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0014J&\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00022\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u001c\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportSearchMonitorAction;", "Lorg/elasticsearch/action/support/HandledTransportAction;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/SearchMonitorRequest;", "Lorg/elasticsearch/action/search/SearchResponse;", "transportService", "Lorg/elasticsearch/transport/TransportService;", "settings", "Lorg/elasticsearch/common/settings/Settings;", "client", "Lorg/elasticsearch/client/Client;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "actionFilters", "Lorg/elasticsearch/action/support/ActionFilters;", "(Lorg/elasticsearch/transport/TransportService;Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/cluster/service/ClusterService;Lorg/elasticsearch/action/support/ActionFilters;)V", "getClient", "()Lorg/elasticsearch/client/Client;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "getSettings", "()Lorg/elasticsearch/common/settings/Settings;", "doExecute", "", "task", "Lorg/elasticsearch/tasks/Task;", "searchMonitorRequest", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "resolve", "user", "Lcom/amazon/opendistroforelasticsearch/commons/authuser/User;", "search", "searchRequest", "Lorg/elasticsearch/action/search/SearchRequest;", "opendistro-alerting"})
public final class TransportSearchMonitorAction
extends HandledTransportAction<SearchMonitorRequest, SearchResponse> {
    private volatile Boolean filterByEnabled;
    @NotNull
    private final Settings settings;
    @NotNull
    private final Client client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull SearchMonitorRequest searchMonitorRequest, @NotNull ActionListener<SearchResponse> actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)((Object)searchMonitorRequest), (String)"searchMonitorRequest");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        ThreadPool threadPool = this.client.threadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadPool, (String)"client.threadPool()");
        String userStr = (String)threadPool.getThreadContext().getTransient("_opendistro_security_user_info");
        TransportSearchMonitorActionKt.access$getLog$p().debug("User and roles string from thread context: " + userStr);
        User user = User.parse((String)userStr);
        ThreadPool threadPool2 = this.client.threadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadPool2, (String)"client.threadPool()");
        AutoCloseable autoCloseable = (AutoCloseable)threadPool2.getThreadContext().stashContext();
        boolean bl = false;
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl2 = false;
            this.resolve(searchMonitorRequest, actionListener, user);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void resolve(@NotNull SearchMonitorRequest searchMonitorRequest, @NotNull ActionListener<SearchResponse> actionListener, @Nullable User user) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)searchMonitorRequest), (String)"searchMonitorRequest");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        if (user == null) {
            this.search(searchMonitorRequest.getSearchRequest(), actionListener);
        } else if (!this.filterByEnabled.booleanValue()) {
            this.search(searchMonitorRequest.getSearchRequest(), actionListener);
        } else {
            TransportSearchMonitorActionKt.access$getLog$p().info("Filtering result by: " + user.getBackendRoles());
            SearchSourceBuilder searchSourceBuilder = searchMonitorRequest.getSearchRequest().source();
            Intrinsics.checkExpressionValueIsNotNull((Object)searchSourceBuilder, (String)"searchMonitorRequest.searchRequest.source()");
            ElasticExtensionsKt.addFilter((User)user, (SearchSourceBuilder)searchSourceBuilder, (String)"monitor.user.backend_roles.keyword");
            this.search(searchMonitorRequest.getSearchRequest(), actionListener);
        }
    }

    public final void search(@NotNull SearchRequest searchRequest, @NotNull ActionListener<SearchResponse> actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)searchRequest, (String)"searchRequest");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(actionListener){
            final /* synthetic */ ActionListener $actionListener;

            public void onResponse(@NotNull SearchResponse response2) {
                Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                this.$actionListener.onResponse((Object)response2);
            }

            public void onFailure(@NotNull Exception t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
            }
            {
                this.$actionListener = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @Inject
    public TransportSearchMonitorAction(@NotNull TransportService transportService, @NotNull Settings settings, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull ActionFilters actionFilters) {
        Intrinsics.checkParameterIsNotNull((Object)transportService, (String)"transportService");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        Intrinsics.checkParameterIsNotNull((Object)actionFilters, (String)"actionFilters");
        String string = SearchMonitorAction.Companion.getNAME();
        Object object = 1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new TransportSearchMonitorActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0(function1);
        }
        super(string, transportService, actionFilters, (Writeable.Reader)object);
        this.settings = settings;
        this.client = client;
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), (Consumer)new Consumer<Boolean>(){

            @Override
            public final void accept(Boolean it) {
                filterByEnabled = it;
            }
        });
    }

    public static final /* synthetic */ Boolean access$getFilterByEnabled$p(TransportSearchMonitorAction $this) {
        return $this.filterByEnabled;
    }
}

