/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.transport;

import com.amazon.opendistroforelasticsearch.alerting.action.IndexMonitorAction;
import com.amazon.opendistroforelasticsearch.alerting.action.IndexMonitorRequest;
import com.amazon.opendistroforelasticsearch.alerting.action.IndexMonitorResponse;
import com.amazon.opendistroforelasticsearch.alerting.core.ScheduledJobIndices;
import com.amazon.opendistroforelasticsearch.alerting.core.model.Input;
import com.amazon.opendistroforelasticsearch.alerting.core.model.Schedule;
import com.amazon.opendistroforelasticsearch.alerting.core.model.ScheduledJob;
import com.amazon.opendistroforelasticsearch.alerting.core.model.SearchInput;
import com.amazon.opendistroforelasticsearch.alerting.model.Monitor;
import com.amazon.opendistroforelasticsearch.alerting.model.Trigger;
import com.amazon.opendistroforelasticsearch.alerting.model.action.Action;
import com.amazon.opendistroforelasticsearch.alerting.settings.AlertingSettings;
import com.amazon.opendistroforelasticsearch.alerting.settings.DestinationSettings;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportIndexMonitorActionKt;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportIndexMonitorActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0;
import com.amazon.opendistroforelasticsearch.alerting.util.AlertingException;
import com.amazon.opendistroforelasticsearch.alerting.util.AlertingUtilsKt;
import com.amazon.opendistroforelasticsearch.alerting.util.AnomalyDetectionUtilsKt;
import com.amazon.opendistroforelasticsearch.alerting.util.IndexUtils;
import com.amazon.opendistroforelasticsearch.commons.authuser.User;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00016B?\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J.\u0010+\u001a\u00020,2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030.2\u0006\u0010/\u001a\u00020\u00022\b\u00100\u001a\u0004\u0018\u000101J.\u00102\u001a\u00020,2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030.2\u0006\u0010/\u001a\u00020\u00022\b\u00100\u001a\u0004\u0018\u000101J&\u00103\u001a\u00020,2\u0006\u00104\u001a\u0002052\u0006\u0010/\u001a\u00020\u00022\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030.H\u0014R\"\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0015 \u0016*\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0016\u0010\u001e\u001a\n \u0016*\u0004\u0018\u00010\u001f0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \u0016*\u0004\u0018\u00010\u001f0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\n \u0016*\u0004\u0018\u00010\"0\"X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#R\u0016\u0010$\u001a\n \u0016*\u0004\u0018\u00010\u001f0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u00067"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportIndexMonitorAction;", "Lorg/elasticsearch/action/support/HandledTransportAction;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexMonitorRequest;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexMonitorResponse;", "transportService", "Lorg/elasticsearch/transport/TransportService;", "client", "Lorg/elasticsearch/client/Client;", "actionFilters", "Lorg/elasticsearch/action/support/ActionFilters;", "scheduledJobIndices", "Lcom/amazon/opendistroforelasticsearch/alerting/core/ScheduledJobIndices;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "settings", "Lorg/elasticsearch/common/settings/Settings;", "xContentRegistry", "Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "(Lorg/elasticsearch/transport/TransportService;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/action/support/ActionFilters;Lcom/amazon/opendistroforelasticsearch/alerting/core/ScheduledJobIndices;Lorg/elasticsearch/cluster/service/ClusterService;Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;)V", "allowList", "", "", "kotlin.jvm.PlatformType", "getClient", "()Lorg/elasticsearch/client/Client;", "getClusterService", "()Lorg/elasticsearch/cluster/service/ClusterService;", "filterByEnabled", "", "Ljava/lang/Boolean;", "indexTimeout", "Lorg/elasticsearch/common/unit/TimeValue;", "maxActionThrottle", "maxMonitors", "", "Ljava/lang/Integer;", "requestTimeout", "getScheduledJobIndices", "()Lcom/amazon/opendistroforelasticsearch/alerting/core/ScheduledJobIndices;", "getSettings", "()Lorg/elasticsearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "checkAnomalyDetectorAndExecute", "", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "request", "user", "Lcom/amazon/opendistroforelasticsearch/commons/authuser/User;", "checkIndicesAndExecute", "doExecute", "task", "Lorg/elasticsearch/tasks/Task;", "IndexMonitorHandler", "opendistro-alerting"})
public final class TransportIndexMonitorAction
extends HandledTransportAction<IndexMonitorRequest, IndexMonitorResponse> {
    private volatile Integer maxMonitors;
    private volatile TimeValue requestTimeout;
    private volatile TimeValue indexTimeout;
    private volatile TimeValue maxActionThrottle;
    private volatile List<String> allowList;
    private volatile Boolean filterByEnabled;
    @NotNull
    private final Client client;
    @NotNull
    private final ScheduledJobIndices scheduledJobIndices;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;

    protected void doExecute(@NotNull Task task, @NotNull IndexMonitorRequest request, @NotNull ActionListener<IndexMonitorResponse> actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        ThreadPool threadPool = this.client.threadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadPool, (String)"client.threadPool()");
        String userStr = (String)threadPool.getThreadContext().getTransient("_opendistro_security_user_info");
        TransportIndexMonitorActionKt.access$getLog$p().debug("User and roles string from thread context: " + userStr);
        User user = User.parse((String)userStr);
        Boolean bl = this.filterByEnabled;
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"filterByEnabled");
        if (!AlertingUtilsKt.checkFilterByUserBackendRoles(bl, user, actionListener)) {
            return;
        }
        if (!AnomalyDetectionUtilsKt.isADMonitor(request.getMonitor())) {
            this.checkIndicesAndExecute(this.client, actionListener, request, user);
        } else {
            this.checkAnomalyDetectorAndExecute(this.client, actionListener, request, user);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void checkIndicesAndExecute(@NotNull Client client, @NotNull ActionListener<IndexMonitorResponse> actionListener, @NotNull IndexMonitorRequest request, @Nullable User user) {
        void $this$toTypedArray$iv;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        boolean bl = false;
        List indices = new ArrayList();
        Iterable $this$filter$iv = request.getMonitor().getInputs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            Input it = (Input)element$iv$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)it.name(), (Object)"search")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List searchInputs = (List)destination$iv$iv;
        Iterable $this$forEach$iv = searchInputs;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            Input it = (Input)element$iv;
            boolean bl3 = false;
            Input input = it;
            if (input == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.amazon.opendistroforelasticsearch.alerting.core.model.SearchInput");
            }
            SearchInput searchInput = (SearchInput)input;
            indices.addAll(searchInput.getIndices());
        }
        Collection $i$f$forEach22 = indices;
        SearchRequest searchRequest = new SearchRequest();
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        SearchRequest searchRequest2 = searchRequest.indices(Arrays.copyOf(stringArray2, stringArray2.length)).source(SearchSourceBuilder.searchSource().size(1).query((QueryBuilder)QueryBuilders.matchAllQuery()));
        client.search(searchRequest2, (ActionListener)new ActionListener<SearchResponse>(this, client, actionListener, request, user, indices){
            final /* synthetic */ TransportIndexMonitorAction this$0;
            final /* synthetic */ Client $client;
            final /* synthetic */ ActionListener $actionListener;
            final /* synthetic */ IndexMonitorRequest $request;
            final /* synthetic */ User $user;
            final /* synthetic */ List $indices;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull SearchResponse searchResponse) {
                Intrinsics.checkParameterIsNotNull((Object)searchResponse, (String)"searchResponse");
                ThreadPool threadPool = this.$client.threadPool();
                Intrinsics.checkExpressionValueIsNotNull((Object)threadPool, (String)"client.threadPool()");
                AutoCloseable autoCloseable = (AutoCloseable)threadPool.getThreadContext().stashContext();
                boolean bl = false;
                Throwable throwable = null;
                try {
                    ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                    boolean bl2 = false;
                    this.this$0.new IndexMonitorHandler(this.$client, (ActionListener<IndexMonitorResponse>)this.$actionListener, this.$request, this.$user).resolveUserAndStart();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }

            public void onFailure(@NotNull Exception t) {
                Exception exception;
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                boolean bl = t instanceof ElasticsearchSecurityException;
                if (bl) {
                    exception = (Exception)new ElasticsearchStatusException("User doesn't have read permissions for one or more configured index " + this.$indices, RestStatus.FORBIDDEN, new Object[0]);
                } else if (!bl) {
                    exception = t;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(exception));
            }
            {
                this.this$0 = $outer;
                this.$client = $captured_local_variable$1;
                this.$actionListener = $captured_local_variable$2;
                this.$request = $captured_local_variable$3;
                this.$user = $captured_local_variable$4;
                this.$indices = $captured_local_variable$5;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkAnomalyDetectorAndExecute(@NotNull Client client, @NotNull ActionListener<IndexMonitorResponse> actionListener, @NotNull IndexMonitorRequest request, @Nullable User user) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        ThreadPool threadPool = client.threadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadPool, (String)"client.threadPool()");
        AutoCloseable autoCloseable = (AutoCloseable)threadPool.getThreadContext().stashContext();
        boolean bl = false;
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl2 = false;
            new IndexMonitorHandler(client, actionListener, request, user).resolveUserAndStartForAD();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ScheduledJobIndices getScheduledJobIndices() {
        return this.scheduledJobIndices;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Inject
    public TransportIndexMonitorAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ScheduledJobIndices scheduledJobIndices, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)transportService, (String)"transportService");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkParameterIsNotNull((Object)scheduledJobIndices, (String)"scheduledJobIndices");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)xContentRegistry, (String)"xContentRegistry");
        String string = IndexMonitorAction.Companion.getNAME();
        Object object = 1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new TransportIndexMonitorActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0(function1);
        }
        super(string, transportService, actionFilters, (Writeable.Reader)object);
        this.client = client;
        this.scheduledJobIndices = scheduledJobIndices;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.maxMonitors = (Integer)AlertingSettings.Companion.getALERTING_MAX_MONITORS().get(this.settings);
        this.requestTimeout = (TimeValue)AlertingSettings.Companion.getREQUEST_TIMEOUT().get(this.settings);
        this.indexTimeout = (TimeValue)AlertingSettings.Companion.getINDEX_TIMEOUT().get(this.settings);
        this.maxActionThrottle = (TimeValue)AlertingSettings.Companion.getMAX_ACTION_THROTTLE_VALUE().get(this.settings);
        this.allowList = (List)DestinationSettings.Companion.getALLOW_LIST().get(this.settings);
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERTING_MAX_MONITORS(), (Consumer)new Consumer<Integer>(){

            @Override
            public final void accept(Integer it) {
                maxMonitors = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getREQUEST_TIMEOUT(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                requestTimeout = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getINDEX_TIMEOUT(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                indexTimeout = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getMAX_ACTION_THROTTLE_VALUE(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                maxActionThrottle = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DestinationSettings.Companion.getALLOW_LIST(), (Consumer)new Consumer<List<? extends String>>(){

            @Override
            public final void accept(List<String> it) {
                allowList = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), (Consumer)new Consumer<Boolean>(){

            @Override
            public final void accept(Boolean it) {
                filterByEnabled = it;
            }
        });
    }

    public static final /* synthetic */ List access$getAllowList$p(TransportIndexMonitorAction $this) {
        return $this.allowList;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0002J\u0006\u0010\u001c\u001a\u00020\u0011J\u0006\u0010\u001d\u001a\u00020\u0011J\u0006\u0010\u001e\u001a\u00020\u0011J\b\u0010\u001f\u001a\u00020\u0011H\u0002J \u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportIndexMonitorAction$IndexMonitorHandler;", "", "client", "Lorg/elasticsearch/client/Client;", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexMonitorResponse;", "request", "Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexMonitorRequest;", "user", "Lcom/amazon/opendistroforelasticsearch/commons/authuser/User;", "(Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportIndexMonitorAction;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/action/ActionListener;Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexMonitorRequest;Lcom/amazon/opendistroforelasticsearch/commons/authuser/User;)V", "checkShardsFailure", "", "response", "Lorg/elasticsearch/action/index/IndexResponse;", "indexMonitor", "", "onCreateMappingsResponse", "Lorg/elasticsearch/action/admin/indices/create/CreateIndexResponse;", "onGetResponse", "currentMonitor", "Lcom/amazon/opendistroforelasticsearch/alerting/model/Monitor;", "onSearchResponse", "Lorg/elasticsearch/action/search/SearchResponse;", "onUpdateMappingsResponse", "Lorg/elasticsearch/action/support/master/AcknowledgedResponse;", "prepareMonitorIndexing", "resolveUserAndStart", "resolveUserAndStartForAD", "start", "updateMonitor", "validateActionThrottle", "monitor", "maxValue", "Lorg/elasticsearch/common/unit/TimeValue;", "minValue", "opendistro-alerting"})
    public final class IndexMonitorHandler {
        private final Client client;
        private final ActionListener<IndexMonitorResponse> actionListener;
        private final IndexMonitorRequest request;
        private final User user;

        public final void resolveUserAndStart() {
            if (this.user == null) {
                List list;
                String string = "";
                Instant instant = null;
                Instant instant2 = null;
                Schedule schedule = null;
                boolean bl = false;
                String string2 = null;
                long l = 0L;
                String string3 = null;
                Monitor monitor = this.request.getMonitor();
                IndexMonitorRequest indexMonitorRequest = this.request;
                boolean bl2 = false;
                List list2 = CollectionsKt.emptyList();
                bl2 = false;
                List list3 = CollectionsKt.emptyList();
                bl2 = false;
                List list4 = list = CollectionsKt.emptyList();
                List list5 = list3;
                List list6 = list2;
                String string4 = string;
                indexMonitorRequest.setMonitor(Monitor.copy$default(monitor, string3, l, string2, bl, schedule, instant2, instant, new User(string4, list6, list5, list4), 0, null, null, null, 3967, null));
                this.start();
            } else {
                this.request.setMonitor(Monitor.copy$default(this.request.getMonitor(), null, 0L, null, false, null, null, null, new User(this.user.getName(), this.user.getBackendRoles(), this.user.getRoles(), this.user.getCustomAttNames()), 0, null, null, null, 3967, null));
                this.start();
            }
        }

        public final void resolveUserAndStartForAD() {
            if (this.user == null) {
                List list;
                String string = "";
                Instant instant = null;
                Instant instant2 = null;
                Schedule schedule = null;
                boolean bl = false;
                String string2 = null;
                long l = 0L;
                String string3 = null;
                Monitor monitor = this.request.getMonitor();
                IndexMonitorRequest indexMonitorRequest = this.request;
                boolean bl2 = false;
                List list2 = CollectionsKt.emptyList();
                bl2 = false;
                List list3 = CollectionsKt.emptyList();
                bl2 = false;
                List list4 = list = CollectionsKt.emptyList();
                List list5 = list3;
                List list6 = list2;
                String string4 = string;
                indexMonitorRequest.setMonitor(Monitor.copy$default(monitor, string3, l, string2, bl, schedule, instant2, instant, new User(string4, list6, list5, list4), 0, null, null, null, 3967, null));
                this.start();
            } else {
                try {
                    SearchSourceBuilder searchSourceBuilder;
                    this.request.setMonitor(Monitor.copy$default(this.request.getMonitor(), null, 0L, null, false, null, null, null, new User(this.user.getName(), this.user.getBackendRoles(), this.user.getRoles(), this.user.getCustomAttNames()), 0, null, null, null, 3967, null));
                    SearchSourceBuilder searchSourceBuilder2 = searchSourceBuilder = new SearchSourceBuilder().size(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)searchSourceBuilder2, (String)"searchSourceBuilder");
                    AnomalyDetectionUtilsKt.addUserBackendRolesFilter(this.user, searchSourceBuilder2);
                    SearchRequest searchRequest = new SearchRequest().indices(new String[]{".opendistro-anomaly-detectors"}).source(searchSourceBuilder);
                    this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
                        final /* synthetic */ IndexMonitorHandler this$0;

                        public void onResponse(@Nullable SearchResponse response2) {
                            Long totalHits;
                            SearchResponse searchResponse = response2;
                            Long l = searchResponse != null && (searchResponse = searchResponse.getHits()) != null && (searchResponse = searchResponse.getTotalHits()) != null ? Long.valueOf(searchResponse.value) : (totalHits = null);
                            if (totalHits != null && totalHits > 0L) {
                                this.this$0.start();
                            } else {
                                IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("User has no available detectors", RestStatus.NOT_FOUND, new Object[0])));
                            }
                        }

                        public void onFailure(@NotNull Exception t) {
                            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                            IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                        }
                        {
                            this.this$0 = $outer;
                        }
                    });
                }
                catch (IOException ex) {
                    this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(ex));
                }
            }
        }

        public final void start() {
            if (!TransportIndexMonitorAction.this.getScheduledJobIndices().scheduledJobIndexExists()) {
                TransportIndexMonitorAction.this.getScheduledJobIndices().initScheduledJobIndex((ActionListener)new ActionListener<CreateIndexResponse>(this){
                    final /* synthetic */ IndexMonitorHandler this$0;

                    public void onResponse(@NotNull CreateIndexResponse response2) {
                        Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                        IndexMonitorHandler.access$onCreateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
            } else if (!IndexUtils.Companion.getScheduledJobIndexUpdated()) {
                String string = ScheduledJobIndices.Companion.scheduledJobMappings();
                ClusterState clusterState = TransportIndexMonitorAction.this.getClusterService().state();
                Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterService.state()");
                IndicesAdminClient indicesAdminClient = this.client.admin().indices();
                Intrinsics.checkExpressionValueIsNotNull((Object)indicesAdminClient, (String)"client.admin().indices()");
                IndexUtils.Companion.updateIndexMapping(".opendistro-alerting-config", "_doc", string, clusterState, indicesAdminClient, (ActionListener<AcknowledgedResponse>)((ActionListener)new ActionListener<AcknowledgedResponse>(this){
                    final /* synthetic */ IndexMonitorHandler this$0;

                    public void onResponse(@NotNull AcknowledgedResponse response2) {
                        Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                        IndexMonitorHandler.access$onUpdateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                    {
                        this.this$0 = $outer;
                    }
                }));
            } else {
                this.prepareMonitorIndexing();
            }
        }

        private final void prepareMonitorIndexing() {
            try {
                Monitor monitor = this.request.getMonitor();
                TimeValue timeValue = TransportIndexMonitorAction.this.maxActionThrottle;
                Intrinsics.checkExpressionValueIsNotNull((Object)timeValue, (String)"maxActionThrottle");
                TimeValue timeValue2 = TimeValue.timeValueMinutes((long)1L);
                Intrinsics.checkExpressionValueIsNotNull((Object)timeValue2, (String)"TimeValue.timeValueMinutes(1)");
                this.validateActionThrottle(monitor, timeValue, timeValue2);
            }
            catch (RuntimeException e) {
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(e));
                return;
            }
            if (this.request.getMethod() == RestRequest.Method.PUT) {
                this.updateMonitor();
                return;
            }
            BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"monitor.type", (String)"monitor"));
            SearchSourceBuilder searchSource = new SearchSourceBuilder().query((QueryBuilder)query).timeout(TransportIndexMonitorAction.this.requestTimeout);
            SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-alerting-config"}).source(searchSource);
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
                final /* synthetic */ IndexMonitorHandler this$0;

                public void onResponse(@NotNull SearchResponse searchResponse) {
                    Intrinsics.checkParameterIsNotNull((Object)searchResponse, (String)"searchResponse");
                    IndexMonitorHandler.access$onSearchResponse(this.this$0, searchResponse);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        private final void validateActionThrottle(Monitor monitor, TimeValue maxValue, TimeValue minValue) {
            Iterable $this$forEach$iv = monitor.getTriggers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Trigger trigger = (Trigger)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = trigger.getActions();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Action action = (Action)element$iv2;
                    boolean bl2 = false;
                    if (action.getThrottle() == null) continue;
                    boolean bl3 = new TimeValue(Duration.of(action.getThrottle().getValue(), action.getThrottle().getUnit()).toMillis()).compareTo(maxValue) <= 0;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = "Can only set throttle period less than or equal to " + maxValue;
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    bl3 = new TimeValue(Duration.of(action.getThrottle().getValue(), action.getThrottle().getUnit()).toMillis()).compareTo(minValue) >= 0;
                    bl4 = false;
                    bl5 = false;
                    if (bl3) continue;
                    boolean bl7 = false;
                    String string = "Can only set throttle period greater than or equal to " + minValue;
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void onSearchResponse(SearchResponse response2) {
            Long totalHits;
            SearchHits searchHits = response2.getHits();
            Intrinsics.checkExpressionValueIsNotNull((Object)searchHits, (String)"response.hits");
            TotalHits totalHits2 = searchHits.getTotalHits();
            Long l = totalHits = totalHits2 != null ? Long.valueOf(totalHits2.value) : null;
            if (totalHits != null) {
                long l2 = totalHits;
                Integer n = TransportIndexMonitorAction.this.maxMonitors;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"maxMonitors");
                if (l2 >= (long)n.intValue()) {
                    TransportIndexMonitorActionKt.access$getLog$p().error("This request would create more than the allowed monitors [" + TransportIndexMonitorAction.this.maxMonitors + "].");
                    this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(new IllegalArgumentException("This request would create more than the allowed monitors [" + TransportIndexMonitorAction.this.maxMonitors + "].")));
                    return;
                }
            }
            this.indexMonitor();
        }

        private final void onCreateMappingsResponse(CreateIndexResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexMonitorActionKt.access$getLog$p().info("Created .opendistro-alerting-config with mappings.");
                this.prepareMonitorIndexing();
                IndexUtils.Companion.scheduledJobIndexUpdated();
            } else {
                TransportIndexMonitorActionKt.access$getLog$p().error("Create .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("Create .opendistro-alerting-config mappings call not acknowledged", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void onUpdateMappingsResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexMonitorActionKt.access$getLog$p().info("Updated  .opendistro-alerting-config with mappings.");
                IndexUtils.Companion.scheduledJobIndexUpdated();
                this.prepareMonitorIndexing();
            } else {
                TransportIndexMonitorActionKt.access$getLog$p().error("Update .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("Updated .opendistro-alerting-config mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void indexMonitor() {
            this.request.setMonitor(Monitor.copy$default(this.request.getMonitor(), null, 0L, null, false, null, null, null, null, IndexUtils.Companion.getScheduledJobIndexSchemaVersion(), null, null, null, 3839, null));
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(this.request.getRefreshPolicy());
            Monitor monitor = this.request.getMonitor();
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"jsonBuilder()");
            IndexRequest indexRequest2 = (IndexRequest)indexRequest.source(monitor.toXContent(xContentBuilder, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexMonitorAction.this.indexTimeout);
            this.client.index(indexRequest2, (ActionListener)new ActionListener<IndexResponse>(this){
                final /* synthetic */ IndexMonitorHandler this$0;

                public void onResponse(@NotNull IndexResponse response2) {
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    String failureReasons = IndexMonitorHandler.access$checkShardsFailure(this.this$0, response2);
                    if (failureReasons != null) {
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException(failureReasons.toString(), response2.status(), new Object[0])));
                        return;
                    }
                    ActionListener actionListener = IndexMonitorHandler.access$getActionListener$p(this.this$0);
                    String string = response2.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.id");
                    actionListener.onResponse((Object)((Object)new IndexMonitorResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.CREATED, IndexMonitorHandler.access$getRequest$p(this.this$0).getMonitor())));
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        private final void updateMonitor() {
            GetRequest getRequest = new GetRequest(".opendistro-alerting-config", this.request.getMonitorId());
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this){
                final /* synthetic */ IndexMonitorHandler this$0;

                public void onResponse(@NotNull GetResponse response2) {
                    XContentParser xcp;
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("Monitor with " + IndexMonitorHandler.access$getRequest$p(this.this$0).getMonitorId() + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    XContentParser xContentParser = xcp = XContentHelper.createParser((NamedXContentRegistry)this.this$0.TransportIndexMonitorAction.this.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (XContentType)XContentType.JSON);
                    Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"xcp");
                    String string = response2.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.id");
                    ScheduledJob scheduledJob = ScheduledJob.Companion.parse(xContentParser, string, response2.getVersion());
                    if (scheduledJob == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.amazon.opendistroforelasticsearch.alerting.model.Monitor");
                    }
                    Monitor monitor = (Monitor)scheduledJob;
                    IndexMonitorHandler.access$onGetResponse(this.this$0, monitor);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        private final void onGetResponse(Monitor currentMonitor) {
            Boolean bl = TransportIndexMonitorAction.this.filterByEnabled;
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"filterByEnabled");
            if (!AlertingUtilsKt.checkUserFilterByPermissions(bl, this.user, currentMonitor.getUser(), this.actionListener, "monitor", this.request.getMonitorId())) {
                return;
            }
            if (this.request.getMonitor().getEnabled() && currentMonitor.getEnabled()) {
                this.request.setMonitor(Monitor.copy$default(this.request.getMonitor(), null, 0L, null, false, null, null, currentMonitor.getEnabledTime(), null, 0, null, null, null, 4031, null));
            }
            this.request.setMonitor(Monitor.copy$default(this.request.getMonitor(), null, 0L, null, false, null, null, null, null, IndexUtils.Companion.getScheduledJobIndexSchemaVersion(), null, null, null, 3839, null));
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(this.request.getRefreshPolicy());
            Monitor monitor = this.request.getMonitor();
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"jsonBuilder()");
            IndexRequest indexRequest2 = (IndexRequest)indexRequest.source(monitor.toXContent(xContentBuilder, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).id(this.request.getMonitorId()).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexMonitorAction.this.indexTimeout);
            this.client.index(indexRequest2, (ActionListener)new ActionListener<IndexResponse>(this){
                final /* synthetic */ IndexMonitorHandler this$0;

                public void onResponse(@NotNull IndexResponse response2) {
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    String failureReasons = IndexMonitorHandler.access$checkShardsFailure(this.this$0, response2);
                    if (failureReasons != null) {
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException(failureReasons.toString(), response2.status(), new Object[0])));
                        return;
                    }
                    ActionListener actionListener = IndexMonitorHandler.access$getActionListener$p(this.this$0);
                    String string = response2.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.id");
                    actionListener.onResponse((Object)((Object)new IndexMonitorResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.CREATED, IndexMonitorHandler.access$getRequest$p(this.this$0).getMonitor())));
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        private final String checkShardsFailure(IndexResponse response2) {
            StringBuilder failureReasons = new StringBuilder();
            ReplicationResponse.ShardInfo shardInfo = response2.getShardInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)shardInfo, (String)"response.shardInfo");
            if (shardInfo.getFailed() > 0) {
                ReplicationResponse.ShardInfo shardInfo2 = response2.getShardInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)shardInfo2, (String)"response.shardInfo");
                ReplicationResponse.ShardInfo.Failure[] failureArray = shardInfo2.getFailures();
                Intrinsics.checkExpressionValueIsNotNull((Object)failureArray, (String)"response.shardInfo.failures");
                ReplicationResponse.ShardInfo.Failure[] $this$forEach$iv = failureArray;
                boolean $i$f$forEach = false;
                ReplicationResponse.ShardInfo.Failure[] failureArray2 = $this$forEach$iv;
                int n = failureArray2.length;
                for (int i = 0; i < n; ++i) {
                    ReplicationResponse.ShardInfo.Failure element$iv;
                    ReplicationResponse.ShardInfo.Failure entry = element$iv = failureArray2[i];
                    boolean bl = false;
                    failureReasons.append(entry.reason());
                }
                return failureReasons.toString();
            }
            return null;
        }

        public IndexMonitorHandler(@NotNull Client client, @NotNull ActionListener<IndexMonitorResponse> actionListener, @Nullable IndexMonitorRequest request, User user) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
            Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexMonitorHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ void access$onCreateMappingsResponse(IndexMonitorHandler $this, CreateIndexResponse response2) {
            $this.onCreateMappingsResponse(response2);
        }

        public static final /* synthetic */ void access$onUpdateMappingsResponse(IndexMonitorHandler $this, AcknowledgedResponse response2) {
            $this.onUpdateMappingsResponse(response2);
        }

        public static final /* synthetic */ void access$onSearchResponse(IndexMonitorHandler $this, SearchResponse response2) {
            $this.onSearchResponse(response2);
        }

        public static final /* synthetic */ String access$checkShardsFailure(IndexMonitorHandler $this, IndexResponse response2) {
            return $this.checkShardsFailure(response2);
        }

        public static final /* synthetic */ IndexMonitorRequest access$getRequest$p(IndexMonitorHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ void access$onGetResponse(IndexMonitorHandler $this, Monitor currentMonitor) {
            $this.onGetResponse(currentMonitor);
        }
    }
}

