/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.transport;

import com.amazon.opendistroforelasticsearch.alerting.action.IndexEmailGroupAction;
import com.amazon.opendistroforelasticsearch.alerting.action.IndexEmailGroupRequest;
import com.amazon.opendistroforelasticsearch.alerting.action.IndexEmailGroupResponse;
import com.amazon.opendistroforelasticsearch.alerting.core.ScheduledJobIndices;
import com.amazon.opendistroforelasticsearch.alerting.model.destination.email.EmailGroup;
import com.amazon.opendistroforelasticsearch.alerting.settings.AlertingSettings;
import com.amazon.opendistroforelasticsearch.alerting.settings.DestinationSettings;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportIndexEmailGroupActionKt;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportIndexEmailGroupActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0;
import com.amazon.opendistroforelasticsearch.alerting.util.AlertingException;
import com.amazon.opendistroforelasticsearch.alerting.util.DestinationType;
import com.amazon.opendistroforelasticsearch.alerting.util.IndexUtils;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001(B?\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J&\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0014R\"\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0015 \u0016*\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006)"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportIndexEmailGroupAction;", "Lorg/elasticsearch/action/support/HandledTransportAction;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexEmailGroupRequest;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexEmailGroupResponse;", "transportService", "Lorg/elasticsearch/transport/TransportService;", "client", "Lorg/elasticsearch/client/Client;", "actionFilters", "Lorg/elasticsearch/action/support/ActionFilters;", "scheduledJobIndices", "Lcom/amazon/opendistroforelasticsearch/alerting/core/ScheduledJobIndices;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "settings", "Lorg/elasticsearch/common/settings/Settings;", "xContentRegistry", "Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "(Lorg/elasticsearch/transport/TransportService;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/action/support/ActionFilters;Lcom/amazon/opendistroforelasticsearch/alerting/core/ScheduledJobIndices;Lorg/elasticsearch/cluster/service/ClusterService;Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;)V", "allowList", "", "", "kotlin.jvm.PlatformType", "getClient", "()Lorg/elasticsearch/client/Client;", "getClusterService", "()Lorg/elasticsearch/cluster/service/ClusterService;", "indexTimeout", "Lorg/elasticsearch/common/unit/TimeValue;", "getScheduledJobIndices", "()Lcom/amazon/opendistroforelasticsearch/alerting/core/ScheduledJobIndices;", "getXContentRegistry", "()Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/elasticsearch/tasks/Task;", "request", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "IndexEmailGroupHandler", "opendistro-alerting"})
public final class TransportIndexEmailGroupAction
extends HandledTransportAction<IndexEmailGroupRequest, IndexEmailGroupResponse> {
    private volatile TimeValue indexTimeout;
    private volatile List<String> allowList;
    @NotNull
    private final Client client;
    @NotNull
    private final ScheduledJobIndices scheduledJobIndices;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull IndexEmailGroupRequest request, @NotNull ActionListener<IndexEmailGroupResponse> actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        ThreadPool threadPool = this.client.threadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadPool, (String)"client.threadPool()");
        AutoCloseable autoCloseable = (AutoCloseable)threadPool.getThreadContext().stashContext();
        boolean bl = false;
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl2 = false;
            new IndexEmailGroupHandler(this.client, actionListener, request).start();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ScheduledJobIndices getScheduledJobIndices() {
        return this.scheduledJobIndices;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Inject
    public TransportIndexEmailGroupAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ScheduledJobIndices scheduledJobIndices, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)transportService, (String)"transportService");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkParameterIsNotNull((Object)scheduledJobIndices, (String)"scheduledJobIndices");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)xContentRegistry, (String)"xContentRegistry");
        String string = IndexEmailGroupAction.Companion.getNAME();
        Object object = 1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new TransportIndexEmailGroupActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0(function1);
        }
        super(string, transportService, actionFilters, (Writeable.Reader)object);
        this.client = client;
        this.scheduledJobIndices = scheduledJobIndices;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.indexTimeout = (TimeValue)AlertingSettings.Companion.getINDEX_TIMEOUT().get(settings);
        this.allowList = (List)DestinationSettings.Companion.getALLOW_LIST().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getINDEX_TIMEOUT(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                indexTimeout = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DestinationSettings.Companion.getALLOW_LIST(), (Consumer)new Consumer<List<? extends String>>(){

            @Override
            public final void accept(List<String> it) {
                allowList = it;
            }
        });
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\u0006\u0010\u0019\u001a\u00020\u000fJ\b\u0010\u001a\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportIndexEmailGroupAction$IndexEmailGroupHandler;", "", "client", "Lorg/elasticsearch/client/Client;", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexEmailGroupResponse;", "request", "Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexEmailGroupRequest;", "(Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportIndexEmailGroupAction;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/action/ActionListener;Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexEmailGroupRequest;)V", "checkShardsFailure", "", "response", "Lorg/elasticsearch/action/index/IndexResponse;", "indexEmailGroup", "", "update", "", "onCreateMappingsResponse", "Lorg/elasticsearch/action/admin/indices/create/CreateIndexResponse;", "onGetResponse", "Lorg/elasticsearch/action/get/GetResponse;", "onUpdateMappingsResponse", "Lorg/elasticsearch/action/support/master/AcknowledgedResponse;", "prepareEmailGroupIndexing", "start", "updateEmailGroup", "opendistro-alerting"})
    public final class IndexEmailGroupHandler {
        private final Client client;
        private final ActionListener<IndexEmailGroupResponse> actionListener;
        private final IndexEmailGroupRequest request;

        public final void start() {
            if (!TransportIndexEmailGroupAction.this.getScheduledJobIndices().scheduledJobIndexExists()) {
                TransportIndexEmailGroupAction.this.getScheduledJobIndices().initScheduledJobIndex((ActionListener)new ActionListener<CreateIndexResponse>(this){
                    final /* synthetic */ IndexEmailGroupHandler this$0;

                    public void onResponse(@NotNull CreateIndexResponse response2) {
                        Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                        IndexEmailGroupHandler.access$onCreateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        IndexEmailGroupHandler.access$getActionListener$p(this.this$0).onFailure(e);
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
            } else if (!IndexUtils.Companion.getScheduledJobIndexUpdated()) {
                String string = ScheduledJobIndices.Companion.scheduledJobMappings();
                ClusterState clusterState = TransportIndexEmailGroupAction.this.getClusterService().state();
                Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterService.state()");
                IndicesAdminClient indicesAdminClient = this.client.admin().indices();
                Intrinsics.checkExpressionValueIsNotNull((Object)indicesAdminClient, (String)"client.admin().indices()");
                IndexUtils.Companion.updateIndexMapping(".opendistro-alerting-config", "_doc", string, clusterState, indicesAdminClient, (ActionListener<AcknowledgedResponse>)((ActionListener)new ActionListener<AcknowledgedResponse>(this){
                    final /* synthetic */ IndexEmailGroupHandler this$0;

                    public void onResponse(@NotNull AcknowledgedResponse response2) {
                        Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                        IndexEmailGroupHandler.access$onUpdateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        IndexEmailGroupHandler.access$getActionListener$p(this.this$0).onFailure(e);
                    }
                    {
                        this.this$0 = $outer;
                    }
                }));
            } else {
                this.prepareEmailGroupIndexing();
            }
        }

        private final void prepareEmailGroupIndexing() {
            if (!TransportIndexEmailGroupAction.this.allowList.contains(DestinationType.EMAIL.getValue())) {
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("This API is blocked since Destination type [" + (Object)((Object)DestinationType.EMAIL) + "] is not allowed", RestStatus.FORBIDDEN, new Object[0])));
                return;
            }
            if (this.request.getMethod() == RestRequest.Method.PUT) {
                this.updateEmailGroup();
            } else {
                IndexEmailGroupHandler.indexEmailGroup$default(this, false, 1, null);
            }
        }

        private final void onCreateMappingsResponse(CreateIndexResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexEmailGroupActionKt.access$getLog$p().info("Created .opendistro-alerting-config with mappings.");
                this.prepareEmailGroupIndexing();
                IndexUtils.Companion.scheduledJobIndexUpdated();
            } else {
                TransportIndexEmailGroupActionKt.access$getLog$p().error("Create .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("Create .opendistro-alerting-config mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void onUpdateMappingsResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexEmailGroupActionKt.access$getLog$p().info("Updated .opendistro-alerting-config with mappings.");
                IndexUtils.Companion.scheduledJobIndexUpdated();
                this.prepareEmailGroupIndexing();
            } else {
                TransportIndexEmailGroupActionKt.access$getLog$p().error("Update .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("Update .opendistro-alerting-config mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void indexEmailGroup(boolean update) {
            this.request.setEmailGroup(EmailGroup.copy$default(this.request.getEmailGroup(), null, 0L, IndexUtils.Companion.getScheduledJobIndexSchemaVersion(), null, null, 27, null));
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(this.request.getRefreshPolicy());
            EmailGroup emailGroup = this.request.getEmailGroup();
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"jsonBuilder()");
            IndexRequest indexRequest2 = (IndexRequest)indexRequest.source(emailGroup.toXContent(xContentBuilder, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexEmailGroupAction.this.indexTimeout);
            if (update) {
                indexRequest2 = indexRequest2.id(this.request.getEmailGroupID());
            }
            this.client.index(indexRequest2, (ActionListener)new ActionListener<IndexResponse>(this){
                final /* synthetic */ IndexEmailGroupHandler this$0;

                public void onResponse(@NotNull IndexResponse response2) {
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    String failureReasons = IndexEmailGroupHandler.access$checkShardsFailure(this.this$0, response2);
                    if (failureReasons != null) {
                        IndexEmailGroupHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException(failureReasons.toString(), response2.status(), new Object[0])));
                        return;
                    }
                    ActionListener actionListener = IndexEmailGroupHandler.access$getActionListener$p(this.this$0);
                    String string = response2.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.id");
                    actionListener.onResponse((Object)((Object)new IndexEmailGroupResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.CREATED, IndexEmailGroupHandler.access$getRequest$p(this.this$0).getEmailGroup())));
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    IndexEmailGroupHandler.access$getActionListener$p(this.this$0).onFailure(e);
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        static /* synthetic */ void indexEmailGroup$default(IndexEmailGroupHandler indexEmailGroupHandler, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            indexEmailGroupHandler.indexEmailGroup(bl);
        }

        private final void updateEmailGroup() {
            GetRequest getRequest = new GetRequest(".opendistro-alerting-config", this.request.getEmailGroupID());
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this){
                final /* synthetic */ IndexEmailGroupHandler this$0;

                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    IndexEmailGroupHandler.access$onGetResponse(this.this$0, response2);
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    IndexEmailGroupHandler.access$getActionListener$p(this.this$0).onFailure(e);
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        private final void onGetResponse(GetResponse response2) {
            if (!response2.isExists()) {
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("EmailGroup with " + this.request.getEmailGroupID() + " was not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            this.indexEmailGroup(true);
        }

        private final String checkShardsFailure(IndexResponse response2) {
            StringBuilder failureReasons = new StringBuilder();
            ReplicationResponse.ShardInfo shardInfo = response2.getShardInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)shardInfo, (String)"response.shardInfo");
            if (shardInfo.getFailed() > 0) {
                ReplicationResponse.ShardInfo shardInfo2 = response2.getShardInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)shardInfo2, (String)"response.shardInfo");
                ReplicationResponse.ShardInfo.Failure[] failureArray = shardInfo2.getFailures();
                Intrinsics.checkExpressionValueIsNotNull((Object)failureArray, (String)"response.shardInfo.failures");
                ReplicationResponse.ShardInfo.Failure[] $this$forEach$iv = failureArray;
                boolean $i$f$forEach = false;
                ReplicationResponse.ShardInfo.Failure[] failureArray2 = $this$forEach$iv;
                int n = failureArray2.length;
                for (int i = 0; i < n; ++i) {
                    ReplicationResponse.ShardInfo.Failure element$iv;
                    ReplicationResponse.ShardInfo.Failure entry = element$iv = failureArray2[i];
                    boolean bl = false;
                    failureReasons.append(entry.reason());
                }
                return failureReasons.toString();
            }
            return null;
        }

        public IndexEmailGroupHandler(@NotNull Client client, @NotNull ActionListener<IndexEmailGroupResponse> actionListener, IndexEmailGroupRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
            Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
        }

        public static final /* synthetic */ void access$onCreateMappingsResponse(IndexEmailGroupHandler $this, CreateIndexResponse response2) {
            $this.onCreateMappingsResponse(response2);
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexEmailGroupHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ void access$onUpdateMappingsResponse(IndexEmailGroupHandler $this, AcknowledgedResponse response2) {
            $this.onUpdateMappingsResponse(response2);
        }

        public static final /* synthetic */ String access$checkShardsFailure(IndexEmailGroupHandler $this, IndexResponse response2) {
            return $this.checkShardsFailure(response2);
        }

        public static final /* synthetic */ IndexEmailGroupRequest access$getRequest$p(IndexEmailGroupHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ void access$onGetResponse(IndexEmailGroupHandler $this, GetResponse response2) {
            $this.onGetResponse(response2);
        }
    }
}

